/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.RunData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class ALXlsScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALXlsScreen.class.getName());
    protected boolean hasAuthority;

    protected void doOutput(RunData rundata) throws Exception {
        VelocityContext context = new VelocityContext();
        ServletOutputStream out = null;
        try {
            this.init(rundata, (Context)context);
            this.doCheckAclPermission(rundata, (Context)context, this.getDefineAclType());
            String realpath = TurbineServlet.getRealPath((String)(this.getFolderPath() + File.separator + this.getFileName()));
            if (realpath == null || "".equals(realpath)) {
                return;
            }
            this.createXLSFile(rundata, (Context)context, realpath);
            DataInputStream in = new DataInputStream(new FileInputStream(realpath));
            HttpServletResponse response = rundata.getResponse();
            response.setHeader("Content-disposition", "attachment; filename=\"" + this.getFileName() + "\"");
            response.setHeader("Cache-Control", "aipo");
            response.setHeader("Pragma", "aipo");
            out = response.getOutputStream();
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = ((InputStream)in).read(b)) != -1) {
                out.write(b, 0, len);
                out.flush();
            }
            ((InputStream)in).close();
            out.flush();
            out.close();
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
        }
        catch (Exception e) {
            logger.error("[ERROR]", e);
        }
    }

    public void init(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    }

    protected boolean createXLSFile(RunData rundata, Context context, String filepath) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            this.createHSSFWorkbook(rundata, context, wb);
            File file = new File(filepath);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream output = new FileOutputStream(file);
            wb.write((OutputStream)output);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected abstract boolean createHSSFWorkbook(RunData var1, Context var2, HSSFWorkbook var3);

    protected abstract String getFolderPath();

    protected abstract String getFileName();

    protected HSSFSheet createHSSFSheet(HSSFWorkbook wb, String sheet_name, String[] headers, short[] cell_enc_types) {
        HSSFSheet sheet = wb.createSheet(sheet_name);
        wb.setSheetName(0, sheet_name, (short)1);
        HSSFRow row1 = sheet.createRow(0);
        int len = headers.length;
        for (int i = 0; i < len; ++i) {
            HSSFCell cell_row1 = row1.createCell((short)i);
            cell_row1.setEncoding((short)1);
            cell_row1.setCellValue(headers[i]);
        }
        return sheet;
    }

    protected void addRow(HSSFRow newrow, short[] cell_enc_types, String[] rows) {
        int len = rows.length;
        for (int j = 0; j < len; ++j) {
            HSSFCell cell_newrow = newrow.createCell((short)j);
            if (cell_enc_types[j] == 0) {
                try {
                    cell_newrow.setCellValue(Double.parseDouble(rows[j]));
                }
                catch (Exception e) {
                    cell_newrow.setCellValue("");
                }
                continue;
            }
            if (cell_enc_types[j] == 1) {
                cell_newrow.setEncoding(cell_enc_types[j]);
                cell_newrow.setCellValue(rows[j]);
                continue;
            }
            cell_newrow.setCellValue(rows[j]);
        }
    }

    protected String getContentType(RunData rundata) {
        return "application/octet-stream";
    }

    public void setResultData(Object obj) {
    }

    public void addResultData(Object obj) {
    }

    public void setResultDataList(ArrayList objList) {
    }

    public void addErrorMessage(String msg) {
    }

    public void addErrorMessages(ArrayList msgs) {
    }

    public void setErrorMessages(ArrayList msgs) {
    }

    public void setMode(String mode) {
    }

    public String getMode() {
        return null;
    }

    public void putData(RunData rundata, Context context) {
    }

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId(rundata), pfeature, defineAclType);
        if (!this.hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    public boolean hasAuthority() {
        return this.hasAuthority;
    }

    protected int getDefineAclType() {
        return 32;
    }

    public String getAclPortletFeature() {
        return null;
    }
}

