/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public abstract class ALVelocityScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALVelocityScreen.class.getName());
    private static final String CONTENT_TYPE = "text/json;charset=" + ALEipConstants.DEF_CONTENT_ENCODING;
    private String mode;
    private Object result;
    private ArrayList resultList;
    private ArrayList msgList;
    private ArrayList errmsgList;

    protected void setTemplate(RunData rundata, Context context, String template) {
        try {
            ServletOutputStream out = null;
            HttpServletResponse response = rundata.getResponse();
            out = response.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
            Template templete = Velocity.getTemplate((String)template);
            templete.merge(context, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            logger.error("[ALVelocityScreen]", e);
        }
    }

    protected void doOutput(RunData rundata) throws Exception {
        VelocityContext context = new VelocityContext();
        this.mode = rundata.getParameters().getString("mode");
        try {
            ALEipUtils.setupContext(rundata, (Context)context);
            this.doOutput(rundata, (Context)context);
        }
        catch (Exception ex) {
            logger.error("[ALVelocityScreen] Exception.", ex);
            ALEipUtils.redirectDBError(rundata);
        }
    }

    protected abstract void doOutput(RunData var1, Context var2) throws Exception;

    public void setResultData(Object obj) {
        this.result = obj;
    }

    public void addResultData(Object obj) {
        if (this.resultList == null) {
            this.resultList = new ArrayList();
        }
        this.resultList.add(obj);
    }

    public void setResultDataList(ArrayList objList) {
        this.resultList = objList;
    }

    public void addErrorMessage(String msg) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList();
        }
        this.errmsgList.add(msg);
    }

    public void addErrorMessages(ArrayList msgs) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList();
        }
        this.errmsgList.addAll(msgs);
    }

    public void setErrorMessages(ArrayList msgs) {
        this.errmsgList = msgs;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void putData(RunData rundata, Context context) {
        context.put("mode", (Object)this.mode);
        context.put("result", this.result);
        context.put("results", (Object)this.resultList);
        context.put("msgs", (Object)this.msgList);
        context.put("errmsgs", (Object)this.errmsgList);
        context.put("entityid", (Object)ALEipUtils.getTemp(rundata, context, "entityid"));
        context.put("utils", (Object)new ALCommonUtils());
    }

    protected String getContentType(RunData rundata) {
        return CONTENT_TYPE;
    }
}

