/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class ALJSONScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALJSONScreen.class.getName());
    private static final String CONTENT_TYPE = "text/json;charset=" + ALEipConstants.DEF_CONTENT_ENCODING;
    private String mode = "";
    private Object result;
    private ArrayList resultList;
    private ArrayList msgList;
    private ArrayList errmsgList;

    protected void doOutput(RunData rundata) throws Exception {
        ServletOutputStream out = null;
        VelocityContext context = new VelocityContext();
        this.mode = rundata.getParameters().containsKey((Object)"mode") ? rundata.getParameters().getString("mode") : "";
        try {
            ALEipUtils.setupContext(rundata, (Context)context);
            StringBuffer result = new StringBuffer().append("/* ").append(this.getJSONString(rundata, (Context)context)).append(" */");
            HttpServletResponse response = rundata.getResponse();
            out = response.getOutputStream();
            out.print(result.toString());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error("[ERROR]", e);
        }
    }

    protected String getContentType(RunData rundata) {
        return CONTENT_TYPE;
    }

    protected abstract String getJSONString(RunData var1, Context var2) throws Exception;

    public void setResultData(Object obj) {
        this.result = obj;
    }

    public void addResultData(Object obj) {
        if (this.resultList == null) {
            this.resultList = new ArrayList();
        }
        this.resultList.add(obj);
    }

    public void setResultDataList(ArrayList objList) {
        this.resultList = objList;
    }

    public void addErrorMessage(String msg) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList();
        }
        this.errmsgList.add(msg);
    }

    public void addErrorMessages(ArrayList msgs) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList();
        }
        this.errmsgList.addAll(msgs);
    }

    public void setErrorMessages(ArrayList msgs) {
        this.errmsgList = msgs;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void putData(RunData rundata, Context context) {
        context.put("mode", (Object)this.mode);
        context.put("result", this.result);
        context.put("results", (Object)this.resultList);
        context.put("msgs", (Object)this.msgList);
        context.put("errmsgs", (Object)this.errmsgList);
        context.put("entityid", (Object)ALEipUtils.getTemp(rundata, context, "entityid"));
    }
}

