/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.jetspeed.modules.actions.JetspeedSessionValidator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class ALSessionValidator
extends JetspeedSessionValidator {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALSessionValidator.class.getName());

    public void doPerform(RunData data) throws Exception {
        CustomLocalizationService locService;
        Locale locale;
        try {
            super.doPerform(data);
        }
        catch (Throwable other) {
            data.setScreenTemplate(JetspeedResources.getString("template.error"));
            String message = other.getMessage() != null ? other.getMessage() : other.toString();
            data.setMessage(message);
            data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
            return;
        }
        JetspeedUser user = (JetspeedUser)data.getUser();
        if ((user == null || !user.hasLoggedIn()) && JetspeedResources.getBoolean("automatic.logon.enable", false)) {
            if (data.getRequest().getCookies() != null) {
                String userName = data.getCookies().getString("username", "");
                String loginCookieValue = data.getCookies().getString("logincookie", "");
                if (userName.length() > 0 && loginCookieValue.length() > 0) {
                    try {
                        user = JetspeedSecurity.getUser(userName);
                        if (user.getPerm("logincookie", "").equals(loginCookieValue)) {
                            data.setUser((User)user);
                            user.setHasLoggedIn(true);
                            user.updateLastLogin();
                            data.save();
                        }
                    }
                    catch (LoginException noSuchUser) {
                    }
                    catch (UnknownUserException unknownUser) {
                        logger.warn("Username from the cookie was not found: " + userName);
                    }
                    catch (Exception other) {
                        logger.error(other);
                    }
                }
            }
        } else if (!(user != null && user.hasLoggedIn() || JetspeedResources.getBoolean("automatic.logon.enable", false))) {
            String uri = data.getRequest().getRequestURI().trim();
            String servername = data.getServletConfig().getServletName();
            String template = data.getScreenTemplate();
            Class<?> cls = null;
            try {
                cls = Class.forName(new StringBuffer().append("com.aimluck.eip.modules.screens.").append(template).toString());
            }
            catch (Exception e) {
                cls = null;
            }
            String newTemplate = null;
            if (cls != null) {
                if (Class.forName("com.aimluck.eip.modules.screens.ALJSONScreen").isAssignableFrom(cls)) {
                    newTemplate = "ALJSONTimeoutScreen";
                } else if (Class.forName("com.aimluck.eip.modules.screens.ALVelocityScreen").isAssignableFrom(cls)) {
                    newTemplate = "ALVelocityTimeoutScreen";
                }
            }
            if (newTemplate != null) {
                data.setScreenTemplate(newTemplate);
                if (data.getSession() != null) {
                    try {
                        data.getSession().invalidate();
                    }
                    catch (IllegalStateException ex) {
                        logger.debug("\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            } else if (!uri.equals("/" + servername + "/portal/") && !uri.equals("/" + servername + "/portal")) {
                data.setScreenTemplate("Timeout");
                StringBuffer sb = new StringBuffer(uri);
                int count = 0;
                String key = null;
                Enumeration enu = data.getRequest().getParameterNames();
                if (enu.hasMoreElements()) {
                    sb.append("?");
                }
                while (enu.hasMoreElements()) {
                    if (count != 0) {
                        sb.append("&");
                    }
                    key = (String)enu.nextElement();
                    sb.append(key).append("=").append(data.getRequest().getParameter(key));
                    ++count;
                }
                data.getUser().setTemp("redirect", (Object)sb.toString());
                data.getUser().setTemp("alEipUtils", (Object)new ALEipUtils());
                data.getUser().setTemp("alEipManager", (Object)ALEipManager.getInstance());
                if (data.getSession() != null) {
                    try {
                        data.getSession().invalidate();
                    }
                    catch (IllegalStateException ex) {
                        logger.debug("\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            }
        }
        JetspeedRunData jdata = null;
        try {
            jdata = (JetspeedRunData)data;
        }
        catch (ClassCastException e) {
            logger.error("The RunData object does not implement the expected interface, please verify the RunData factory settings", e);
            return;
        }
        String language = data.getRequest().getParameter("js_language");
        if (null != language) {
            user.setPerm("language", language);
        }
        if ((locale = (locService = (CustomLocalizationService)ServiceUtil.getServiceByName("LocalizationService")).getLocale(data)) == null) {
            locale = new Locale(TurbineResources.getString((String)"locale.default.language", (String)"en"), TurbineResources.getString((String)"locale.default.country", (String)"US"));
        }
        data.getUser().setTemp("locale", (Object)locale);
        String paramPortlet = jdata.getParameters().getString("js_peid");
        if (paramPortlet != null && paramPortlet.length() > 0) {
            jdata.setJs_peid(paramPortlet);
        }
    }
}

