/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.AccountExpiredException;
import org.apache.jetspeed.services.security.CredentialExpiredException;
import org.apache.jetspeed.services.security.FailedLoginException;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.nosecurity.FakeJetspeedUser;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class ALJLoginUser
extends ActionEvent {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALJLoginUser.class.getName());
    public static String KEY_MYGROUP = "mygroup";

    public void doPerform(RunData rundata) throws Exception {
        try {
            String message;
            JetspeedRunData data = (JetspeedRunData)rundata;
            String username = data.getParameters().getString("username", "");
            String password = data.getParameters().getString("password", "");
            boolean newUserApproval = JetspeedResources.getBoolean("newuser.approval.enable", false);
            String secretkey = data.getParameters().getString("secretkey", null);
            if (secretkey != null) {
                String button1 = data.getParameters().getString("submit1", null);
                if (button1 != null && button1.equalsIgnoreCase("Cancel")) {
                    data.setScreenTemplate(TurbineTemplate.getDefaultScreen());
                    return;
                }
                JetspeedUser user = JetspeedSecurity.getUser(username);
                if (user == null) {
                    logger.warn("JLogin User: Unexpected condition : user is NULL");
                    return;
                }
                String confirm_value = user.getConfirmed();
                if (!secretkey.equals(confirm_value) && !confirm_value.equals("CONFIRMED")) {
                    if (newUserApproval) {
                        data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                        return;
                    }
                    if (user.getConfirmed().equals("REJECTED")) {
                        data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                        return;
                    }
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    return;
                }
                user.setConfirmed("CONFIRMED");
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_WELCOME"));
                JetspeedSecurity.saveUser(user);
            }
            JetspeedUser user = null;
            try {
                String key;
                if (ALCellularUtils.isCellularPhone((RunData)data) && (key = data.getParameters().getString("key", "").trim()) != null && key.length() > 0) {
                    StringTokenizer st = new StringTokenizer(key, "_");
                    if (st.countTokens() == 2) {
                        username = st.nextToken();
                        String base64value = st.nextToken();
                        ALStringField tmpname = new ALStringField();
                        tmpname.setTrim(true);
                        tmpname.setNotNull(true);
                        tmpname.setCharacterType(3);
                        tmpname.limitMaxLength(16);
                        tmpname.setValue(username);
                        boolean valid = tmpname.validate(new ArrayList());
                        if (valid) {
                            ALEipUser eipuser = ALEipUtils.getALEipUser(username);
                            if (eipuser != null) {
                                if (!ALCellularUtils.getCheckValueForCellLogin(username, eipuser.getUserId().toString()).equals(base64value)) {
                                    username = "";
                                }
                            } else {
                                username = "";
                            }
                        } else {
                            username = "";
                        }
                    }
                    String celluid = ALCellularUtils.getCellularUid(rundata);
                    password = "cellularuid_" + celluid;
                }
                user = JetspeedSecurity.login(username, password);
                JetspeedSecurity.saveUser(user);
                int loginUserId = Integer.parseInt(user.getUserId());
                ALEventlogFactoryService.getInstance().getEventlogHandler().logLogin(loginUserId);
            }
            catch (LoginException e) {
                message = e.getMessage() != null ? e.getMessage() : e.toString();
                data.setMessage(message);
                data.setUser(JetspeedSecurity.getAnonymousUser());
                data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                if (e instanceof FailedLoginException) {
                    if (!this.disableCheck(data)) {
                        logger.info("JLoginUser: Credential Failure on login for user: " + username);
                        data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_FAILED_MSG"));
                    }
                } else if (e instanceof AccountExpiredException) {
                    logger.info("JLoginUser: Account Expired for user " + username);
                } else if (e instanceof CredentialExpiredException) {
                    logger.info("JLoginUser: Credentials expired for user: " + username);
                    data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_EXPIRED_MSG"));
                    data.getParameters().setString("username", username);
                }
                return;
            }
            catch (Throwable other) {
                message = other.getMessage() != null ? other.getMessage() : other.toString();
                data.setMessage(message);
                data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
                FakeJetspeedUser juser = new FakeJetspeedUser(JetspeedSecurity.getAnonymousUserName(), false);
                data.setUser(juser);
                return;
            }
            if (user.getDisabled()) {
                data.setUser(JetspeedSecurity.getAnonymousUser());
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
                data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                return;
            }
            if (data.getUser().hasLoggedIn()) {
                String redirectUrl;
                boolean userRequestsRememberMe;
                String confirmed;
                if (JetspeedSecurity.isDisableAccountCheckEnabled()) {
                    JetspeedSecurity.resetDisableAccountCheck(data.getParameters().getString("username", ""));
                }
                if ((confirmed = data.getUser().getConfirmed()) == null || !confirmed.equals("CONFIRMED")) {
                    if (confirmed != null && confirmed.equals("REJECTED")) {
                        data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                        data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                        return;
                    }
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_CONFIRMFIRST"));
                    data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                    return;
                }
                boolean automaticLogonEnabled = JetspeedResources.getBoolean("automatic.logon.enable", false);
                if (automaticLogonEnabled && (userRequestsRememberMe = data.getParameters().getBoolean("rememberme", false))) {
                    int maxage = JetspeedResources.getInt("automatic.logon.cookie.maxage", -1);
                    String comment = JetspeedResources.getString("automatic.logon.cookie.comment", "");
                    String domain = JetspeedResources.getString("automatic.logon.cookie.domain");
                    String path = JetspeedResources.getString("automatic.logon.cookie.path", "/");
                    if (domain == null) {
                        String server = data.getServerName();
                        domain = "." + server;
                    }
                    String loginCookieValue = null;
                    if (JetspeedResources.getString("automatic.logon.cookie.generation", "everylogon").equals("everylogon")) {
                        loginCookieValue = "" + Math.random();
                        data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                        JetspeedSecurity.saveUser(data.getJetspeedUser());
                    } else {
                        loginCookieValue = (String)data.getUser().getPerm("logincookie");
                        if (loginCookieValue == null || loginCookieValue.length() == 0) {
                            loginCookieValue = "" + Math.random();
                            data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                            JetspeedSecurity.saveUser(data.getJetspeedUser());
                        }
                    }
                    Cookie userName = new Cookie("username", data.getUser().getUserName());
                    Cookie loginCookie = new Cookie("logincookie", loginCookieValue);
                    userName.setMaxAge(maxage);
                    userName.setComment(comment);
                    userName.setDomain(domain);
                    userName.setPath(path);
                    loginCookie.setMaxAge(maxage);
                    loginCookie.setComment(comment);
                    loginCookie.setDomain(domain);
                    loginCookie.setPath(path);
                    data.getResponse().addCookie(userName);
                    data.getResponse().addCookie(loginCookie);
                }
                if ((redirectUrl = data.getParameters().getString("redirect", "")) != null && !"".equals(redirectUrl)) {
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)data);
                    data.setRedirectURI(redirectUrl);
                    data.getResponse().sendRedirect(redirectUrl);
                    JetspeedLinkFactory.putInstance(jsLink);
                    jsLink = null;
                }
            } else {
                this.disableCheck(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean disableCheck(JetspeedRunData data) {
        boolean disabled = false;
        if (JetspeedSecurity.isDisableAccountCheckEnabled() && (disabled = JetspeedSecurity.checkDisableAccount(data.getParameters().getString("username", "")))) {
            data.setMessage(Localization.getString((RunData)data, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
            data.setScreenTemplate(JetspeedResources.getString("logon.disabled.form"));
            data.getUser().setHasLoggedIn(Boolean.valueOf(false));
        }
        return disabled;
    }
}

