/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.common.ALEipCompany;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

public class ALEipManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALEipManager.class.getName());
    private static ALEipManager manager = new ALEipManager();
    private JetspeedRunDataService runDataService = null;
    private Map companysMap = new LinkedHashMap();
    private Map postsMap = new LinkedHashMap();
    private Map positionsMap = new LinkedHashMap();

    private ALEipManager() {
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.initCompany();
        this.initPost();
        this.initPosition();
    }

    public static ALEipManager getInstance() {
        return manager;
    }

    private void initCompany() {
        this.companysMap.clear();
        String org_id = null;
        List org_list = DatabaseOrmService.getInstance().getOrgKeys();
        Iterator iter = org_list.iterator();
        while (iter.hasNext()) {
            try {
                LinkedHashMap<Integer, ALEipCompany> companyMap = new LinkedHashMap<Integer, ALEipCompany>();
                org_id = (String)iter.next();
                DataContext dataContext = DataContext.createDataContext((String)org_id);
                SelectQuery query = new SelectQuery(EipMCompany.class);
                List list = dataContext.performQuery((Query)query);
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipMCompany record = (EipMCompany)list.get(i);
                    ALEipCompany company = new ALEipCompany();
                    company.initField();
                    company.setCompanyId(record.getCompanyId());
                    company.setCompanyName(record.getCompanyName());
                    companyMap.put(record.getCompanyId(), company);
                }
                this.companysMap.put(org_id, companyMap);
            }
            catch (Exception e) {
                logger.error("[" + org_id + ":ALEipManager]", e);
            }
        }
    }

    private void initPost() {
        this.postsMap.clear();
        String org_id = null;
        List org_list = DatabaseOrmService.getInstance().getOrgKeys();
        Iterator iter = org_list.iterator();
        while (iter.hasNext()) {
            try {
                LinkedHashMap<Integer, ALEipPost> postMap = new LinkedHashMap<Integer, ALEipPost>();
                org_id = (String)iter.next();
                DataContext dataContext = DataContext.createDataContext((String)org_id);
                SelectQuery query = new SelectQuery(EipMPost.class);
                List list = dataContext.performQuery((Query)query);
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipMPost record = (EipMPost)list.get(i);
                    ALEipPost post = new ALEipPost();
                    post.initField();
                    post.setPostId(record.getPostId());
                    post.setPostName(record.getPostName());
                    post.setGroupName(record.getGroupName());
                    postMap.put(record.getPostId(), post);
                }
                this.postsMap.put(org_id, postMap);
            }
            catch (Exception e) {
                logger.error("[" + org_id + ":ALEipManager]", e);
            }
        }
    }

    private void initPosition() {
        this.positionsMap.clear();
        String org_id = null;
        List org_list = DatabaseOrmService.getInstance().getOrgKeys();
        Iterator iter = org_list.iterator();
        while (iter.hasNext()) {
            try {
                LinkedHashMap<Integer, ALEipPosition> positionMap = new LinkedHashMap<Integer, ALEipPosition>();
                org_id = (String)iter.next();
                DataContext dataContext = DataContext.createDataContext((String)org_id);
                SelectQuery query = new SelectQuery(EipMPosition.class);
                List list = dataContext.performQuery((Query)query);
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipMPosition record = (EipMPosition)list.get(i);
                    ALEipPosition position = new ALEipPosition();
                    position.initField();
                    position.setPositionId(record.getPositionId());
                    position.setPositionName(record.getPositionName());
                    positionMap.put(record.getPositionId(), position);
                }
                this.positionsMap.put(org_id, positionMap);
            }
            catch (Exception e) {
                logger.error("[" + org_id + ":ALEipManager]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCompany() {
        String org_id = "";
        Map map = this.companysMap;
        synchronized (map) {
            try {
                org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                SelectQuery query = new SelectQuery(EipMCompany.class);
                List list = dataContext.performQuery((Query)query);
                int size = list.size();
                LinkedHashMap<Integer, ALEipCompany> companyMap = (LinkedHashMap<Integer, ALEipCompany>)this.companysMap.remove(org_id);
                if (companyMap == null) {
                    companyMap = new LinkedHashMap<Integer, ALEipCompany>();
                } else {
                    companyMap.clear();
                }
                for (int i = 0; i < size; ++i) {
                    EipMCompany record = (EipMCompany)list.get(i);
                    ALEipCompany company = new ALEipCompany();
                    company.initField();
                    company.setCompanyId(record.getCompanyId());
                    company.setCompanyName(record.getCompanyName());
                    companyMap.put(record.getCompanyId(), company);
                }
                this.companysMap.put(org_id, companyMap);
            }
            catch (Exception e) {
                logger.error("[" + org_id + ":ALEipManager]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPost() {
        String org_id = "";
        Map map = this.postsMap;
        synchronized (map) {
            try {
                org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                SelectQuery query = new SelectQuery(EipMPost.class);
                List list = dataContext.performQuery((Query)query);
                int size = list.size();
                LinkedHashMap<Integer, ALEipPost> postMap = (LinkedHashMap<Integer, ALEipPost>)this.postsMap.remove(org_id);
                if (postMap == null) {
                    postMap = new LinkedHashMap<Integer, ALEipPost>();
                } else {
                    postMap.clear();
                }
                for (int i = 0; i < size; ++i) {
                    EipMPost record = (EipMPost)list.get(i);
                    ALEipPost post = new ALEipPost();
                    post.initField();
                    post.setPostId(record.getPostId());
                    post.setPostName(record.getPostName());
                    post.setGroupName(record.getGroupName());
                    postMap.put(record.getPostId(), post);
                }
                this.postsMap.put(org_id, postMap);
            }
            catch (Exception e) {
                logger.error("[" + org_id + ":ALEipManager]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPosition() {
        String org_id = "";
        Map map = this.positionsMap;
        synchronized (map) {
            try {
                org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                SelectQuery query = new SelectQuery(EipMPosition.class);
                List list = dataContext.performQuery((Query)query);
                int size = list.size();
                LinkedHashMap<Integer, ALEipPosition> positionMap = (LinkedHashMap<Integer, ALEipPosition>)this.positionsMap.remove(org_id);
                if (positionMap == null) {
                    positionMap = new LinkedHashMap<Integer, ALEipPosition>();
                } else {
                    positionMap.clear();
                }
                for (int i = 0; i < size; ++i) {
                    EipMPosition record = (EipMPosition)list.get(i);
                    ALEipPosition position = new ALEipPosition();
                    position.initField();
                    position.setPositionId(record.getPositionId());
                    position.setPositionName(record.getPositionName());
                    positionMap.put(record.getPositionId(), position);
                }
                this.positionsMap.put(org_id, positionMap);
            }
            catch (Exception e) {
                logger.error("[" + org_id + ":ALEipManager]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCompanyMap() {
        Map map = this.companysMap;
        synchronized (map) {
            String org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
            if (!this.companysMap.containsKey(org_id)) {
                this.reloadCompany();
                if (!this.companysMap.containsKey(org_id)) {
                    return null;
                }
                return (Map)this.companysMap.get(org_id);
            }
            return (Map)this.companysMap.get(org_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPostMap() {
        Map map = this.postsMap;
        synchronized (map) {
            String org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
            if (!this.postsMap.containsKey(org_id)) {
                this.reloadPost();
                if (!this.postsMap.containsKey(org_id)) {
                    return null;
                }
                return (Map)this.postsMap.get(org_id);
            }
            return (Map)this.postsMap.get(org_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPositionMap() {
        Map map = this.positionsMap;
        synchronized (map) {
            String org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
            if (!this.positionsMap.containsKey(org_id)) {
                this.reloadPosition();
                if (!this.positionsMap.containsKey(org_id)) {
                    return null;
                }
                return (Map)this.positionsMap.get(org_id);
            }
            return (Map)this.positionsMap.get(org_id);
        }
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }
}

