/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.commons.field.ALIllegalDateException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALHoliday;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class ALEipHolidaysManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALEipHolidaysManager.class.getName());
    protected static final String KEY_ENCODING = "content.defaultencoding";
    private static ALEipHolidaysManager manager = new ALEipHolidaysManager();
    private String FILE_HOLI_DAYS_DEFAULT = JetspeedResources.getString("aipo.home", "").equals("") ? "" : JetspeedResources.getString("aipo.home", "") + File.separator + "conf" + File.separator + "holidays_default.properties";
    private String FILE_HOLI_DAYS_USER = JetspeedResources.getString("aipo.home", "").equals("") ? "" : JetspeedResources.getString("aipo.home", "") + File.separator + "conf" + File.separator + "holidays_user.properties";
    private List defaultHolidays = new ArrayList();
    private List userHolidays = new ArrayList();

    private ALEipHolidaysManager() {
        this.loadHolidays();
    }

    public static ALEipHolidaysManager getInstance() {
        return manager;
    }

    public ALHoliday isHoliday(Date date) {
        if (date == null) {
            return null;
        }
        ALHoliday holiDay = null;
        int year = -1;
        int month = -1;
        int day = -1;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        try {
            year = calendar.get(1);
            month = calendar.get(2) + 1;
            day = calendar.get(5);
        }
        catch (Throwable ex) {
            return null;
        }
        holiDay = this.isHoliday(this.userHolidays, year, month, day);
        if (holiDay == null) {
            holiDay = this.isHoliday(this.defaultHolidays, year, month, day);
        }
        return holiDay;
    }

    private ALHoliday isHoliday(List list, int year, int month, int day) {
        ALHoliday holiDay = null;
        GregorianCalendar hCalendar = null;
        int hYear = -1;
        int hMonth = -1;
        int hDay = -1;
        int length = list.size();
        try {
            for (int i = 0; i < length; ++i) {
                holiDay = (ALHoliday)list.get(i);
                hCalendar = new GregorianCalendar();
                hCalendar.setTime(holiDay.getDay().getValue().getDate());
                hCalendar.set(13, 0);
                hCalendar.set(14, 0);
                hYear = hCalendar.get(1);
                hMonth = hCalendar.get(2) + 1;
                hDay = hCalendar.get(5);
                if (hYear != year || hMonth != month || hDay != day) continue;
                return holiDay;
            }
        }
        catch (ALIllegalDateException ex) {
            logger.error("Exception", ex);
        }
        return null;
    }

    private void loadHolidays() {
        File defaultFile = new File(this.FILE_HOLI_DAYS_DEFAULT);
        File userFile = new File(this.FILE_HOLI_DAYS_USER);
        this.defaultHolidays.clear();
        this.userHolidays.clear();
        BufferedReader reader = null;
        try {
            Comparator comp;
            if (defaultFile.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(defaultFile), ALEipConstants.DEF_CONTENT_ENCODING));
                this.loadHoliday(reader, this.defaultHolidays);
            }
            if (userFile.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(userFile), ALEipConstants.DEF_CONTENT_ENCODING));
                this.loadHoliday(reader, this.userHolidays);
            }
            if ((comp = this.getHolidaysComparator()) != null) {
                Collections.sort(this.defaultHolidays, comp);
                Collections.sort(this.userHolidays, comp);
            }
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
            return;
        }
    }

    private void loadHoliday(BufferedReader reader, List list) throws Exception {
        if (reader == null) {
            return;
        }
        ArrayList dummyList = new ArrayList();
        StringTokenizer st = null;
        ALHoliday holiDay = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            String dayStr;
            String nameStr;
            if (line.startsWith("#") || (st = new StringTokenizer(line, ",")).countTokens() != 2 || !(holiDay = new ALHoliday(nameStr = st.nextToken(), dayStr = st.nextToken())).getDay().validate(dummyList)) continue;
            list.add(holiDay);
        }
    }

    private Comparator getHolidaysComparator() {
        Comparator com = new Comparator(){

            public int compare(Object obj0, Object obj1) {
                int ret = 0;
                try {
                    Date day0 = ((ALHoliday)obj0).getDay().getValue().getDate();
                    Date day1 = ((ALHoliday)obj1).getDay().getValue().getDate();
                    ret = day0.compareTo(day1);
                    if (ret == 0) {
                        String name0 = ((ALHoliday)obj0).getName().getValue();
                        String name1 = ((ALHoliday)obj1).getName().getValue();
                        ret = name0.compareTo(name1);
                    }
                }
                catch (Exception ex) {
                    return -1;
                }
                return ret;
            }
        };
        return com;
    }
}

