/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class ALCsvTokenizer {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALCsvTokenizer.class.getName());
    public static final String CSV_TEMP_FOLDER = JetspeedResources.getString("aipo.tmp.directory", "") + System.getProperty("file.separator") + "csv";
    public static final int CSV_SHOW_SIZE = 1000;
    public static final int CSV_SHOW_ERROR_SIZE = 100;
    public static final int CSV_LIST_MODE_READ = 0;
    public static final int CSV_LIST_MODE_NO_ERROR = 1;
    public static final int CSV_LIST_MODE_ERROR = 2;
    private boolean inquote = false;
    public int eof = 0;
    public boolean line = false;
    private InputStreamReader in;

    public boolean init(String fname) {
        this.line = false;
        this.inquote = false;
        this.eof = 0;
        try {
            File file = new File(fname);
            if (!file.exists()) {
                file = null;
                return false;
            }
            file = null;
            FileInputStream is = new FileInputStream(fname);
            this.in = new InputStreamReader((InputStream)is, "Shift_JIS");
            return true;
        }
        catch (IOException ie) {
            this.eof = -1;
            logger.error("[ERROR]", ie);
            return false;
        }
    }

    public String nextToken() {
        String str = "";
        this.line = false;
        this.inquote = false;
        if (this.eof == -1) {
            return "";
        }
        try {
            int ch;
            str = "";
            this.eof = ch = this.in.read();
            if (ch == 34) {
                this.inquote = true;
            }
            if (ch == 44 && !this.inquote) {
                return str;
            }
            if (ch == 10 && !this.inquote) {
                this.line = true;
                this.eof = ch = this.in.read();
                return str;
            }
            while (this.eof != -1) {
                if (ch == 10) {
                    str = str + "\r\n";
                } else if (ch != 34) {
                    str = str + (char)ch;
                }
                this.eof = ch = this.in.read();
                if (ch == 13) {
                    this.eof = ch = this.in.read();
                }
                if (ch == 34) {
                    this.eof = ch = this.in.read();
                    if (ch != 34) {
                        this.inquote = !this.inquote;
                    } else if (this.inquote) {
                        str = str + "\"";
                    }
                }
                if (this.eof == -1) {
                    return str;
                }
                if (ch != 44 && ch != 10 || this.inquote) continue;
                if (ch == 10) {
                    this.line = true;
                }
                return str;
            }
            return str;
        }
        catch (IOException ie) {
            this.eof = -1;
            return "";
        }
    }

    public boolean setStartLine(String fname, int i) {
        if (!this.init(fname)) {
            return false;
        }
        for (int line_count = 0; this.eof != -1 && line_count < i; ++line_count) {
            while (this.eof != -1) {
                this.nextToken();
                if (this.eof != -1 && !this.line) continue;
            }
            if (this.eof == -1) break;
        }
        return true;
    }
}

