/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public abstract class ALCsvAbstractSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALCsvAbstractSelectData.class.getName());
    protected int page_count;
    protected int line_count;
    protected int error_count;
    protected int not_error_count;
    protected int stats;
    protected ArrayList sequency;
    protected String folderIndex;
    protected DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected void outputErrorData(RunData rundata, String str, String filepath) throws Exception {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), "Shift_JIS"));
            writer.write(str, 0, str.length());
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            logger.error("[ERROR]" + e);
        }
    }

    protected String makeOutputItem(String str) {
        String res = "";
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                res = res + ch;
            }
            res = res + ch;
        }
        return res;
    }

    protected Object getResultData(Object obj) {
        return obj;
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public void setPageCount(int i) {
        this.page_count = i;
    }

    public int getPageCount() {
        return this.page_count;
    }

    public void setLineCount(int i) {
        this.line_count = i;
    }

    public int getLineCount() {
        return this.line_count;
    }

    public void setNotErrorCount(int i) {
        this.not_error_count = i;
    }

    public int getNotErrorCount() {
        return this.not_error_count;
    }

    public void setErrorCount(int i) {
        this.error_count = i;
    }

    public int getErrorCount() {
        return this.error_count;
    }

    public void setState(int i) {
        if (i > -1 && i < 3) {
            this.stats = i;
        }
    }

    public int getState() {
        return this.stats;
    }

    public boolean isError() {
        return this.error_count > 0 && this.stats == 2;
    }

    public void setSequency(ArrayList s) {
        this.sequency = s;
    }

    public ArrayList getSequency() {
        return this.sequency;
    }

    public void setTempFolderIndex(String folderIndex) {
        this.folderIndex = folderIndex;
    }

    public String getTempFolderIndex() {
        return this.folderIndex;
    }
}

