/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public abstract class ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ALAbstractSelectData.class.getName());
    private int rows_num = 10;
    private int strlen = 0;
    private int start;
    private int count;
    private int pages_num = 1;
    private int current_page = 1;
    private ArrayList list;
    private Object data;
    private String current_sort;
    private String current_sort_type;
    protected String current_filter;
    protected String current_filter_type;
    protected boolean hasAuthority;
    protected final String LIST_SORT_STR = new StringBuffer().append(this.getClass().getName()).append("sort").toString();
    protected final String LIST_SORT_TYPE_STR = new StringBuffer().append(this.getClass().getName()).append("sorttype").toString();
    protected final String LIST_FILTER_STR = new StringBuffer().append(this.getClass().getName()).append("filter").toString();
    protected final String LIST_FILTER_TYPE_STR = new StringBuffer().append(this.getClass().getName()).append("filtertype").toString();
    protected final String LIST_INDEX_STR = new StringBuffer().append(this.getClass().getName()).append("index").toString();

    public void initField() {
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (ALEipUtils.isMatch(rundata, context)) {
            if (rundata.getParameters().containsKey((Object)"entityid")) {
                ALEipUtils.setTemp(rundata, context, "entityid", rundata.getParameters().getString("entityid"));
            }
            if (rundata.getParameters().containsKey((Object)"sort")) {
                ALEipUtils.setTemp(rundata, context, this.LIST_SORT_STR, rundata.getParameters().getString("sort"));
            }
            if (rundata.getParameters().containsKey((Object)"sorttype")) {
                ALEipUtils.setTemp(rundata, context, this.LIST_SORT_TYPE_STR, rundata.getParameters().getString("sorttype"));
            }
            if (rundata.getParameters().containsKey((Object)"start")) {
                this.current_page = rundata.getParameters().getInt("start");
            }
            if (rundata.getParameters().containsKey((Object)"filter")) {
                ALEipUtils.setTemp(rundata, context, this.LIST_FILTER_STR, rundata.getParameters().getString("filter"));
            }
            if (rundata.getParameters().containsKey((Object)"filtertype")) {
                ALEipUtils.setTemp(rundata, context, this.LIST_FILTER_TYPE_STR, rundata.getParameters().getString("filtertype"));
            }
        }
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            action.setMode("list");
            List aList = this.selectList(rundata, context);
            if (aList != null) {
                this.list = new ArrayList();
                Object obj = null;
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    obj = this.getResultData(aList.get(i));
                    if (obj == null) continue;
                    this.list.add(obj);
                }
            }
            action.setResultData(this);
            action.putData(rundata, context);
            ALEipUtils.removeTemp(rundata, context, "entityid");
            return this.list != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    public boolean doSelectList(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            List aList = this.selectList(rundata, context);
            if (aList != null) {
                this.list = new ArrayList();
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    this.list.add(this.getResultData(aList.get(i)));
                }
            }
            return this.list != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    public boolean doViewDetail(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 2);
            action.setMode("detail");
            Object obj = this.selectDetail(rundata, context);
            if (obj != null) {
                this.data = this.getResultDataDetail(obj);
            }
            action.setResultData(this);
            action.putData(rundata, context);
            return this.data != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    protected void buildSelectQueryForListView(SelectQuery query) {
        query.setPageSize(this.getRowsNum());
    }

    protected List buildPaginatedList(List records) {
        ArrayList list = new ArrayList();
        this.setPageParam(records.size());
        int size = records.size();
        int end = this.start + this.rows_num <= size ? this.start + this.rows_num : size;
        for (int i = this.start; i < end; ++i) {
            list.add(records.get(i));
        }
        return list;
    }

    protected void setPageParam(int cnt) {
        this.count = cnt;
        this.pages_num = (int)Math.ceil((double)this.count / (double)this.rows_num);
        if (this.pages_num > 0 && this.pages_num < this.current_page) {
            this.current_page = this.pages_num;
        }
        this.start = this.rows_num * (this.current_page - 1);
    }

    protected SelectQuery buildSelectQueryForListViewSort(SelectQuery query, RunData rundata, Context context) {
        String sort = ALEipUtils.getTemp(rundata, context, this.LIST_SORT_STR);
        String sort_type = ALEipUtils.getTemp(rundata, context, this.LIST_SORT_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (sort == null) {
            return query;
        }
        crt_key = map.getValue(sort);
        if (crt_key == null) {
            return query;
        }
        if (sort_type != null && "desc".equals(sort_type)) {
            query.addOrdering(crt_key, false);
        } else {
            query.addOrdering(crt_key, true);
            sort_type = "asc";
        }
        this.current_sort = sort;
        this.current_sort_type = sort_type;
        return query;
    }

    protected SelectQuery buildSelectQueryForFilter(SelectQuery query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp(rundata, context, this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp(rundata, context, this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        Expression exp = ExpressionFactory.matchDbExp((String)crt_key, (Object)filter);
        query.andQualifier(exp);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    public void setRowsNum(int num) {
        if (num >= 1) {
            this.rows_num = num;
        }
    }

    public void setStrLength(int num) {
        if (num >= 0) {
            this.strlen = num;
        }
    }

    public int getStrLength() {
        return this.strlen;
    }

    public int getRowsNum() {
        return this.rows_num;
    }

    public int getCount() {
        return this.count;
    }

    public int getPagesNum() {
        return this.pages_num;
    }

    public int getCurrentPage() {
        return this.current_page;
    }

    public ArrayList getList() {
        return this.list;
    }

    public Object getDetail() {
        return this.data;
    }

    public String getCurrentSort() {
        return this.current_sort;
    }

    public String getCurrentSortType() {
        return this.current_sort_type;
    }

    public String getCurrentFilter() {
        return this.current_filter;
    }

    public String getCurrentFilterType() {
        return this.current_filter_type;
    }

    protected abstract List selectList(RunData var1, Context var2) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract Object selectDetail(RunData var1, Context var2) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract Object getResultData(Object var1) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract Object getResultDataDetail(Object var1) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract Attributes getColumnMap();

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId(rundata), pfeature, defineAclType);
        if (!this.hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    public boolean hasAuthority() {
        return this.hasAuthority;
    }

    public String getAclPortletFeature() {
        return null;
    }

    public int getStart() {
        return this.start;
    }

    public String getStringCR(ALStringField field) {
        return ALCommonUtils.replaceToAutoCR(field.toString());
    }
}

