/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.webmacro;

import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.Log;
import org.webmacro.Broker;
import org.webmacro.NotFoundException;
import org.webmacro.Template;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceInitException;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.engine.FileTemplate;

public class TurbineTemplateProvider
implements ResourceProvider {
    public static String TYPE = "template";
    private static String[] types = new String[]{TYPE};
    private int cacheTime;
    private String[] paths;
    private Broker broker;

    public String[] getTypes() {
        return types;
    }

    public int resourceExpireTime() {
        return this.cacheTime;
    }

    public int resourceThreads() {
        return 1;
    }

    public void init(ResourceBroker broker) throws ResourceInitException {
        Log.info("TurbineTemplateProvider initializing");
        this.broker = broker;
        try {
            try {
                String tmp = (String)broker.getValue("config", "TemplateExpireTime");
                this.cacheTime = Integer.valueOf(tmp);
            }
            catch (Exception e) {
                this.cacheTime = 600000;
            }
            Configuration config = TurbineServices.getInstance().getConfiguration("WebMacroService");
            this.paths = config.getStringArray("templates");
            this.paths = TurbineTemplate.translateTemplatePaths(this.paths);
            StringBuffer pathMsg = new StringBuffer("TurbineTemplateProvider path(s):");
            int i = 0;
            while (i < this.paths.length) {
                pathMsg.append('\n').append(this.paths[i]);
                ++i;
            }
            Log.info(pathMsg.toString());
        }
        catch (Exception e) {
            String msg = "TurbineTemplateProvider failed to initialize";
            Log.error(msg, e);
            throw new ResourceInitException(msg);
        }
        Log.info("TurbineTemplateProvider initialized");
    }

    public void destroy() {
        this.broker = null;
        this.paths = null;
    }

    public void resourceRequest(RequestResourceEvent request) throws NotFoundException, InterruptedException {
        Template t = this.findTemplate(request.getName());
        if (t == null) {
            return;
        }
        try {
            request.set((Object)t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resourceCreate(CreateResourceEvent create) throws NotFoundException, InterruptedException {
    }

    public boolean resourceDelete(ResourceEvent delete) {
        return false;
    }

    public boolean resourceSave(ResourceEvent save) {
        return false;
    }

    private Template findTemplate(String name) {
        int i = 0;
        while (i < this.paths.length) {
            File file = new File(this.paths[i], name);
            if (file.canRead()) {
                try {
                    FileTemplate template = new FileTemplate(this.broker, file, "UTF-8");
                    template.parse();
                    return template;
                }
                catch (Exception e) {
                    Log.error("TurbineTemplateProvider failed to load template " + file.getPath(), e);
                }
            }
            ++i;
        }
        return null;
    }
}

