/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Navigation;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class NavigationLoader
extends GenericLoader {
    private static NavigationLoader instance = new NavigationLoader(TurbineResources.getInt("navigation.cache.size", 10));

    private NavigationLoader() {
    }

    private NavigationLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Navigation navigation) {
        if (this.cache()) {
            this.put(name, navigation);
        }
    }

    public ConcreteElement eval(RunData data, String name) throws Exception {
        return this.getInstance(name).build(data);
    }

    public void exec(RunData data, String name) throws Exception {
        this.eval(data, name);
    }

    public Navigation getInstance(String name) throws Exception {
        Navigation navigation = null;
        if (this.cache() && this.containsKey(name)) {
            navigation = (Navigation)this.get(name);
        } else {
            AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
            try {
                navigation = (Navigation)ab.getAssembler("navigation", name);
            }
            catch (ClassCastException cce) {
                navigation = null;
            }
            if (navigation == null) {
                Vector packages = TurbineResources.getVector("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Navigation not found: " + name + "\n" + "\tTurbine looked in the following modules.packages " + "path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, navigation);
            }
        }
        return navigation;
    }

    public static NavigationLoader getInstance() {
        return instance;
    }
}

