/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system.util;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.portlet.EipMMybox;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemUtils.class.getName());
    private static final int WEBAPPSERVER_PORT = JetspeedResources.getInt((String)"aipo.webappserver.port", (int)80);

    public static EipMMybox getEipMMybox(String company_id) {
        EipMMybox result = null;
        try {
            if (company_id == null || Integer.valueOf(company_id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMMybox.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipMCompany.COMPANY_ID", (Object)Integer.valueOf(company_id));
            query.setQualifier(exp);
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMMybox)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static EipMCompany getEipMCompany(RunData rundata, Context context) {
        EipMCompany result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMCompany.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id));
            query.setQualifier(exp);
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static int getServerPort() {
        return WEBAPPSERVER_PORT;
    }

    public static String getUrl(String ip, int port, String servername) {
        if (ip == null || ip.length() == 0 || port == -1) {
            return "";
        }
        String protocol = JetspeedResources.getString((String)"access.url.protocol", (String)"http");
        StringBuffer url = new StringBuffer();
        if (port == 80) {
            url.append(protocol).append("://").append(ip).append("/").append(servername).append("/");
        } else {
            url.append(protocol).append("://").append(ip).append(":").append(port).append("/").append(servername).append("/");
        }
        return url.toString();
    }
}

