/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.system.util.SystemUtils;
import java.util.ArrayList;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemNetworkFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemNetworkFormData.class.getName());
    private ALStringField ipaddress;
    private ALNumberField port;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.ipaddress = new ALStringField();
        this.ipaddress.setFieldName("IP\u30a2\u30c9\u30ec\u30b9");
        this.ipaddress.setTrim(true);
        this.port = new ALNumberField();
        this.port.setFieldName("\u30dd\u30fc\u30c8\u756a\u53f7");
        this.port.setValue(80L);
    }

    protected void setValidator() {
        this.ipaddress.setNotNull(true);
        this.port.setNotNull(true);
        this.port.limitValue(1L, 65535L);
    }

    protected boolean validate(ArrayList msgList) {
        this.ipaddress.validate(msgList);
        this.port.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMCompany record = SystemUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            this.ipaddress.setValue(record.getIpaddress());
            this.port.setValue(record.getPort().longValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipMCompany record = SystemUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            record.setIpaddress(this.ipaddress.getValue());
            record.setPort(Integer.valueOf((int)this.port.getValue()));
            this.dataContext.commitChanges();
            ALEipManager.getInstance().reloadCompany();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public ALStringField getIpaddress() {
        return this.ipaddress;
    }

    public ALNumberField getPort() {
        return this.port;
    }
}

