/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.manhour;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.manhour.ManHourResultData;
import com.aimluck.eip.manhour.util.ManHourUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ManHourSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ManHourSelectData.class.getName());
    private String target_group_name;
    private String target_user_id;
    private List myGroupList = null;
    private String scheduleUrl;
    private String userid;
    private String category_id;
    private List categoryList = null;
    private ALDateTimeField view_date;
    private ArrayList scheduleList;
    private double totalManHourMinPast;
    private double totalManHourMinPlan;
    private boolean is_normal;
    private String aclPortletFeature = null;
    private boolean hasAclSummaryOther;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-sort"));
        }
        Calendar cal = Calendar.getInstance();
        this.view_date = new ALDateTimeField("yyyy-MM-dd");
        int view_date_year = ManHourUtils.getViewDateYear(rundata, context);
        int view_date_month = ManHourUtils.getViewDateMonth(rundata, context);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(1, view_date_year);
        cal.set(2, view_date_month - 1);
        cal.set(5, 1);
        this.view_date.setValue(cal.getTime());
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        if (this.target_user_id == null || this.target_user_id.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
        }
        this.target_group_name = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"target_group_name");
        this.target_user_id = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"target_user_id");
        this.category_id = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"category_id");
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add(myGroups.get(i));
        }
        this.scheduleList = new ArrayList();
        this.categoryList = CommonCategoryUtils.getCommonCategoryLiteBeans((RunData)rundata);
        this.aclPortletFeature = this.target_user_id.equals(this.userid) ? "manhour_summary_self" : "manhour_summary_other";
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclSummaryOther = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "manhour_summary_other", 1);
        if (!this.hasAclSummaryOther) {
            this.target_user_id = this.userid;
            this.aclPortletFeature = "manhour_summary_self";
        }
        super.init(action, rundata, context);
    }

    public boolean isNormal() {
        return this.is_normal;
    }

    public void setNormal(boolean bool) {
        this.is_normal = bool;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            action.setMode("list");
            List aList = this.selectList(rundata, context);
            if (aList != null) {
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    this.getResultData(aList.get(i));
                }
                this.cleanupDummySchedule(this.scheduleList);
                this.scheduleList = (ArrayList)this.buildPaginatedList(this.scheduleList);
                this.scheduleList = this.getScheduleList();
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
            return this.scheduleList != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public ArrayList getList() {
        return this.scheduleList;
    }

    private ArrayList getScheduleList() {
        Object[] obj = this.scheduleList.toArray();
        Arrays.sort(obj, new Comparator(){

            public int compare(Object o1, Object o2) {
                String sort = ManHourSelectData.this.getCurrentSort();
                String sort_type = ManHourSelectData.this.getCurrentSortType();
                int result = 0;
                if ("category".equals(sort)) {
                    result = "asc".equals(sort_type) ? ((ManHourResultData)o1).getCategoryName().getValue().compareTo(((ManHourResultData)o2).getCategoryName().getValue()) : ((ManHourResultData)o2).getCategoryName().getValue().compareTo(((ManHourResultData)o1).getCategoryName().getValue());
                } else if ("user_name".equals(sort)) {
                    result = "asc".equals(sort_type) ? ((ManHourResultData)o1).getUser().getValue().compareTo(((ManHourResultData)o2).getUser().getValue()) : ((ManHourResultData)o2).getUser().getValue().compareTo(((ManHourResultData)o1).getUser().getValue());
                } else if ("schedule".equals(sort)) {
                    result = "asc".equals(sort_type) ? ((ManHourResultData)o1).getName().getValue().compareTo(((ManHourResultData)o2).getName().getValue()) : ((ManHourResultData)o2).getName().getValue().compareTo(((ManHourResultData)o1).getName().getValue());
                } else if ("time".equals(sort)) {
                    result = "asc".equals(sort_type) ? ((ManHourResultData)o1).getStartDate().getValue().compareTo(((ManHourResultData)o2).getStartDate().getValue()) : ((ManHourResultData)o2).getStartDate().getValue().compareTo(((ManHourResultData)o1).getStartDate().getValue());
                } else if ("manhour".equals(sort)) {
                    result = "asc".equals(sort_type) ? Double.valueOf(((ManHourResultData)o1).getManHourMin()).compareTo(Double.valueOf(((ManHourResultData)o2).getManHourMin())) : Double.valueOf(((ManHourResultData)o2).getManHourMin()).compareTo(Double.valueOf(((ManHourResultData)o1).getManHourMin()));
                }
                return result;
            }
        });
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(obj));
        return list;
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return ScheduleUtils.sortByDummySchedule((List)list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        Expression exp1;
        Expression exp;
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.view_date.getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.view_date.getValue());
        cal.add(2, 1);
        ALDateTimeField view_date_add_month = new ALDateTimeField("yyyy-MM-dd");
        view_date_add_month.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)view_date_add_month.getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.setQualifier(exp11.andExp(exp12).andExp(exp14).orExp(exp13.andExp(exp14)));
        Expression exp15 = ExpressionFactory.matchExp((String)"status", (Object)"D");
        if (!(this.category_id == null || this.category_id.equals("") || this.is_normal || this.category_id.equals("all"))) {
            exp = ExpressionFactory.matchExp((String)"commonCategoryId", (Object)Integer.valueOf(this.category_id));
            query.andQualifier(exp15.orExp(exp));
        } else {
            exp = ExpressionFactory.noMatchExp((String)"commonCategoryId", (Object)1);
            query.andQualifier(exp15.orExp(exp));
        }
        if (this.is_normal) {
            exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(this.userid));
            query.andQualifier(exp1);
        } else if (this.target_user_id != null && !this.target_user_id.equals("") && !this.target_user_id.equals("all")) {
            exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(this.target_user_id));
            query.andQualifier(exp1);
        }
        if (!(this.target_group_name == null || this.target_group_name.equals("") || this.target_group_name.equals("all") || this.is_normal)) {
            Expression exp2 = ExpressionFactory.matchExp((String)"userId.turbineUserGroupRole.turbineGroup.groupName", (Object)this.target_group_name);
            query.andQualifier(exp2);
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            boolean is_member;
            EipTScheduleMap record = (EipTScheduleMap)obj;
            EipTSchedule schedule = record.getEipTSchedule();
            EipTCommonCategory category = record.getEipTCommonCategory();
            ALEipUser createdUser = ALEipUtils.getALEipUser((int)record.getUserId());
            String createdUserName = createdUser.getAliasName().toString();
            ManHourResultData rd = new ManHourResultData();
            rd.initField();
            rd.setCategoryId(category.getCommonCategoryId().longValue());
            rd.setCategoryName(category.getName());
            rd.setUser(createdUserName);
            rd.setUserId(record.getUserId().longValue());
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            int userid_int = Integer.parseInt(this.userid);
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(this.userid));
            mapquery.andQualifier(mapexp2);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List schedulemaps = dataContext.performQuery((Query)mapquery);
            boolean bl = is_member = schedulemaps != null && schedulemaps.size() > 0;
            if (!"D".equals(record.getStatus()) && "P".equals(schedule.getPublicFlag()) && userid_int != record.getUserId() && userid_int != schedule.getOwnerId() && !is_member) {
                return rd;
            }
            if ("C".equals(schedule.getPublicFlag()) && userid_int != record.getUserId() && userid_int != schedule.getOwnerId() && !is_member) {
                rd.setName("\u975e\u516c\u958b");
                rd.setTmpreserve(false);
            } else {
                rd.setName(schedule.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId() == userid_int);
            rd.setOwner(schedule.getOwnerId() == userid_int);
            rd.setMember(is_member);
            rd.setPattern(schedule.getRepeatPattern());
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.view_date.getValue());
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(this.view_date.getValue());
            cal2.add(2, 1);
            if (!rd.getPattern().equals("N")) {
                while (cal.before(cal2)) {
                    ALDateTimeField field = new ALDateTimeField("yyyy-MM-dd");
                    field.setValue(cal.getTime());
                    if (ScheduleUtils.isView((ALDateTimeField)field, (String)rd.getPattern(), (Date)rd.getStartDate().getValue(), (Date)rd.getEndDate().getValue())) {
                        Calendar temp = Calendar.getInstance();
                        temp.setTime(field.getValue());
                        temp.set(10, Integer.parseInt(rd.getStartDate().getHour()));
                        temp.set(12, Integer.parseInt(rd.getStartDate().getMinute()));
                        temp.set(13, 0);
                        temp.set(14, 0);
                        Calendar temp2 = Calendar.getInstance();
                        temp2.setTime(field.getValue());
                        temp2.set(10, Integer.parseInt(rd.getEndDate().getHour()));
                        temp2.set(12, Integer.parseInt(rd.getEndDate().getMinute()));
                        temp2.set(13, 0);
                        temp2.set(14, 0);
                        ManHourResultData rd3 = new ManHourResultData();
                        rd3.initField();
                        rd3.setCategoryId(rd.getCategoryId().getValue());
                        rd3.setCategoryName(rd.getCategoryName().getValue());
                        rd3.setUser(rd.getUser().toString());
                        rd3.setUserId(rd.getUserId().getValue());
                        rd3.setScheduleId((int)rd.getScheduleId().getValue());
                        rd3.setParentId((int)rd.getParentId().getValue());
                        rd3.setName(rd.getName().getValue());
                        rd3.setStartDate(temp.getTime());
                        rd3.setEndDate(temp2.getTime());
                        rd3.setTmpreserve(rd.isTmpreserve());
                        rd3.setPublic(rd.isPublic());
                        rd3.setHidden(rd.isHidden());
                        rd3.setDummy(rd.isDummy());
                        rd3.setLoginuser(rd.isLoginuser());
                        rd3.setOwner(rd.isOwner());
                        rd3.setMember(rd.isMember());
                        rd3.setRepeat(true);
                        this.addResultData(rd3);
                    }
                    cal.add(5, 1);
                }
            } else {
                this.addResultData(rd);
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private void addResultData(ManHourResultData rd) {
        int size = this.scheduleList.size();
        int position = 0;
        boolean canAdd = true;
        boolean repeat_del = false;
        boolean pos_bool = false;
        for (int i = 0; i < size; ++i) {
            repeat_del = false;
            ManHourResultData rd2 = (ManHourResultData)this.scheduleList.get(i);
            if (rd.isRepeat() && rd2.isDummy() && rd.getScheduleId().getValue() == rd2.getParentId().getValue() && ScheduleUtils.equalsToDate((Date)rd.getStartDate().getValue(), (Date)rd2.getStartDate().getValue(), (boolean)false)) {
                canAdd = false;
                break;
            }
            if (rd2.isRepeat() && rd.isDummy() && rd2.getScheduleId().getValue() == rd.getParentId().getValue() && ScheduleUtils.equalsToDate((Date)rd.getStartDate().getValue(), (Date)rd2.getStartDate().getValue(), (boolean)false)) {
                this.scheduleList.remove(rd2);
                canAdd = true;
                repeat_del = true;
            }
            if (!pos_bool && rd.getStartDate().getValue().before(rd2.getStartDate().getValue())) {
                position = i;
                pos_bool = true;
            }
            if (repeat_del || rd.isDummy() || rd2.isDummy() || !(rd.getStartDate().getValue().before(rd2.getStartDate().getValue()) && rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getStartDate().getValue()) && rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) || rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) && rd2.getEndDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) && rd.getEndDate().getValue().before(rd2.getEndDate().getValue())) && (!rd.getEndDate().getValue().equals(rd2.getEndDate().getValue()) || !rd.getStartDate().getValue().equals(rd2.getStartDate().getValue()))) continue;
            rd2.setDuplicate(true);
            rd.setDuplicate(true);
        }
        if (canAdd) {
            if (pos_bool) {
                this.scheduleList.add(position, rd);
                if (rd.isPast()) {
                    this.totalManHourMinPast += (double)rd.getManHourMin();
                } else {
                    this.totalManHourMinPlan += (double)rd.getManHourMin();
                }
            } else {
                this.scheduleList.add(rd);
                if (rd.isPast()) {
                    this.totalManHourMinPast += (double)rd.getManHourMin();
                } else {
                    this.totalManHourMinPlan += (double)rd.getManHourMin();
                }
            }
        }
    }

    private void cleanupDummySchedule(List list) {
        if (list == null || list.size() <= 0) {
            return;
        }
        ManHourResultData rd = null;
        ArrayList<ManHourResultData> dummyList = new ArrayList<ManHourResultData>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            rd = (ManHourResultData)list.get(i);
            if (!rd.isDummy()) continue;
            dummyList.add(rd);
        }
        list.removeAll(dummyList);
    }

    protected Object getResultDataDetail(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List getUsers() {
        if (this.hasAclSummaryOther) {
            if (this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
                return ALEipUtils.getUsers((String)this.target_group_name);
            }
            return ALEipUtils.getUsers((String)"LoginUser");
        }
        try {
            ArrayList<ALEipUser> users = new ArrayList<ALEipUser>();
            users.add(ALEipUtils.getALEipUser((int)Integer.parseInt(this.userid)));
            return users;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("user_name", "commonCategoryId");
        map.putValue("category", "commonCategoryId");
        map.putValue("schedule", "commonCategoryId");
        map.putValue("time", "commonCategoryId");
        map.putValue("manhour", "commonCategoryId");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getScheduleUrl() {
        return this.scheduleUrl;
    }

    public ALDateTimeField getViewDate() {
        return this.view_date;
    }

    public String getCategoryId() {
        return this.category_id;
    }

    public List getCategoryList() {
        return this.categoryList;
    }

    public double getTotalManHourPast() {
        return (double)((int)(this.totalManHourMinPast * 100.0 / 60.0)) / 100.0;
    }

    public double getTotalManHourPlan() {
        return (double)((int)(this.totalManHourMinPlan * 100.0 / 60.0)) / 100.0;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

