/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

class QRMath {
    private static final int[] EXP_TABLE;
    private static final int[] LOG_TABLE;

    private QRMath() {
    }

    public static int glog(int n) {
        if (n < 1) {
            throw new ArithmeticException("log(" + n + ")");
        }
        return LOG_TABLE[n];
    }

    public static int gexp(int n) {
        while (n < 0) {
            n += 255;
        }
        while (n >= 256) {
            n -= 255;
        }
        return EXP_TABLE[n];
    }

    static {
        int i;
        EXP_TABLE = new int[256];
        for (i = 0; i < 8; ++i) {
            QRMath.EXP_TABLE[i] = 1 << i;
        }
        for (i = 8; i < 256; ++i) {
            QRMath.EXP_TABLE[i] = EXP_TABLE[i - 4] ^ EXP_TABLE[i - 5] ^ EXP_TABLE[i - 6] ^ EXP_TABLE[i - 8];
        }
        LOG_TABLE = new int[256];
        for (i = 0; i < 255; ++i) {
            QRMath.LOG_TABLE[QRMath.EXP_TABLE[i]] = i;
        }
    }
}

