/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet.util;

import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetUtils.class.getName());
    public static final int ROOT_FODLER_ID = 1;
    public static final String KEY_FOLDER_ID = "folder_id";
    private static final String FOLDER_FILEDIR_CABINET = JetspeedResources.getString((String)"aipo.filedir", (String)"");

    public static EipTCabinetFolder getEipTCabinetFolder(RunData rundata, Context context) {
        String folderid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)KEY_FOLDER_ID);
        try {
            if (folderid == null || Integer.valueOf(folderid) == null) {
                logger.debug((Object)"[Cabinet Folder] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTCabinetFolder.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)folderid);
            query.setQualifier(exp);
            List folders = dataContext.performQuery((Query)query);
            if (folders == null || folders.size() == 0) {
                logger.debug((Object)"[Cabinet Folder] Not found ID...");
                return null;
            }
            return (EipTCabinetFolder)folders.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTCabinetFile getEipTCabinetFile(RunData rundata, Context context) {
        String fileid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (fileid == null || Integer.valueOf(fileid) == null) {
                logger.debug((Object)"[Cabinet File] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTCabinetFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)fileid);
            query.setQualifier(exp);
            List files = dataContext.performQuery((Query)query);
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[Cabinet File] Not found ID...");
                return null;
            }
            return (EipTCabinetFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getEipTCabinetFileList(int folderId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTCabinetFile.class);
            Expression exp = ExpressionFactory.matchExp((String)"folderId", (Object)folderId);
            query.setQualifier(exp);
            List files = dataContext.performQuery((Query)query);
            if (files == null || files.size() == 0) {
                return null;
            }
            return files;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static ArrayList getFolderList() {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTCabinetFolder.class);
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() < 0) {
                return null;
            }
            ArrayList prerootlist = CabinetUtils.getEipTCabinetFolderList(list, 0, 0);
            ArrayList result = CabinetUtils.getFolderList(prerootlist);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList getFolderList(List list) {
        try {
            if (list == null || list.size() <= 0) {
                return null;
            }
            ArrayList<FolderInfo> res = new ArrayList<FolderInfo>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = (FolderInfo)list.get(i);
                res.add(info);
                List infos = info.getList();
                ArrayList a = CabinetUtils.getFolderList(infos);
                if (a == null || a.size() <= 0) continue;
                res.addAll(a);
            }
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ArrayList getEipTCabinetFolderList(List dblist, int parent_id, int hierarchy_index) {
        FolderInfo info;
        ArrayList<FolderInfo> list = new ArrayList<FolderInfo>();
        int size = dblist.size();
        for (int i = 0; i < size; ++i) {
            EipTCabinetFolder folder = (EipTCabinetFolder)dblist.get(i);
            if (folder.getParentId() != parent_id) continue;
            info = new FolderInfo();
            info.setHierarchyIndex(hierarchy_index);
            info.setFolderId(folder.getFolderId());
            info.setParentFolderId(folder.getParentId());
            info.setFolderName(folder.getFolderName());
            list.add(info);
        }
        if (list.size() <= 0) {
            return null;
        }
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            info = (FolderInfo)list.get(i);
            ArrayList colist = CabinetUtils.getEipTCabinetFolderList(dblist, info.getFolderId(), info.getHierarchyIndex() + 1);
            if (colist == null || colist.size() <= 0) continue;
            info.setList(colist);
        }
        return list;
    }

    public static void setFolderVisible(ArrayList folder_list, FolderInfo selectedinfo) {
        int size;
        int i;
        if (folder_list == null || folder_list.size() <= 0) {
            return;
        }
        ArrayList<FolderInfo> list = new ArrayList<FolderInfo>();
        FolderInfo info = null;
        int hierarchy_index = 0;
        int parent_id = 0;
        for (i = size = folder_list.size() - 1; i >= 0 && hierarchy_index >= 0; --i) {
            info = (FolderInfo)folder_list.get(i);
            if (info.getFolderId() == selectedinfo.getFolderId()) {
                info.setOpened(true);
                list.add(0, info);
                parent_id = info.getParentFolderId();
                hierarchy_index = info.getHierarchyIndex() - 1;
                continue;
            }
            if (info.getFolderId() != parent_id) continue;
            info.setOpened(true);
            list.add(0, info);
            parent_id = info.getParentFolderId();
            hierarchy_index = info.getHierarchyIndex() - 1;
        }
        size = folder_list.size();
        for (i = 0; i < size; ++i) {
            FolderInfo info1 = (FolderInfo)folder_list.get(i);
            boolean containsId = false;
            for (int j = 0; j < list.size(); ++j) {
                FolderInfo info2 = (FolderInfo)list.get(j);
                if (info1.getFolderId() == info2.getFolderId()) {
                    containsId = true;
                    break;
                }
                if (info1.getParentFolderId() != info2.getFolderId()) continue;
                containsId = true;
                break;
            }
            if (containsId) {
                info1.setVisible(true);
                continue;
            }
            info1.setVisible(false);
        }
    }

    public static String getFolderPosition(ArrayList folder_list, int folder_id) {
        int size;
        String sepa = "<b> &gt; </b>";
        StringBuffer folderpath = new StringBuffer();
        FolderInfo info = null;
        int parent_id = -1;
        for (int i = size = folder_list.size() - 1; i >= 0; --i) {
            info = (FolderInfo)folder_list.get(i);
            if (info.getFolderId() <= 1) {
                folderpath.insert(0, info.getFolderName());
                break;
            }
            if (info.getFolderId() == folder_id) {
                folderpath.append(sepa);
                folderpath.append(info.getFolderName());
                parent_id = info.getParentFolderId();
                continue;
            }
            if (info.getFolderId() != parent_id) continue;
            folderpath.insert(0, info.getFolderName());
            folderpath.insert(0, sepa);
            parent_id = info.getParentFolderId();
        }
        return folderpath.toString();
    }

    public static FolderInfo getSelectedFolderInfo(ArrayList list, int folder_id) {
        FolderInfo selected_folderinfo = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            FolderInfo info = (FolderInfo)list.get(i);
            if (info.getFolderId() != folder_id) continue;
            selected_folderinfo = info;
            break;
        }
        return selected_folderinfo;
    }

    public static String getSaveDirPath(String orgId) {
        return FOLDER_FILEDIR_CABINET + File.separator + orgId + File.separator + "cabinet";
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static String getAbsolutePath(String orgId, String fileName) {
        StringBuffer sb = new StringBuffer().append(FOLDER_FILEDIR_CABINET).append(File.separator).append(orgId).append(File.separator).append("cabinet");
        File f = new File(sb.toString());
        if (!f.exists()) {
            f.mkdirs();
        }
        return sb.append(File.separator).append(fileName).toString();
    }
}

