/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cabinet.CabinetFileResultData;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetSelectData.class.getName());
    private FolderInfo selected_folderinfo = null;
    private ArrayList folder_hierarchy_list;
    private int fileSum;
    private boolean isNormalContext = false;

    public void setIsNormalContext(boolean flg) {
        this.isNormalContext = flg;
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1c-sort"));
            logger.debug((Object)("[CabinetSelectData] Init Parameter. : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1c-sort")));
        }
        int fid = 1;
        if (this.isNormalContext) {
            String id = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-folder");
            fid = Integer.parseInt(id);
        } else {
            String tmpfid;
            if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
            }
            if ((tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id")) != null && !"".equals(tmpfid)) {
                try {
                    fid = Integer.parseInt(tmpfid);
                }
                catch (Exception e) {
                    fid = 1;
                }
            }
        }
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        if (this.folder_hierarchy_list != null && this.folder_hierarchy_list.size() > 0) {
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = (FolderInfo)this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != fid) continue;
                this.selected_folderinfo = info;
                break;
            }
            if (this.selected_folderinfo == null) {
                this.selected_folderinfo = (FolderInfo)this.folder_hierarchy_list.get(0);
            }
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            CabinetUtils.setFolderVisible(this.folder_hierarchy_list, this.selected_folderinfo);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            if (list == null) {
                return new ArrayList();
            }
            this.fileSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTCabinetFile.class);
        query.addCustomDbAttribute("FILE_ID");
        query.addCustomDbAttribute("FOLDER_ID");
        query.addCustomDbAttribute("FILE_TITLE");
        query.addCustomDbAttribute("FILE_NAME");
        query.addCustomDbAttribute("FILE_SIZE");
        query.addCustomDbAttribute("UPDATE_USER_ID");
        query.addCustomDbAttribute("UPDATE_DATE");
        if (this.selected_folderinfo != null) {
            Expression exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)this.selected_folderinfo.getFolderId());
            query.setQualifier(exp);
        }
        query.setDistinct(true);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return CabinetUtils.getEipTCabinetFile(rundata, context);
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            DataRow dataRow = (DataRow)obj;
            CabinetFileResultData rd = new CabinetFileResultData();
            rd.initField();
            rd.setFileId(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FILE_ID")).longValue());
            rd.setFileTitle((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FILE_TITLE"));
            rd.setFileName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FILE_NAME"));
            rd.setFileSize((Long)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FILE_SIZE"));
            String updateUserName = "";
            ALEipUser updateUser = ALEipUtils.getALEipUser((int)((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"UPDATE_USER_ID")));
            if (updateUser != null) {
                updateUserName = updateUser.getAliasName().getValue();
            }
            rd.setUpdateUser(updateUserName);
            rd.setUpdateDate(ALDateUtil.format((Date)((Date)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"UPDATE_DATE")), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTCabinetFile record = (EipTCabinetFile)obj;
            CabinetFileResultData rd = new CabinetFileResultData();
            rd.initField();
            rd.setFileId(record.getFileId().longValue());
            rd.setFileTitle(record.getFileTitle());
            rd.setFileName(record.getFileName());
            rd.setFileSize(record.getFileSize());
            rd.setPosition(CabinetUtils.getFolderPosition(this.folder_hierarchy_list, record.getFolderId()));
            rd.setNote(record.getNote());
            String createUserName = "";
            ALEipUser createUser = ALEipUtils.getALEipUser((int)record.getCreateUserId());
            if (createUser != null) {
                createUserName = createUser.getAliasName().getValue();
            }
            rd.setCreateUser(createUserName);
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            String updateUserName = "";
            ALEipUser updateUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
            if (updateUser != null) {
                updateUserName = updateUser.getAliasName().getValue();
            }
            rd.setUpdateUser(updateUserName);
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public ArrayList getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("file_title", "fileTitle");
        map.putValue("file_name", "fileName");
        map.putValue("update_date", "updateDate");
        map.putValue("file_size", "fileSize");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public int getFileSum() {
        return this.fileSum;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }
}

