/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cabinet.CabinetFolderResultData;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFolderSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFolderSelectData.class.getName());
    private ArrayList folder_hierarchy_list;
    int folder_id = 0;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3c-sort"));
            logger.debug((Object)("[CabinetSelectData] Init Parameter. : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3c-sort")));
        }
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return CabinetUtils.getEipTCabinetFolder(rundata, context);
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultDataDetail(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTCabinetFolder record = (EipTCabinetFolder)obj;
            this.folder_id = record.getFolderId();
            CabinetFolderResultData rd = new CabinetFolderResultData();
            rd.initField();
            rd.setFolderId(record.getFolderId().longValue());
            rd.setFolderName(record.getFolderName());
            rd.setNote(record.getNote());
            rd.setPosition(CabinetUtils.getFolderPosition(this.folder_hierarchy_list, this.folder_id));
            String createUserName = "";
            ALEipUser createUser = ALEipUtils.getALEipUser((int)record.getCreateUserId());
            if (createUser != null) {
                createUserName = createUser.getAliasName().getValue();
            }
            rd.setCreateUser(createUserName);
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            String updateUserName = "";
            ALEipUser updateUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
            if (updateUser != null) {
                updateUserName = updateUser.getAliasName().getValue();
            }
            rd.setUpdateUser(updateUserName);
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = (FolderInfo)this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != record.getFolderId().intValue()) continue;
                rd.setCanUpdate(info.canUpdate());
                break;
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public int getFolderId() {
        return this.folder_id;
    }

    public String getAclPortletFeature() {
        return "cabinet_folder";
    }
}

