/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFolderFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFolderFormData.class.getName());
    private ALStringField folder_name;
    private ALNumberField parent_id;
    private ALStringField note;
    private ArrayList folder_hierarchy_list;
    private FolderInfo selected_folderinfo = null;
    private FolderInfo parent_folderinfo = null;
    private String folderid = null;
    private DataContext dataContext;
    private String org_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
        }
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        String tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
        int fid = 1;
        if (tmpfid != null && !"".equals(tmpfid)) {
            try {
                fid = Integer.parseInt(tmpfid);
            }
            catch (Exception e) {
                fid = 1;
            }
        } else {
            fid = 1;
        }
        FolderInfo rootFolderInfo = null;
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        if (this.folder_hierarchy_list != null && this.folder_hierarchy_list.size() > 0) {
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = (FolderInfo)this.folder_hierarchy_list.get(i);
                info.setVisible(true);
                if (info.getFolderId() == 1) {
                    rootFolderInfo = info;
                }
                if (info.getFolderId() != fid) continue;
                this.selected_folderinfo = info;
            }
        }
        if (this.selected_folderinfo == null) {
            this.selected_folderinfo = rootFolderInfo;
        }
        super.init(action, rundata, context);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            if (!rundata.getParameters().containsKey((Object)"parent_id")) {
                this.parent_id.setValue((long)this.selected_folderinfo.getFolderId());
            }
            if ("update".equals(this.getMode())) {
                this.folderid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
            }
        }
        return res;
    }

    public void initField() {
        this.folder_name = new ALStringField();
        this.folder_name.setFieldName("\u30d5\u30a9\u30eb\u30c0\u540d");
        this.folder_name.setTrim(true);
        this.parent_id = new ALNumberField();
        this.parent_id.setFieldName("\u8ffd\u52a0\u4f4d\u7f6e");
        this.parent_id.setValue(0L);
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(true);
    }

    protected void setValidator() {
        this.folder_name.setNotNull(true);
        this.folder_name.limitMaxLength(128);
        this.parent_id.limitMinValue(0L);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) {
        this.folder_name.validate(msgList);
        this.parent_id.validate(msgList);
        this.note.validate(msgList);
        if (this.existsFolderName()) {
            msgList.add("\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u540d\u3068\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u304c\u3059\u3067\u306b\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    private boolean existsFolderName() {
        String fname = this.folder_name.getValue();
        if (fname == null || "".equals(fname)) {
            return false;
        }
        try {
            SelectQuery query = new SelectQuery(EipTCabinetFolder.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)((int)this.parent_id.getValue()));
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)((int)this.parent_id.getValue()));
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"FOLDER_ID", (Object)Integer.valueOf(this.folderid));
                query.andQualifier(exp2);
            }
            List list = this.dataContext.performQuery((Query)query);
            if (list != null && list.size() > 0) {
                EipTCabinetFolder tmpfolder = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    tmpfolder = (EipTCabinetFolder)list.get(i);
                    if (!fname.equals(tmpfolder.getFolderName())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            FolderInfo info;
            int i;
            EipTCabinetFolder folder = CabinetUtils.getEipTCabinetFolder(rundata, context);
            if (folder == null) {
                return false;
            }
            this.folder_name.setValue(folder.getFolderName());
            this.note.setValue(folder.getNote());
            int folder_id = this.selected_folderinfo.getFolderId();
            ArrayList<Integer> disable_list = new ArrayList<Integer>();
            disable_list.add(folder_id);
            int size = this.folder_hierarchy_list.size();
            for (i = 0; i < size; ++i) {
                info = (FolderInfo)this.folder_hierarchy_list.get(i);
                boolean flg = false;
                int len = disable_list.size();
                for (int j = 0; j < len; ++j) {
                    Integer id = (Integer)disable_list.get(j);
                    if (info.getFolderId() != id.intValue() && info.getParentFolderId() != id.intValue()) continue;
                    flg = true;
                    break;
                }
                if (flg) {
                    info.setVisible(false);
                    disable_list.add(info.getFolderId());
                    continue;
                }
                info.setVisible(true);
            }
            for (i = 0; i < size; ++i) {
                info = (FolderInfo)this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != this.selected_folderinfo.getParentFolderId()) continue;
                this.selected_folderinfo = info;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            String folderid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
            int delete_id = Integer.parseInt(folderid);
            if (delete_id <= 1) {
                return false;
            }
            int delete_parent_id = 0;
            SelectQuery query = new SelectQuery(EipTCabinetFolder.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)Integer.valueOf(folderid));
            Expression exp2 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(folderid));
            query.setQualifier(exp1.orExp(exp2));
            List list = this.dataContext.performQuery((Query)query);
            if (list == null || list.size() <= 0) {
                return false;
            }
            ArrayList<Integer> folderids = new ArrayList<Integer>();
            EipTCabinetFolder folder = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                folder = (EipTCabinetFolder)list.get(i);
                folderids.add(folder.getFolderId());
                if (folder.getFolderId() != delete_id) continue;
                delete_parent_id = folder.getParentId();
            }
            SelectQuery delfolderquery = new SelectQuery(EipTCabinetFolder.class);
            Expression delfolderexp = ExpressionFactory.inDbExp((String)"FOLDER_ID", folderids);
            delfolderquery.setQualifier(delfolderexp);
            List delFolderList = this.dataContext.performQuery((Query)delfolderquery);
            int delFolderListsize = delFolderList.size();
            for (int i = 0; i < delFolderListsize; ++i) {
                EipTCabinetFolder delfolder = (EipTCabinetFolder)delFolderList.get(i);
                Integer entityId = delfolder.getFolderId();
                String folderName = delfolder.getFolderName();
                List cabinetfiles = CabinetUtils.getEipTCabinetFileList(delfolder.getFolderId());
                ArrayList<String> fpaths = new ArrayList<String>();
                if (cabinetfiles != null && cabinetfiles.size() > 0) {
                    int tsize = cabinetfiles.size();
                    for (int k = 0; k < tsize; ++k) {
                        fpaths.add(((EipTCabinetFile)cabinetfiles.get(k)).getFilePath());
                    }
                }
                this.dataContext.deleteObject((Persistent)delfolder);
                this.dataContext.commitChanges();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 221, folderName);
                if (fpaths.size() <= 0) continue;
                File file = null;
                int fsize = fpaths.size();
                for (int k = 0; k < fsize; ++k) {
                    file = new File(CabinetUtils.getSaveDirPath(this.org_id) + (String)fpaths.get(k));
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
            this.folder_hierarchy_list = CabinetUtils.getFolderList();
            this.selected_folderinfo = CabinetUtils.getSelectedFolderInfo(this.folder_hierarchy_list, delete_parent_id);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = false;
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            EipTCabinetFolder folder = (EipTCabinetFolder)this.dataContext.createAndRegisterNewObject(EipTCabinetFolder.class);
            folder.setParentId(Integer.valueOf((int)this.parent_id.getValue()));
            folder.setFolderName(this.folder_name.getValue());
            folder.setNote(this.note.getValue());
            folder.setCreateUserId(Integer.valueOf(uid));
            folder.setUpdateUserId(Integer.valueOf(uid));
            folder.setCreateDate(Calendar.getInstance().getTime());
            folder.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 221, this.folder_name.getValue());
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = (FolderInfo)this.folder_hierarchy_list.get(i);
                if ((long)info.getFolderId() != this.parent_id.getValue()) continue;
                this.parent_folderinfo = info;
                break;
            }
            this.selected_folderinfo.setFolderId(folder.getFolderId());
            this.selected_folderinfo.setFolderName(folder.getFolderName());
            this.selected_folderinfo.setHierarchyIndex(this.parent_folderinfo.getHierarchyIndex() + 1);
            this.selected_folderinfo.setParentFolderId(this.parent_folderinfo.getFolderId());
            res = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTCabinetFolder folder = CabinetUtils.getEipTCabinetFolder(rundata, context);
            if (folder == null) {
                return false;
            }
            int uid = ALEipUtils.getUserId((RunData)rundata);
            folder.setFolderName(this.folder_name.getValue());
            folder.setParentId(Integer.valueOf((int)this.parent_id.getValue()));
            folder.setNote(this.note.getValue());
            folder.setUpdateUserId(Integer.valueOf(uid));
            folder.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 221, this.folder_name.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getFolderName() {
        return this.folder_name;
    }

    public ALNumberField getParentId() {
        return this.parent_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ArrayList getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getAclPortletFeature() {
        return "cabinet_folder";
    }
}

