/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cabinet.CabinetFileResultData;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFileWordSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFileWordSelectData.class.getName());
    private ALStringField searchWord;
    private int searchSum = 0;
    private FolderInfo selected_folderinfo = null;
    private ArrayList folder_hierarchy_list;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"folder_name");
        }
        int fid = 1;
        String tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
        if (tmpfid != null && !"".equals(tmpfid)) {
            try {
                fid = Integer.parseInt(tmpfid);
            }
            catch (Exception e) {
                fid = 1;
            }
        }
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        if (this.folder_hierarchy_list != null && this.folder_hierarchy_list.size() > 0) {
            int size = this.folder_hierarchy_list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = (FolderInfo)this.folder_hierarchy_list.get(i);
                if (info.getFolderId() != fid) continue;
                this.selected_folderinfo = info;
                break;
            }
            if (this.selected_folderinfo == null) {
                this.selected_folderinfo = (FolderInfo)this.folder_hierarchy_list.get(0);
            }
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        if (!rundata.getParameters().containsKey((Object)"start") && !rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"CabinetFileWord", (String)rundata.getParameters().getString("sword"));
        }
        this.searchWord = new ALStringField();
        this.searchWord.setTrim(true);
        this.searchWord.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"CabinetFileWord"));
        try {
            CabinetUtils.setFolderVisible(this.folder_hierarchy_list, this.selected_folderinfo);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            if (list != null) {
                this.searchSum = list.size();
                return this.buildPaginatedList(list);
            }
            logger.info((Object)"cabinetFile search > result is null");
            return new ArrayList();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(Object obj) {
        try {
            EipTCabinetFile record = (EipTCabinetFile)obj;
            CabinetFileResultData rd = new CabinetFileResultData();
            rd.initField();
            rd.setFileId(record.getFileId().longValue());
            rd.setFileTitle(record.getFileTitle());
            rd.setFileName(record.getFileName());
            rd.setFileSize(record.getFileSize());
            rd.setFolderId(record.getEipTCabinetFolder().getFolderId());
            rd.setFolderName(record.getEipTCabinetFolder().getFolderName());
            String updateUserName = "";
            ALEipUser updateUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
            if (updateUser != null) {
                updateUserName = updateUser.getAliasName().getValue();
            }
            rd.setUpdateUser(updateUserName);
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("folder_name", "eipTCabinetFolder.folderName");
        map.putValue("file_title", "fileTitle");
        map.putValue("file_name", "fileName");
        map.putValue("update_date", "updateDate");
        map.putValue("file_size", "fileSize");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTCabinetFile.class);
        String word = this.searchWord.getValue();
        Expression exp11 = ExpressionFactory.likeExp((String)"fileTitle", (Object)("%" + word + "%"));
        Expression exp12 = ExpressionFactory.likeExp((String)"fileName", (Object)("%" + word + "%"));
        Expression exp13 = ExpressionFactory.likeExp((String)"note", (Object)("%" + word + "%"));
        query.setQualifier(exp11.orExp(exp12).orExp(exp13));
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }

    public int getSearchSum() {
        return this.searchSum;
    }

    public ArrayList getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }
}

