/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFileMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFileMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTCabinetFile.class);
            Expression exp = ExpressionFactory.inDbExp((String)"FILE_ID", (Collection)values);
            query.setQualifier(exp);
            List filelist = dataContext.performQuery((Query)query);
            if (filelist == null || filelist.size() == 0) {
                return false;
            }
            ArrayList<String> fpaths = new ArrayList<String>();
            for (int i = 0; i < filelist.size(); ++i) {
                EipTCabinetFile cabinetfile = (EipTCabinetFile)filelist.get(i);
                fpaths.add(cabinetfile.getFilePath());
            }
            int filelistsize = filelist.size();
            for (int i = 0; i < filelistsize; ++i) {
                EipTCabinetFile file = (EipTCabinetFile)filelist.get(i);
                Integer entityId = file.getFileId();
                String fileName = file.getFileTitle();
                dataContext.deleteObject((Persistent)file);
                dataContext.commitChanges();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 220, fileName);
            }
            int fpathSize = fpaths.size();
            if (fpathSize > 0) {
                String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
                File file = null;
                for (int i = 0; i < fpathSize; ++i) {
                    file = new File(CabinetUtils.getSaveDirPath(org_id) + (String)fpaths.get(i));
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }
}

