/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFileFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFileFormData.class.getName());
    private ALNumberField folder_id;
    private ALStringField file_title;
    private ALStringField file_name;
    private ALNumberField file_size;
    private ALStringField note;
    private ArrayList folder_hierarchy_list;
    private FolderInfo selected_folderinfo = null;
    private String folderName = null;
    private String fileid = null;
    private String org_id = null;
    private DataContext dataContext;
    private List fileuploadList = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
        }
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        String tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
        int fid = 1;
        if (tmpfid != null && !"".equals(tmpfid)) {
            try {
                fid = Integer.parseInt(tmpfid);
            }
            catch (Exception e) {
                fid = 1;
            }
        }
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        int size = this.folder_hierarchy_list.size();
        for (int i = 0; i < size; ++i) {
            FolderInfo info = (FolderInfo)this.folder_hierarchy_list.get(i);
            if (info.getFolderId() != fid) continue;
            this.selected_folderinfo = info;
        }
        this.folderName = rundata.getParameters().getString("folderName");
    }

    public void initField() {
        this.folder_id = new ALNumberField();
        this.folder_id.setFieldName("\u30d5\u30a9\u30eb\u30c0");
        this.folder_id.setNotNull(true);
        this.folder_id.setValue(0L);
        this.file_title = new ALStringField();
        this.file_title.setFieldName("\u30bf\u30a4\u30c8\u30eb");
        this.file_title.setTrim(true);
        this.file_name = new ALStringField();
        this.file_name.setFieldName("\u30d5\u30a1\u30a4\u30eb\u540d");
        this.file_name.setTrim(true);
        this.file_size = new ALNumberField();
        this.file_size.setFieldName("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba");
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(true);
        this.fileuploadList = new ArrayList();
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            if (!rundata.getParameters().containsKey((Object)"folder_id")) {
                try {
                    this.folder_id.setValue((long)this.selected_folderinfo.getFolderId());
                }
                catch (Exception e) {
                    this.folder_id.setValue(1L);
                }
            }
            if ("update".equals(this.getMode())) {
                this.fileid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            }
        }
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
            FileuploadLiteBean filebean = null;
            if (this.fileuploadList != null) {
                filebean = (FileuploadLiteBean)this.fileuploadList.get(0);
                this.file_name.setValue(filebean.getFileName());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return res;
    }

    protected void setValidator() {
        this.file_title.setNotNull(true);
        this.file_title.limitMaxLength(128);
        this.file_name.setNotNull(true);
        this.file_name.limitMaxLength(128);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) {
        this.file_title.validate(msgList);
        if ("insert".equals(this.getMode())) {
            this.file_name.validate(msgList);
        } else if (this.fileuploadList != null && this.fileuploadList.size() > 0) {
            this.file_name.validate(msgList);
        }
        this.note.validate(msgList);
        if (this.existsFileName()) {
            msgList.add("\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u540c\u3058\u30d5\u30a1\u30a4\u30eb\u304c\u3059\u3067\u306b\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    private boolean existsFileName() {
        String fname = this.file_name.getValue();
        if (fname == null || "".equals(fname)) {
            return false;
        }
        try {
            SelectQuery query = new SelectQuery(EipTCabinetFile.class);
            query.addCustomDbAttribute("FILE_NAME");
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)((int)this.folder_id.getValue()));
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)((int)this.folder_id.getValue()));
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"FILE_ID", (Object)Integer.valueOf(this.fileid));
                query.andQualifier(exp2);
            }
            List list = this.dataContext.performQuery((Query)query);
            if (list != null && list.size() > 0) {
                DataRow dataRow = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    dataRow = (DataRow)list.get(i);
                    if (!fname.equals((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FILE_NAME"))) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTCabinetFile file = CabinetUtils.getEipTCabinetFile(rundata, context);
            if (file == null) {
                return false;
            }
            this.folder_id.setValue((long)file.getFolderId().intValue());
            this.file_title.setValue(file.getFileTitle());
            this.file_name.setValue(file.getFileName());
            this.file_size.setValue(file.getFileSize().longValue());
            this.note.setValue(file.getNote());
            this.folderName = Integer.toString(file.getFolderId());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTCabinetFile file = CabinetUtils.getEipTCabinetFile(rundata, context);
            if (file == null) {
                return false;
            }
            String local_file_pass = file.getFilePath();
            int entityId = file.getFileId();
            String fileName = file.getFileTitle();
            this.dataContext.deleteObject((Persistent)file);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 220, fileName);
            if (local_file_pass != null && !"".equals(local_file_pass)) {
                File local_file = null;
                local_file = new File(CabinetUtils.getSaveDirPath(this.org_id) + local_file_pass);
                if (local_file.exists()) {
                    local_file.delete();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = false;
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            FileuploadLiteBean filebean = (FileuploadLiteBean)this.fileuploadList.get(0);
            String filename = FileuploadUtils.getNewFileName((String)CabinetUtils.getSaveDirPath(this.org_id));
            File destFile = new File(CabinetUtils.getAbsolutePath(this.org_id, filename));
            File srcFile = FileuploadUtils.getAbsolutePath((String)this.org_id, (int)uid, (String)this.folderName, (int)filebean.getFileId());
            FileuploadUtils.copyFile((File)srcFile, (File)destFile);
            double fileSize = Math.ceil((double)destFile.length() / 1024.0);
            EipTCabinetFolder folder = (EipTCabinetFolder)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipTCabinetFolder.class, (Object)((int)this.folder_id.getValue()));
            EipTCabinetFile file = (EipTCabinetFile)this.dataContext.createAndRegisterNewObject(EipTCabinetFile.class);
            file.setEipTCabinetFolder(folder);
            file.setFileTitle(this.file_title.getValue());
            file.setFileName(this.file_name.getValue());
            file.setFileSize(Long.valueOf((long)fileSize));
            file.setFilePath(CabinetUtils.getRelativePath(filename));
            file.setNote(this.note.getValue());
            file.setCreateUserId(Integer.valueOf(uid));
            file.setUpdateUserId(Integer.valueOf(uid));
            file.setCreateDate(Calendar.getInstance().getTime());
            file.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(file.getFileId().intValue(), 220, this.file_title.getValue());
            File folder_tmp = FileuploadUtils.getFolder((String)this.org_id, (int)uid, (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder_tmp);
            res = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            EipTCabinetFile file = CabinetUtils.getEipTCabinetFile(rundata, context);
            if (file == null) {
                return false;
            }
            boolean is_upload = true;
            if (this.fileuploadList == null) {
                is_upload = false;
            }
            if (is_upload) {
                FileuploadLiteBean filebean = (FileuploadLiteBean)this.fileuploadList.get(0);
                String filename = FileuploadUtils.getNewFileName((String)CabinetUtils.getSaveDirPath(this.org_id));
                File destFile = new File(CabinetUtils.getAbsolutePath(this.org_id, filename));
                File srcFile = FileuploadUtils.getAbsolutePath((String)this.org_id, (int)uid, (String)this.folderName, (int)filebean.getFileId());
                FileuploadUtils.copyFile((File)srcFile, (File)destFile);
                file.setFileName(this.file_name.getValue());
                double fileSize = Math.ceil((double)destFile.length() / 1024.0);
                file.setFileSize(Long.valueOf((long)fileSize));
                file.setFilePath(CabinetUtils.getRelativePath(filename));
                file.setCreateUserId(Integer.valueOf(uid));
                file.setCreateDate(Calendar.getInstance().getTime());
            }
            EipTCabinetFolder folder = (EipTCabinetFolder)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipTCabinetFolder.class, (Object)((int)this.folder_id.getValue()));
            file.setEipTCabinetFolder(folder);
            file.setFileTitle(this.file_title.getValue());
            file.setNote(this.note.getValue());
            file.setUpdateUserId(Integer.valueOf(uid));
            file.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(file.getFileId().intValue(), 220, this.file_title.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public ALNumberField getFolderId() {
        return this.folder_id;
    }

    public ALStringField getFileTitle() {
        return this.file_title;
    }

    public ALStringField getFileName() {
        return this.file_name;
    }

    public ALNumberField getFileSize() {
        return this.file_size;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ArrayList getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }
}

