/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog.util;

import com.aimluck.eip.blog.BlogThemaResultData;
import com.aimluck.eip.blog.BlogUserResultData;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogUtils.class.getName());
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String OWNER_ID = "ownerid";
    public static final String ATTACHMENT_TEMP_FILENAME = "file";
    public static final String ATTACHMENT_TEMP_FILENAME_REMAIND = "file.txt";
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    protected static final String FOLDER_FILEDIR_BLOG = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final String PREFIX_DBFILE = "DBF";

    public static EipTBlogEntry getEipTBlogEntry(RunData rundata, Context context) {
        String entryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (entryid == null || Integer.valueOf(entryid) == null) {
                logger.debug((Object)"[Blog Entry] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlogEntry.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"ENTRY_ID", (Object)Integer.valueOf(entryid));
            query.setQualifier(exp);
            List entrys = dataContext.performQuery((Query)query);
            if (entrys == null || entrys.size() == 0) {
                logger.debug((Object)"[Blog Entry] Not found ID...");
                return null;
            }
            return (EipTBlogEntry)entrys.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTBlogThema getEipTBlogThema(RunData rundata, Context context) {
        String themaid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (themaid == null || Integer.valueOf(themaid) == null) {
                logger.debug((Object)"[Blog] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlogThema.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"THEMA_ID", (Object)Integer.valueOf(themaid));
            query.setQualifier(exp);
            List themas = dataContext.performQuery((Query)query);
            if (themas == null || themas.size() == 0) {
                logger.debug((Object)"[Blog] Not found ID...");
                return null;
            }
            return (EipTBlogThema)themas.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTBlogThema getEipTBlogThema(DataContext dataContext, Long thema_id) {
        try {
            EipTBlogThema thema = (EipTBlogThema)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTBlogThema.class, (Object)thema_id);
            return thema;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTBlog getEipTBlog(RunData rundata, Context context) {
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlog.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)uid);
            query.setQualifier(exp);
            List blogs = dataContext.performQuery((Query)query);
            if (blogs == null || blogs.size() == 0) {
                logger.debug((Object)"[Blog Entry] Not found ID...");
                return null;
            }
            return (EipTBlog)blogs.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTBlogComment getEipTBlogComment(RunData rundata, Context context, String commentid) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (commentid == null || Integer.valueOf(commentid) == null) {
                logger.debug((Object)"[BlogUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlogComment.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"COMMENT_ID", (Object)Integer.valueOf(commentid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)userid);
            query.andQualifier(exp2);
            List comments = dataContext.performQuery((Query)query);
            if (comments == null || comments.size() == 0) {
                logger.debug((Object)"[BlogUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTBlogComment)comments.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[BlogUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTBlogFile getEipTBlogFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int ownerid = rundata.getParameters().getInt(OWNER_ID, -1);
            int entryid = rundata.getParameters().getInt("entityid", -1);
            int fileid = rundata.getParameters().getInt("attachmentIndex", -1);
            if (ownerid <= 0 || entryid <= 0 || fileid <= 0) {
                logger.debug((Object)"[BlogUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlogFile.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)fileid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ownerid);
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchDbExp((String)"ENTRY_ID", (Object)entryid);
            query.andQualifier(exp3);
            List files = dataContext.performQuery((Query)query);
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[BlogUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTBlogFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[BlogUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTBlogEntry getEipTBlogParentEntry(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String entryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (entryid == null || Integer.valueOf(entryid) == null) {
                logger.debug((Object)"[BlogUtil] Empty ID...");
                throw new ALPageNotFoundException();
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlogEntry.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"ENTRY_ID", (Object)Integer.valueOf(entryid));
            query.setQualifier(exp);
            List entrys = dataContext.performQuery((Query)query);
            if (entrys == null || entrys.size() == 0) {
                logger.debug((Object)"[BlogUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTBlogEntry entry = (EipTBlogEntry)entrys.get(0);
            return entry;
        }
        catch (Exception ex) {
            logger.error((Object)"[EntryUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static ArrayList getThemaList(RunData rundata, Context context) {
        ArrayList<BlogThemaResultData> themaList = new ArrayList<BlogThemaResultData>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlogThema.class);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTBlogThema record = (EipTBlogThema)aList.get(i);
                BlogThemaResultData rd = new BlogThemaResultData();
                rd.initField();
                rd.setThemaId(record.getThemaId().longValue());
                rd.setThemaName(record.getThemaName());
                themaList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return themaList;
    }

    public static String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public static List getBlogUserResultDataList(String groupname) {
        ArrayList<BlogUserResultData> list = new ArrayList<BlogUserResultData>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, B.PHOTO, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = '").append(groupname).append("' ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
            rawSelect.setFetchingDataRows(true);
            List ulist = dataContext.performQuery((Query)rawSelect);
            int recNum = ulist.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)ulist.get(j);
                BlogUserResultData user = new BlogUserResultData();
                user.initField();
                user.setUserId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"USER_ID"));
                user.setName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LOGIN_NAME"));
                user.setAliasName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"), (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME"));
                byte[] photo = (byte[])ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"PHOTO");
                if (photo != null && photo.length > 0) {
                    user.setHasPhoto(true);
                } else {
                    user.setHasPhoto(false);
                }
                list.add(user);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[BlogUtils]", (Throwable)ex);
        }
        return list;
    }

    public static ALBaseUser getBaseUser(int userid) {
        String uid = String.valueOf(userid);
        try {
            if (uid == null) {
                logger.debug((Object)"Empty ID...");
                return null;
            }
            return (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(uid));
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getUserFullName(int userid) {
        String userName = "";
        ALBaseUser user = BlogUtils.getBaseUser(userid);
        if (user != null) {
            userName = new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString();
        }
        return userName;
    }

    public static String compressString(String src, int length) {
        String subject;
        if (src == null || src.length() == 0 || length <= 0) {
            return src;
        }
        if (src.length() > length) {
            subject = src.substring(0, length);
            subject = subject + "\u30fb\u30fb\u30fb";
        } else {
            subject = src;
        }
        return subject;
    }

    private static int getDBFileId(String str) {
        if (str == null || !str.startsWith(PREFIX_DBFILE)) {
            return -1;
        }
        String token = str.substring(PREFIX_DBFILE.length(), str.length());
        return Integer.parseInt(token);
    }

    public static String getPortletURIinPersonalConfigPane(RunData rundata, String portletEntryName) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId() + "," + entries[j].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return FOLDER_FILEDIR_BLOG + File.separator + orgId + File.separator + "blog" + File.separator + uid;
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static String getAbsolutePath(String orgId, int uid, String fileName) {
        StringBuffer sb = new StringBuffer().append(FOLDER_FILEDIR_BLOG).append(File.separator).append(orgId).append(File.separator).append("blog").append(File.separator).append(uid);
        File f = new File(sb.toString());
        if (!f.exists()) {
            f.mkdirs();
        }
        return sb.append(File.separator).append(fileName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getFileuploadList(RunData rundata) {
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadBean> fileNameList = new ArrayList<FileuploadBean>();
        FileuploadBean filebean = null;
        int fileid = 0;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
            File folder = FileuploadUtils.getFolder((String)org_id, (int)ALEipUtils.getUserId((RunData)rundata), (String)folderName);
            String folderpath = folder.getAbsolutePath();
            int length = newfileids.size();
            for (int i = 0; i < length; ++i) {
                if (newfileids.get(i) == null || newfileids.get(i).equals("")) continue;
                try {
                    fileid = Integer.parseInt((String)newfileids.get(i));
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(folderpath + File.separator + fileid + ".txt"), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(fileids[i]);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Exception", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (int k = 0; k < hadfileids.size(); ++k) {
                try {
                    fileid = Integer.parseInt((String)hadfileids.get(k));
                    hadfileidsValue.add(fileid);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                SelectQuery reqquery = new SelectQuery(EipTBlogFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = dataContext.performQuery((Query)reqquery);
                int requestssize = requests.size();
                for (int i = 0; i < requestssize; ++i) {
                    EipTBlogFile file = (EipTBlogFile)requests.get(i);
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getTitle());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[BlogUtils] Exception.", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public static List getEipTBlogFileList(int entryId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTBlogFile.class);
            Expression exp = ExpressionFactory.matchExp((String)"eipTBlogEntry", (Object)entryId);
            query.setQualifier(exp);
            List files = dataContext.performQuery((Query)query);
            if (files == null || files.size() == 0) {
                return null;
            }
            return files;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static boolean hasMinimumAuthority(RunData rundata) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "blog_entry_self", 1);
        if (!hasAuthority) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        return true;
    }
}

