/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.BlogEntryResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogWordSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogWordSelectData.class.getName());
    private ALStringField searchWord;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        ArrayList list;
        if (!rundata.getParameters().containsKey((Object)"start") && !rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"Blogsword", (String)rundata.getParameters().getString("sword"));
        }
        this.searchWord = new ALStringField();
        this.searchWord.setTrim(true);
        this.searchWord.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"Blogsword"));
        try {
            list = this.searchList(rundata, context);
            if (list == null) {
                list = new ArrayList();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return this.buildPaginatedList(list);
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(Object obj) {
        try {
            DataRow dataRow = (DataRow)obj;
            Integer entry_id = (Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"ENTRY_ID");
            long ower_id = ((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"OWNER_ID")).longValue();
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(entry_id.longValue());
            rd.setOwnerId(ower_id);
            rd.setOwnerName(BlogUtils.getUserFullName((int)ower_id));
            rd.setTitle((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"TITLE"));
            rd.setNote(BlogUtils.compressString((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"NOTE"), 100));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09");
            rd.setTitleDate(sdf.format((Date)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"CREATE_DATE")));
            SelectQuery query = new SelectQuery(EipTBlogComment.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)entry_id);
            query.setQualifier(exp);
            List list = this.dataContext.performQuery((Query)query);
            if (list != null && list.size() > 0) {
                rd.setCommentsNum(list.size());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    private List searchList(RunData rundata, Context context) {
        List list = null;
        try {
            String word = this.searchWord.getValue();
            if (word == null || word.length() == 0) {
                return new ArrayList();
            }
            StringBuffer statement = new StringBuffer();
            statement.append("SELECT DISTINCT t0.entry_id, t0.owner_id, t0.title, t0.note, ");
            statement.append("t0.thema_id, t0.update_date, t0.create_date ");
            statement.append("FROM eip_t_blog_entry as t0 left join eip_t_blog_comment as t1 on t1.entry_id = t0.entry_id ");
            statement.append("WHERE  (t0.title LIKE '%" + word + "%') OR (t0.note LIKE '%" + word + "%')  OR (t0.entry_id = t1.entry_id AND (t1.comment LIKE '%" + word + "%')) ORDER BY t0.create_date DESC");
            String query = statement.toString();
            SQLTemplate rawSelect = new SQLTemplate(EipTBlogEntry.class, query, true);
            rawSelect.setFetchingDataRows(true);
            list = this.dataContext.performQuery((Query)rawSelect);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList();
        }
        return list;
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }
}

