/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.blog.BlogThemaResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogThemaSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogThemaSelectData.class.getName());
    private int themaSum;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"thema_name");
            logger.debug((Object)"[BlogCategorySelectData] Init Parameter. : thema_name");
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = this.dataContext.performQuery((Query)query);
            this.themaSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTBlogThema.class);
        Expression exp = ExpressionFactory.noMatchDbExp((String)"THEMA_ID", (Object)1);
        query.setQualifier(exp);
        return query;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return BlogUtils.getEipTBlogThema(rundata, context);
    }

    protected Object getResultData(Object obj) {
        EipTBlogThema record = (EipTBlogThema)obj;
        BlogThemaResultData rd = new BlogThemaResultData();
        rd.initField();
        rd.setThemaId(record.getThemaId().longValue());
        rd.setThemaName(ALCommonUtils.compressString((String)record.getThemaName(), (int)this.getStrLength()));
        rd.setDescription(record.getDescription());
        return rd;
    }

    protected Object getResultDataDetail(Object obj) {
        EipTBlogThema record = (EipTBlogThema)obj;
        BlogThemaResultData rd = new BlogThemaResultData();
        rd.initField();
        rd.setThemaId(record.getThemaId().longValue());
        rd.setThemaName(record.getThemaName());
        rd.setDescription(record.getDescription());
        rd.setCreateUserName(BlogUtils.getUserFullName(record.getCreateUserId()));
        rd.setUpdateUserName(BlogUtils.getUserFullName(record.getUpdateUserId()));
        rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("thema_name", "themaName");
        return map;
    }

    public int getThemaSum() {
        return this.themaSum;
    }

    public String getAclPortletFeature() {
        return "blog_theme";
    }
}

