/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.eip.blog.BlogEntrySelectData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogThemaMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogThemaMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            ArrayList<Integer> intValues = new ArrayList<Integer>();
            int valuesize = values.size();
            for (int i = 0; i < valuesize; ++i) {
                intValues.add(Integer.valueOf((String)values.get(i)));
            }
            SelectQuery query = new SelectQuery(EipTBlogThema.class);
            Expression exp2 = ExpressionFactory.inDbExp((String)"THEMA_ID", (Collection)values);
            query.setQualifier(exp2);
            List themalist = dataContext.performQuery((Query)query);
            if (themalist == null || themalist.size() == 0) {
                return false;
            }
            ArrayList<Integer> themaIds = new ArrayList<Integer>();
            EipTBlogThema thema = null;
            int themasize = themalist.size();
            for (int i = 0; i < themasize; ++i) {
                thema = (EipTBlogThema)themalist.get(i);
                themaIds.add(thema.getThemaId());
            }
            SelectQuery reqquery = new SelectQuery(EipTBlogEntry.class);
            Expression reqexp1 = ExpressionFactory.inDbExp((String)"eipTBlogThema.THEMA_ID", (Collection)values);
            reqquery.setQualifier(reqexp1);
            List requests = dataContext.performQuery((Query)reqquery);
            if (requests != null && requests.size() > 0) {
                EipTBlogEntry request = null;
                EipTBlogThema defaultThema = BlogUtils.getEipTBlogThema(dataContext, 1L);
                int size = requests.size();
                for (int i = 0; i < size; ++i) {
                    request = (EipTBlogEntry)requests.get(i);
                    request.setEipTBlogThema(defaultThema);
                }
            }
            dataContext.commitChanges();
            int themalistsize = themalist.size();
            for (int i = 0; i < themalistsize; ++i) {
                EipTBlogThema delete_thema = (EipTBlogThema)themalist.get(i);
                Integer entityId = delete_thema.getThemaId();
                String themaName = delete_thema.getThemaName();
                dataContext.deleteObject((Persistent)delete_thema);
                dataContext.commitChanges();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 111, themaName);
            }
            String filtername = BlogEntrySelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "blog_theme";
    }
}

