/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogThemaFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogThemaFormData.class.getName());
    private ALStringField thema_name;
    private ALStringField description;
    private int thema_id;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.thema_name = new ALStringField();
        this.thema_name.setFieldName("\u30c6\u30fc\u30de\u540d");
        this.thema_name.setTrim(true);
        this.description = new ALStringField();
        this.description.setFieldName("\u8aac\u660e");
        this.description.setTrim(true);
    }

    protected void setValidator() {
        this.thema_name.setNotNull(true);
        this.thema_name.limitMaxLength(50);
        this.description.limitMaxLength(1000);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res && "update".equals(this.getMode())) {
            this.thema_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
        }
        return res;
    }

    protected boolean validate(ArrayList msgList) {
        try {
            SelectQuery query = new SelectQuery(EipTBlogThema.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"themaName", (Object)this.thema_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"themaName", (Object)this.thema_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"THEMA_ID", (Object)this.thema_id);
                query.andQualifier(exp2);
            }
            if (this.dataContext.performQuery((Query)query).size() != 0) {
                msgList.add("\u30c6\u30fc\u30de\u540d\u300e <span class='em'>" + this.thema_name + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        this.thema_name.validate(msgList);
        this.description.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTBlogThema thema = BlogUtils.getEipTBlogThema(rundata, context);
            if (thema == null) {
                return false;
            }
            this.thema_name.setValue(thema.getThemaName());
            this.description.setValue(thema.getDescription());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            this.doCheckAclPermission(rundata, context, 4);
            int uid = ALEipUtils.getUserId((RunData)rundata);
            EipTBlogThema thema = (EipTBlogThema)this.dataContext.createAndRegisterNewObject(EipTBlogThema.class);
            thema.setThemaName(this.thema_name.getValue());
            thema.setDescription(this.description.getValue());
            thema.setCreateUserId(Integer.valueOf(uid));
            thema.setUpdateUserId(Integer.valueOf(uid));
            thema.setCreateDate(Calendar.getInstance().getTime());
            thema.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            this.thema_id = thema.getThemaId();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.thema_id, 111, this.thema_name.getValue());
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTBlogThema thema = BlogUtils.getEipTBlogThema(rundata, context);
            if (thema == null) {
                return false;
            }
            thema.setThemaName(this.thema_name.getValue());
            thema.setDescription(this.description.getValue());
            thema.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            thema.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(thema.getThemaId().intValue(), 111, this.thema_name.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTBlogThema thema = BlogUtils.getEipTBlogThema(rundata, context);
            if (thema == null) {
                return false;
            }
            Integer entityId = thema.getThemaId();
            this.dataContext.deleteObject((Persistent)thema);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 111, this.thema_name.getValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public int getThemaId() {
        return this.thema_id;
    }

    public ALStringField getThemaName() {
        return this.thema_name;
    }

    public ALStringField getDescription() {
        return this.description;
    }

    public String getAclPortletFeature() {
        return "blog_theme";
    }
}

