/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.blog.BlogCommentResultData;
import com.aimluck.eip.blog.BlogEntryResultData;
import com.aimluck.eip.blog.BlogFootmarkResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.blog.util.calendar.CalendarElement;
import com.aimluck.eip.blog.util.calendar.Day;
import com.aimluck.eip.blog.util.calendar.Month;
import com.aimluck.eip.blog.util.calendar.MonthCalendar;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFootmarkMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntrySelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntrySelectData.class.getName());
    private ArrayList themaList;
    private int entrySum;
    private List commentList;
    private List footmarkList;
    private int uid;
    private Month month;
    private ALDateTimeField viewStart;
    private ALDateTimeField viewEndCrt;
    private ALDateTimeField viewMonth;
    private ALDateTimeField prevMonth;
    private ALDateTimeField nextMonth;
    private String viewDay;
    private int view_uid;
    private String view_uname;
    private boolean has_photo;
    private DataContext dataContext;
    private String userAccountURI;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        Calendar cal;
        String tmpViewUid;
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"view_month")) {
                String v_month = rundata.getParameters().getString("view_month");
                if ("none".equals(v_month)) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_month");
                } else {
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_month", (String)v_month);
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_day");
                }
            }
            if (rundata.getParameters().containsKey((Object)"view_day")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_day", (String)rundata.getParameters().getString("view_day"));
            }
            if (rundata.getParameters().containsKey((Object)"view_uid")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_uid", (String)rundata.getParameters().getString("view_uid"));
            }
        }
        if ((tmpViewUid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_uid")) == null || tmpViewUid.equals("")) {
            this.view_uid = this.uid;
        } else {
            try {
                this.view_uid = Integer.parseInt(tmpViewUid);
            }
            catch (Exception e) {
                this.view_uid = this.uid;
            }
        }
        ALEipUser view_user = ALEipUtils.getALEipUser((int)this.view_uid);
        this.view_uname = view_user.getAliasName().getValue();
        this.viewMonth = new ALDateTimeField("yyyy-MM");
        this.prevMonth = new ALDateTimeField("yyyy-MM");
        this.nextMonth = new ALDateTimeField("yyyy-MM");
        this.viewStart = new ALDateTimeField("yyyy-MM-dd");
        this.viewEndCrt = new ALDateTimeField("yyyy-MM-dd");
        String tmpViewMonth = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_month");
        if (tmpViewMonth == null || tmpViewMonth.equals("")) {
            cal = Calendar.getInstance();
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            this.viewMonth.setValue(cal.getTime());
        } else {
            this.viewMonth.setValue(tmpViewMonth);
            if (!this.viewMonth.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_month");
                throw new ALPageNotFoundException();
            }
        }
        this.viewDay = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_day");
        cal = Calendar.getInstance();
        cal.setTime(this.viewMonth.getValue());
        cal.set(5, 1);
        this.viewStart.setValue(cal.getTime());
        cal.add(2, 1);
        this.viewEndCrt.setValue(cal.getTime());
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewMonth.getValue());
        cal2.add(2, 1);
        this.nextMonth.setValue(cal2.getTime());
        cal2.add(2, -2);
        this.prevMonth.setValue(cal2.getTime());
        this.loadMonthCalendar();
        ALBaseUser user = BlogUtils.getBaseUser(this.view_uid);
        this.has_photo = user.getPhoto() != null;
        this.userAccountURI = BlogUtils.getPortletURIinPersonalConfigPane(rundata, "AccountEdit");
        this.aclPortletFeature = this.view_uid == this.uid ? "blog_entry_self" : "blog_entry_other";
        super.init(action, rundata, context);
    }

    public void loadThemaList(RunData rundata, Context context) {
        this.themaList = BlogUtils.getThemaList(rundata, context);
    }

    private void loadMonthCalendar() {
        MonthCalendar c = new MonthCalendar();
        this.month = c.createCalendar(Integer.parseInt(this.viewMonth.getYear()), Integer.parseInt(this.viewMonth.getMonth()));
    }

    private void loadFootmark(EipTBlog blog) throws Exception {
        this.footmarkList = new ArrayList();
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipTBlogFootmarkMap.class);
        Expression exp = ExpressionFactory.matchExp((String)"blogId", (Object)blog.getBlogId());
        query.setQualifier(exp);
        query.addOrdering("updateDate", false);
        query.setFetchLimit(10);
        List list = dataContext.performQuery((Query)query);
        if (list != null && list.size() > 0) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTBlogFootmarkMap record = (EipTBlogFootmarkMap)list.get(i);
                BlogFootmarkResultData footmark = new BlogFootmarkResultData();
                footmark.initField();
                footmark.setUserId(record.getUserId().longValue());
                footmark.setUserName(BlogUtils.getUserFullName(record.getUserId()));
                SimpleDateFormat format = new SimpleDateFormat("MM/dd HH:mm");
                footmark.setUpdateDate(format.format(record.getUpdateDate()));
                this.footmarkList.add(footmark);
            }
        }
    }

    public List selectList(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            query.addOrdering("createDate", false);
            List aList = this.dataContext.performQuery((Query)query);
            this.entrySum = aList.size();
            List list = this.buildPaginatedList(aList);
            EipTBlog blog = null;
            if (list != null && list.size() > 0) {
                EipTBlogEntry record = (EipTBlogEntry)list.get(0);
                blog = record.getEipTBlog();
            } else {
                blog = this.getBlog(this.view_uid);
            }
            if (this.uid != this.view_uid) {
                this.footmark(rundata, blog);
            } else {
                this.loadFootmark(blog);
            }
            this.setupDetailCalendar(rundata, context);
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTBlogEntry.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)this.view_uid);
        query.setQualifier(exp1);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"createDate", (Object)this.viewStart.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"createDate", (Object)this.viewEndCrt.getValue());
        query.andQualifier(exp11.andExp(exp12));
        if (this.viewDay != null) {
            ALDateTimeField tmpViewDay = new ALDateTimeField("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.set(1, Integer.parseInt(this.viewMonth.getYear()));
            cal.set(2, Integer.parseInt(this.viewMonth.getMonth()) - 1);
            cal.set(5, Integer.parseInt(this.viewDay));
            cal.set(11, 0);
            cal.set(12, 0);
            tmpViewDay.setValue(cal.getTime());
            Expression exp21 = ExpressionFactory.greaterOrEqualExp((String)"createDate", (Object)tmpViewDay.getValue());
            cal.set(5, Integer.valueOf(this.viewDay) + 1);
            tmpViewDay.setValue(cal.getTime());
            Expression exp22 = ExpressionFactory.lessExp((String)"createDate", (Object)tmpViewDay.getValue());
            query.andQualifier(exp21.andExp(exp22));
        }
        query.setDistinct(true);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    private SelectQuery getSelectQueryForCalendar(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTBlogEntry.class);
        query.addCustomDbAttribute("CREATE_DATE");
        Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)this.view_uid);
        query.setQualifier(exp1);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"createDate", (Object)this.viewStart.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"createDate", (Object)this.viewEndCrt.getValue());
        query.andQualifier(exp11.andExp(exp12));
        query.setDistinct(true);
        return query;
    }

    protected Object getResultData(Object obj) {
        try {
            EipTBlogEntry record = (EipTBlogEntry)obj;
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(record.getEntryId().longValue());
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setTitle(ALCommonUtils.compressString((String)record.getTitle(), (int)this.getStrLength()));
            rd.setNote(BlogUtils.compressString(record.getNote(), 100));
            rd.setBlogId(record.getEipTBlog().getBlogId().longValue());
            rd.setThemaId(record.getEipTBlogThema().getThemaId().longValue());
            rd.setThemaName(ALCommonUtils.compressString((String)record.getEipTBlogThema().getThemaName(), (int)this.getStrLength()));
            rd.setAllowComments("T".equals(record.getAllowComments()));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09");
            rd.setTitleDate(sdf.format(record.getCreateDate()));
            SelectQuery query = new SelectQuery(EipTBlogComment.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)record.getEntryId());
            query.setQualifier(exp);
            List list = this.dataContext.performQuery((Query)query);
            if (list != null && list.size() > 0) {
                rd.setCommentsNum(list.size());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private boolean containsSelectedView(String viewDay, int day) {
        String dayStr = "" + day;
        if (viewDay != null && !"".equals(viewDay)) {
            return dayStr.equals(viewDay);
        }
        return true;
    }

    private void setBlogEntryToMonthCalendar(Date date) {
        CalendarElement element = null;
        if (date.getMonth() + 1 != this.month.getMonth()) {
            return;
        }
        String d_day = "" + date.getDate();
        int size = this.month.size();
        for (int i = 0; i < size; ++i) {
            element = this.month.get(i);
            if (!d_day.equals(element.getLabel())) continue;
            ((Day)element).setBlogEntry(true);
        }
    }

    private EipTBlog getBlog(int view_uid) throws Exception {
        SelectQuery query = new SelectQuery(EipTBlog.class);
        Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)view_uid);
        query.setQualifier(exp);
        List list = this.dataContext.performQuery((Query)query);
        if (list == null || list.size() <= 0) {
            EipTBlog blog = (EipTBlog)this.dataContext.createAndRegisterNewObject(EipTBlog.class);
            blog.setOwnerId(Integer.valueOf(view_uid));
            blog.setCreateDate(Calendar.getInstance().getTime());
            blog.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            return blog;
        }
        EipTBlog blog = (EipTBlog)list.get(0);
        return blog;
    }

    private void footmark(RunData rundata, EipTBlog blog) throws Exception {
        if (blog.getOwnerId() == ALEipUtils.getUserId((RunData)rundata)) {
            return;
        }
        ALDateTimeField today = new ALDateTimeField("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        today.setValue(cal.getTime());
        SelectQuery query = new SelectQuery(EipTBlogFootmarkMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"blogId", (Object)blog.getBlogId());
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.uid);
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchExp((String)"createDate", (Object)today.getValue());
        query.andQualifier(exp3);
        List list = this.dataContext.performQuery((Query)query);
        if (list == null || list.size() <= 0) {
            EipTBlogFootmarkMap footmark = (EipTBlogFootmarkMap)this.dataContext.createAndRegisterNewObject(EipTBlogFootmarkMap.class);
            footmark.setEipTBlog(blog);
            footmark.setUserId(Integer.valueOf(this.uid));
            footmark.setCreateDate(Calendar.getInstance().getTime());
            footmark.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
        } else {
            EipTBlogFootmarkMap footmark = (EipTBlogFootmarkMap)list.get(0);
            footmark.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
        }
    }

    public Object selectDetail(RunData rundata, Context context) {
        try {
            String entryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            WhatsNewUtils.shiftWhatsNewReadFlag((int)1, (int)Integer.parseInt(entryid), (int)this.uid);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        try {
            this.setupDetailCalendar(rundata, context);
            EipTBlogEntry obj = BlogUtils.getEipTBlogEntry(rundata, context);
            if (obj != null) {
                EipTBlog blog = null;
                EipTBlogEntry record = obj;
                blog = record.getEipTBlog();
                if (this.uid != this.view_uid) {
                    try {
                        this.footmark(rundata, blog);
                    }
                    catch (Exception e) {}
                } else {
                    this.loadFootmark(record.getEipTBlog());
                }
            }
            return obj;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private void setupDetailCalendar(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQueryForCalendar(rundata, context);
            query.addOrdering("updateDate", false);
            List list = this.dataContext.performQuery((Query)query);
            DataRow dataRow = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                dataRow = (DataRow)list.get(i);
                this.setBlogEntryToMonthCalendar((Date)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"CREATE_DATE"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09 HH\u6642mm\u5206");
            EipTBlogEntry record = (EipTBlogEntry)obj;
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(record.getEntryId().longValue());
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setOwnerName(BlogUtils.getUserFullName(record.getOwnerId()));
            rd.setTitle(record.getTitle());
            rd.setNote(record.getNote());
            rd.setBlogId(record.getEipTBlog().getBlogId().longValue());
            rd.setThemaId(record.getEipTBlogThema().getThemaId().intValue());
            rd.setThemaName(record.getEipTBlogThema().getThemaName());
            rd.setAllowComments("T".equals(record.getAllowComments()));
            rd.setCreateDate(sdf.format(record.getCreateDate()));
            rd.setUpdateDate(record.getUpdateDate());
            this.commentList = new ArrayList();
            SelectQuery query = new SelectQuery(EipTBlogComment.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)record.getEntryId());
            query.setQualifier(exp);
            List comments = this.dataContext.performQuery((Query)query);
            if (comments != null && comments.size() > 0) {
                int size = comments.size();
                for (int i = 0; i < size; ++i) {
                    EipTBlogComment blogcomment = (EipTBlogComment)comments.get(i);
                    BlogCommentResultData comment = new BlogCommentResultData();
                    comment.initField();
                    comment.setCommentId(blogcomment.getCommentId().longValue());
                    comment.setOwnerId(blogcomment.getOwnerId().longValue());
                    comment.setOwnerName(BlogUtils.getUserFullName(blogcomment.getOwnerId()));
                    comment.setComment(blogcomment.getComment());
                    comment.setEntryId(blogcomment.getEipTBlogEntry().getEntryId().longValue());
                    comment.setUpdateDate(sdf.format(blogcomment.getUpdateDate()));
                    WhatsNewUtils.shiftWhatsNewReadFlag((int)2, (int)((int)comment.getCommentId().getValue()), (int)this.uid);
                    this.commentList.add(comment);
                }
            }
            SelectQuery filequery = new SelectQuery(EipTBlogFile.class);
            Expression fileexp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)record.getEntryId());
            filequery.setQualifier(fileexp);
            List files = this.dataContext.performQuery((Query)filequery);
            if (files != null && files.size() > 0) {
                ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
                FileuploadBean filebean = null;
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    EipTBlogFile file = (EipTBlogFile)files.get(i);
                    String realname = file.getTitle();
                    DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                    filebean = new FileuploadBean();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(realname);
                    if (hData != null) {
                        filebean.setContentType(hData.getContentType());
                    }
                    filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                    attachmentFileList.add(filebean);
                }
                rd.setAttachmentFiles(attachmentFileList);
            }
            if (record.getOwnerId() == this.uid) {
                record.setUpdateDate(Calendar.getInstance().getTime());
                this.dataContext.commitChanges();
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public ArrayList getThemaList() {
        return this.themaList;
    }

    public int getLoginUid() {
        return this.uid;
    }

    public int getViewUid() {
        return this.view_uid;
    }

    public String getViewUname() {
        return this.view_uname;
    }

    public int getEntrySum() {
        return this.entrySum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("thema", "THEMA_ID");
        return map;
    }

    public List getCommentList() {
        return this.commentList;
    }

    public List getFootmarkList() {
        return this.footmarkList;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public Month getMonth() {
        return this.month;
    }

    public ALDateTimeField getViewMonth() {
        return this.viewMonth;
    }

    public ALDateTimeField getPrevMonth() {
        return this.prevMonth;
    }

    public ALDateTimeField getNextMonth() {
        return this.nextMonth;
    }

    public int getUserId() {
        return this.uid;
    }

    public boolean hasPhoto() {
        return this.has_photo;
    }

    public String getUserAccountURI() {
        return this.userAccountURI;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

