/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.eip.blog.BlogEntryResultData;
import com.aimluck.eip.blog.BlogFileResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import javax.imageio.ImageIO;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntryLatestSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntryLatestSelectData.class.getName());
    private int entrySum;
    private List photoList;
    private int uid;
    private int newEntryId;
    private List commentHistoryList;
    private final int DELETE_DATE = 7;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        super.init(action, rundata, context);
    }

    private void loadPhotos() throws Exception {
        this.photoList = new ArrayList();
        String[] ext = ImageIO.getWriterFormatNames();
        SelectQuery query = new SelectQuery(EipTBlogFile.class);
        Expression exp01 = ExpressionFactory.likeExp((String)"title", (Object)("%" + ext[0]));
        query.setQualifier(exp01);
        for (int i = 1; i < ext.length; ++i) {
            Expression exp02 = ExpressionFactory.likeExp((String)"title", (Object)("%" + ext[i]));
            query.orQualifier(exp02);
        }
        query.addOrdering("updateDate", false);
        query.setFetchLimit(5);
        List list = this.dataContext.performQuery((Query)query);
        if (list != null && list.size() > 0) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTBlogFile record = (EipTBlogFile)list.get(i);
                BlogFileResultData file = new BlogFileResultData();
                file.initField();
                file.setFileId(record.getFileId().longValue());
                file.setOwnerId(record.getOwnerId().longValue());
                file.setEntryId(record.getEipTBlogEntry().getEntryId().longValue());
                file.setEntryTitle(record.getEipTBlogEntry().getTitle());
                this.photoList.add(file);
            }
        }
    }

    private void loadCommentHistoryList(RunData rundata) throws Exception {
        this.commentHistoryList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09");
        Integer thisUserId = this.uid;
        Integer beforeEntryId = null;
        SelectQuery comment_query = new SelectQuery(EipTBlogComment.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)thisUserId);
        comment_query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.greaterExp((String)"updateDate", (Object)this.reduceDate(Calendar.getInstance().getTime(), 7));
        comment_query.andQualifier(exp2);
        comment_query.addOrdering("eipTBlogEntry", true);
        List aList = this.dataContext.performQuery((Query)comment_query);
        int size = aList.size();
        for (int i = 0; i < size; ++i) {
            EipTBlogComment record = (EipTBlogComment)aList.get(i);
            EipTBlogEntry entry = record.getEipTBlogEntry();
            if (entry.getOwnerId().equals(thisUserId) || entry.getEntryId().equals(beforeEntryId)) continue;
            beforeEntryId = entry.getEntryId();
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(entry.getEntryId().longValue());
            rd.setOwnerId(entry.getOwnerId().longValue());
            rd.setOwnerName(BlogUtils.getUserFullName(entry.getOwnerId()));
            rd.setTitle(ALCommonUtils.compressString((String)entry.getTitle(), (int)this.getStrLength()));
            rd.setTitleDate(sdf.format(record.getUpdateDate()));
            SelectQuery cquery = new SelectQuery(EipTBlogComment.class);
            cquery.addCustomDbAttribute("COMMENT_ID");
            Expression cexp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)entry.getEntryId());
            cquery.setQualifier(cexp);
            List list = this.dataContext.performQuery((Query)cquery);
            if (list != null && list.size() > 0) {
                rd.setCommentsNum(list.size());
            }
            this.commentHistoryList.add(rd);
        }
        Collections.sort(this.commentHistoryList, BlogEntryLatestSelectData.getDateComparator());
    }

    public List selectList(RunData rundata, Context context) {
        try {
            this.loadPhotos();
            this.loadCommentHistoryList(rundata);
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            query.addOrdering("createDate", false);
            List list = this.dataContext.performQuery((Query)query);
            this.entrySum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTBlogEntry.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            EipTBlogEntry record = (EipTBlogEntry)obj;
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(record.getEntryId().longValue());
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setOwnerName(BlogUtils.getUserFullName(record.getOwnerId()));
            rd.setTitle(record.getTitle());
            rd.setBlogId(record.getEipTBlog().getBlogId().intValue());
            rd.setThemaId(record.getEipTBlogThema().getThemaId().intValue());
            rd.setThemaName(record.getEipTBlogThema().getThemaName());
            rd.setAllowComments("T".equals(record.getAllowComments()));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09");
            rd.setTitleDate(sdf.format(record.getCreateDate()));
            List list = record.getEipTBlogComments();
            if (list != null && list.size() > 0) {
                rd.setCommentsNum(list.size());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    public List getPhotoList() {
        return this.photoList;
    }

    public int getLoginUid() {
        return this.uid;
    }

    public int getEntrySum() {
        return this.entrySum;
    }

    public int getNewEntryId() {
        return this.newEntryId;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("update", "updateDate");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List getCommentHistoryList() {
        return this.commentHistoryList;
    }

    public static Comparator getDateComparator() {
        Comparator com = null;
        com = new Comparator(){

            public int compare(Object obj0, Object obj1) {
                String date1;
                String date0 = ((BlogEntryResultData)obj0).getTitleDate().toString();
                if (date0.compareTo(date1 = ((BlogEntryResultData)obj1).getTitleDate().toString()) < 0) {
                    return 1;
                }
                if (date0.equals(date1)) {
                    return 0;
                }
                return -1;
            }
        };
        return com;
    }

    public Date reduceDate(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -day);
        return cal.getTime();
    }

    public String getAclPortletFeature() {
        return "blog_entry_other";
    }
}

