/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.BlogThemaFormData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntryFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntryFormData.class.getName());
    private ALStringField title;
    private ALStringField note;
    private ALNumberField blog_id;
    private ALNumberField thema_id;
    private ALStringField allow_comments;
    private ArrayList themaList;
    private boolean is_new_thema;
    private FileuploadLiteBean filebean = null;
    private List fileuploadList = null;
    private String folderName = null;
    private int uid;
    private String user_name;
    private boolean has_photo;
    private EipTBlog blog;
    private EipTBlogThema thema;
    private BlogThemaFormData blogthema;
    private String org_id;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_thema = rundata.getParameters().getBoolean("is_new_thema");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.folderName = rundata.getParameters().getString("folderName");
        ALBaseUser user = BlogUtils.getBaseUser(this.uid);
        this.user_name = user.getLastName() + " " + user.getFirstName();
        this.has_photo = user.getPhoto() != null;
    }

    public void initField() {
        this.title = new ALStringField();
        this.title.setFieldName("\u30bf\u30a4\u30c8\u30eb");
        this.title.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u8a18\u4e8b");
        this.note.setTrim(false);
        this.blog_id = new ALNumberField();
        this.blog_id.setFieldName("\u30d6\u30ed\u30b0");
        this.thema_id = new ALNumberField();
        this.thema_id.setFieldName("\u30c6\u30fc\u30de");
        this.allow_comments = new ALStringField();
        this.allow_comments.setFieldName("\u30b3\u30e1\u30f3\u30c8\u4ed8\u52a0\u30d5\u30e9\u30b0");
        this.allow_comments.setValue("T");
        this.allow_comments.setTrim(true);
        this.fileuploadList = new ArrayList();
        this.blogthema = new BlogThemaFormData();
        this.blogthema.initField();
    }

    public void loadThemaList(RunData rundata, Context context) {
        this.themaList = BlogUtils.getThemaList(rundata, context);
    }

    protected void setValidator() {
        this.title.setNotNull(true);
        this.title.limitMaxLength(50);
        this.note.limitMaxLength(10000);
        this.blogthema.setValidator();
    }

    protected boolean validate(ArrayList msgList) {
        this.title.validate(msgList);
        this.note.validate(msgList);
        if (this.is_new_thema) {
            this.blogthema.setMode("insert");
            this.blogthema.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTBlogEntry entry = BlogUtils.getEipTBlogEntry(rundata, context);
            if (entry == null) {
                return false;
            }
            this.title.setValue(entry.getTitle());
            this.note.setValue(entry.getNote());
            this.thema_id.setValue(entry.getEipTBlogThema().getThemaId().longValue());
            this.allow_comments.setValue(entry.getAllowComments());
            SelectQuery filequery = new SelectQuery(EipTBlogFile.class);
            Expression fileexp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)entry.getEntryId());
            filequery.setQualifier(fileexp);
            List files = this.dataContext.performQuery((Query)filequery);
            FileuploadLiteBean filebean = null;
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                EipTBlogFile file = (EipTBlogFile)files.get(i);
                filebean = new FileuploadLiteBean();
                filebean.initField();
                filebean.setFolderName("DBF" + Integer.toString(file.getFileId()));
                filebean.setFileName(file.getTitle());
                filebean.setFileId(file.getFileId().intValue());
                this.fileuploadList.add(filebean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTBlogEntry entry = BlogUtils.getEipTBlogEntry(rundata, context);
            if (entry == null) {
                return false;
            }
            int entityId = entry.getEntryId();
            String todoName = entry.getTitle();
            ArrayList<String> fpaths = new ArrayList<String>();
            List files = entry.getEipTBlogFiles();
            if (files != null && files.size() > 0) {
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    fpaths.add(((EipTBlogFile)files.get(i)).getFilePath());
                }
            }
            this.dataContext.deleteObject((Persistent)entry);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 110, todoName);
            if (fpaths.size() > 0) {
                File file = null;
                int fsize = fpaths.size();
                for (int i = 0; i < fsize; ++i) {
                    file = new File(BlogUtils.getSaveDirPath(this.org_id, this.uid) + (String)fpaths.get(i));
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = true;
        try {
            if (this.is_new_thema && (res = this.blogthema.insertFormData(rundata, context, msgList))) {
                this.thema_id.setValue((long)this.blogthema.getThemaId());
            }
            if (res) {
                this.thema = (EipTBlogThema)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipTBlogThema.class, (Object)((int)this.thema_id.getValue()));
                this.blog = BlogUtils.getEipTBlog(rundata, context);
                if (this.blog == null) {
                    if (!this.insertBlogData(rundata, context)) {
                        // empty if block
                    }
                } else {
                    this.blog_id.setValue(this.blog.getBlogId().longValue());
                }
                EipTBlogEntry entry = (EipTBlogEntry)this.dataContext.createAndRegisterNewObject(EipTBlogEntry.class);
                entry.setOwnerId(Integer.valueOf(this.uid));
                entry.setTitle(this.title.getValue());
                entry.setNote(this.note.getValue());
                entry.setEipTBlog(this.blog);
                entry.setEipTBlogThema(this.thema);
                entry.setAllowComments("T");
                entry.setCreateDate(Calendar.getInstance().getTime());
                entry.setUpdateDate(Calendar.getInstance().getTime());
                this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, entry, msgList);
                this.dataContext.commitChanges();
                ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
                ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
                List userIds = aclhandler.getAcceptUserIdsExceptLoginUser(this.dataContext, this.uid, "blog_entry_other", 2);
                if (userIds != null) {
                    int size = userIds.size();
                    for (int i = 0; i < size; ++i) {
                        Integer userId = (Integer)userIds.get(i);
                        WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)1, (int)entry.getEntryId(), (int)userId);
                    }
                }
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.blog.getBlogId().intValue(), 110, this.title.getValue());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    private List getRequestedHasFileIdList(List attachmentFileNameList) {
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        FileuploadLiteBean filebean = null;
        if (attachmentFileNameList != null) {
            int size = attachmentFileNameList.size();
            for (int i = 0; i < size; ++i) {
                filebean = (FileuploadLiteBean)attachmentFileNameList.get(i);
                if (filebean.isNewFile()) continue;
                int index = filebean.getFileId();
                idlist.add(index);
            }
        }
        return idlist;
    }

    private List getRequestedFileIdList(List attachmentFileNameList) {
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        FileuploadLiteBean filebean = null;
        if (attachmentFileNameList != null) {
            int size = attachmentFileNameList.size();
            for (int i = 0; i < size; ++i) {
                filebean = (FileuploadLiteBean)attachmentFileNameList.get(i);
                String foldername = filebean.getFolderName();
                if (foldername == null || !foldername.startsWith("DBF")) continue;
                String index = foldername.substring("DBF".length(), foldername.length());
                idlist.add(Integer.valueOf(index));
            }
        }
        return idlist;
    }

    private boolean insertAttachmentFiles(List fileuploadList, String folderName, int uid, EipTBlogEntry entry, ArrayList msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            int length = fileuploadList.size();
            ArrayList<FileuploadLiteBean> newfilebeans = new ArrayList<FileuploadLiteBean>();
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < length; ++i) {
                filebean = (FileuploadLiteBean)fileuploadList.get(i);
                if (!filebean.isNewFile()) continue;
                newfilebeans.add(filebean);
            }
            int newfilebeansSize = newfilebeans.size();
            if (newfilebeansSize > 0) {
                FileuploadLiteBean newfilebean = null;
                for (int j = 0; j < length; ++j) {
                    newfilebean = (FileuploadLiteBean)newfilebeans.get(j);
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    byte[] fileThumbnail = FileuploadUtils.getBytesShrinkFilebean((String)this.org_id, (String)folderName, (int)uid, (FileuploadLiteBean)newfilebean, (String[])acceptExts, (int)86, (int)86, (ArrayList)msgList);
                    String filename = FileuploadUtils.getNewFileName((String)BlogUtils.getSaveDirPath(this.org_id, uid));
                    EipTBlogFile file = (EipTBlogFile)this.dataContext.createAndRegisterNewObject(EipTBlogFile.class);
                    file.setOwnerId(Integer.valueOf(uid));
                    file.setTitle(newfilebean.getFileName());
                    file.setFilePath(BlogUtils.getRelativePath(filename));
                    if (fileThumbnail != null) {
                        file.setFileThumbnail(fileThumbnail);
                    }
                    file.setEipTBlogEntry(entry);
                    file.setCreateDate(Calendar.getInstance().getTime());
                    file.setUpdateDate(Calendar.getInstance().getTime());
                    File srcFile = FileuploadUtils.getAbsolutePath((String)this.org_id, (int)uid, (String)folderName, (int)newfilebean.getFileId());
                    File destFile = new File(BlogUtils.getAbsolutePath(this.org_id, uid, filename));
                    FileuploadUtils.copyFile((File)srcFile, (File)destFile);
                    srcFile = null;
                    destFile = null;
                }
                File folder = FileuploadUtils.getFolder((String)this.org_id, (int)uid, (String)folderName);
                FileuploadUtils.deleteFolder((File)folder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean insertBlogData(RunData rundata, Context context) {
        try {
            this.blog = (EipTBlog)this.dataContext.createAndRegisterNewObject(EipTBlog.class);
            this.blog.setOwnerId(Integer.valueOf(this.uid));
            this.blog.setCreateDate(Calendar.getInstance().getTime());
            this.blog.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            this.blog_id.setValue(this.blog.getBlogId().longValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = false;
        try {
            EipTBlogEntry entry = BlogUtils.getEipTBlogEntry(rundata, context);
            if (entry == null) {
                return false;
            }
            if (this.is_new_thema) {
                res = this.blogthema.insertFormData(rundata, context, msgList);
                if (res) {
                    this.thema_id.setValue(this.thema.getThemaId().longValue());
                }
            } else {
                this.thema = (EipTBlogThema)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipTBlogThema.class, (Object)((int)this.thema_id.getValue()));
                res = true;
            }
            if (res) {
                entry.setTitle(this.title.getValue());
                entry.setNote(this.note.getValue());
                entry.setEipTBlogThema(this.thema);
                entry.setOwnerId(Integer.valueOf(this.uid));
                entry.setAllowComments("T");
                entry.setUpdateDate(Calendar.getInstance().getTime());
                List attIdList = this.getRequestedHasFileIdList(this.fileuploadList);
                List files = BlogUtils.getEipTBlogFileList(entry.getEntryId());
                if (files != null) {
                    int size = files.size();
                    for (int i = 0; i < size; ++i) {
                        EipTBlogFile file = (EipTBlogFile)files.get(i);
                        if (attIdList.contains(file.getFileId())) continue;
                        File fileonsysytem = new File(BlogUtils.getSaveDirPath(this.org_id, this.uid) + file.getFilePath());
                        if (fileonsysytem.exists()) {
                            fileonsysytem.delete();
                        }
                        this.dataContext.deleteObject((Persistent)file);
                    }
                }
                this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, entry, msgList);
                this.dataContext.commitChanges();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entry.getEntryId().intValue(), 110, this.title.getValue());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                this.blogthema.setFormData(rundata, context, msgList);
                this.fileuploadList = BlogUtils.getFileuploadList(rundata);
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return res;
    }

    public boolean doDeleteAttachments(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            action.setMode("delete");
            ArrayList msgList = new ArrayList();
            this.setValidator();
            boolean res = this.setFormData(rundata, context, msgList) && this.deleteAttachments(rundata, context, msgList);
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean deleteAttachments(RunData rundata, Context context, ArrayList msgList) {
        if (rundata == null || context == null) {
            msgList.add("\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306e\u305f\u3081\u3001\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return false;
        }
        return FileuploadUtils.deleteAttachments((String)this.org_id, (int)this.uid, (String)this.folderName, (List)this.fileuploadList);
    }

    public ALNumberField getThemaId() {
        return this.thema_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getTitle() {
        return this.title;
    }

    public ArrayList getThemaList() {
        return this.themaList;
    }

    public boolean isNewThema() {
        return this.is_new_thema;
    }

    public BlogThemaFormData getBlogThema() {
        return this.blogthema;
    }

    public List getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public int getUserId() {
        return this.uid;
    }

    public String getUserName() {
        return this.user_name;
    }

    public boolean hasPhoto() {
        return this.has_photo;
    }

    public String getAclPortletFeature() {
        return "blog_entry_self";
    }
}

