/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.blog.BlogAction;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.BlogDetailScreen;
import com.aimluck.eip.modules.screens.BlogEntryFormJSONScreen;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntryCommentFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntryCommentFormData.class.getName());
    private ALStringField comment;
    private DataContext dataContext;
    private boolean sendEmailToPC = false;
    private ALEipUser login_user;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.sendEmailToPC = "true".equals(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-email"));
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
    }

    public void initField() {
        this.comment = new ALStringField();
        this.comment.setFieldName("\u30b3\u30e1\u30f3\u30c8");
        this.comment.setTrim(false);
    }

    protected void setValidator() {
        this.comment.setNotNull(true);
        this.comment.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) {
        this.comment.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            String commentid = rundata.getParameters().getString("comment_id");
            EipTBlogComment comment = BlogUtils.getEipTBlogComment(rundata, context, commentid);
            if (comment == null) {
                logger.debug((Object)"[BlogEntryCommentFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            this.dataContext.deleteObject((Persistent)comment);
            this.dataContext.commitChanges();
        }
        catch (Exception e) {
            logger.error((Object)"[BlogEntryCommentFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTBlogEntry parententry = BlogUtils.getEipTBlogParentEntry(rundata, context);
            if (parententry == null) {
                logger.debug((Object)"[BlogEntryCommentFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            int uid = ALEipUtils.getUserId((RunData)rundata);
            Date updateDate = Calendar.getInstance().getTime();
            EipTBlogEntry entry = (EipTBlogEntry)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipTBlogEntry.class, (Object)parententry.getEntryId());
            EipTBlogComment blogcomment = (EipTBlogComment)this.dataContext.createAndRegisterNewObject(EipTBlogComment.class);
            blogcomment.setOwnerId(Integer.valueOf(uid));
            blogcomment.setComment(this.comment.getValue());
            blogcomment.setEipTBlogEntry(entry);
            blogcomment.setCreateDate(Calendar.getInstance().getTime());
            blogcomment.setUpdateDate(updateDate);
            this.dataContext.commitChanges();
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(entry.getOwnerId().intValue(), "blog_entry_self", 2)) {
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)2, (int)blogcomment.getCommentId(), (int)entry.getOwnerId());
            }
            if (this.sendEmailToPC) {
                ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
                memberList.add(ALEipUtils.getALEipUser((int)entry.getOwnerId()));
                List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
                String subject = "[Aipo]\u30d6\u30ed\u30b0\u30b3\u30e1\u30f3\u30c8";
                String body = this.createMsgForPc(rundata);
                ALMailUtils.sendMailDelegate((String)org_id, (int)((int)this.login_user.getUserId().getValue()), (List)destMemberList, (String)subject, (String)subject, (String)body, (String)body, (int)ALMailUtils.getSendDestType((int)22), (ArrayList)msgList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[BlogEntryCommentFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    private String createMsgForPc(RunData rundata) {
        String CR = System.getProperty("line.separator");
        ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
        StringBuffer body = new StringBuffer();
        ALBaseUser user2 = null;
        try {
            user2 = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(user.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        String username = new StringBuffer().append(user2.getLastName()).append(" ").append(user2.getFirstName()).toString();
        body.append(username);
        String e_mail_addr = user2.getEmail();
        if (!e_mail_addr.equals("")) {
            body.append("(").append(e_mail_addr).append(")");
        }
        body.append("\u3055\u3093\u304b\u3089\u65e5\u8a18\u306b\u30b3\u30e1\u30f3\u30c8\u304c\u3064\u304d\u307e\u3057\u305f\u3002");
        body.append(CR).append(CR);
        body.append("[\u30b3\u30e1\u30f3\u30c8]").append(CR).append(this.comment.getValue()).append(CR);
        body.append(CR);
        body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        body.append("\u30fb\u793e\u5916").append(CR);
        body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
        body.append("\u30fb\u793e\u5185").append(CR);
        body.append("\u3000").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
        body.append("---------------------").append(CR);
        body.append("Aipo").append(CR);
        return body.toString();
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        try {
            boolean res;
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 4);
            action.setMode("insert");
            ArrayList msgList = new ArrayList();
            this.setValidator();
            boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList) && this.insertFormData(rundata, context, msgList);
            if (!res) {
                action.setMode("new_form");
                this.setMode(action.getMode());
            }
            if (action instanceof BlogEntryFormJSONScreen) {
                action.setResultData((Object)this);
                action.addErrorMessages(msgList);
                action.putData(rundata, context);
            } else {
                BlogAction blogAction = (BlogAction)action;
                blogAction.setResultDataOnCommentDetail((Object)this);
                blogAction.addErrorMessagesOnCommentDetail(msgList);
                blogAction.putDataOnCommentDetail(rundata, context);
            }
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            ArrayList msgList = new ArrayList();
            boolean res = this.setFormData(rundata, context, msgList);
            if (action instanceof BlogDetailScreen) {
                BlogDetailScreen blogAction = (BlogDetailScreen)action;
                blogAction.setResultDataOnCommentDetail((Object)this);
                blogAction.addErrorMessagesOnCommentDetail(msgList);
                blogAction.putDataOnCommentDetail(rundata, context);
            } else {
                BlogAction blogAction = (BlogAction)action;
                blogAction.setResultDataOnCommentDetail((Object)this);
                blogAction.addErrorMessagesOnCommentDetail(msgList);
                blogAction.putDataOnCommentDetail(rundata, context);
            }
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        return res;
    }

    public ALStringField getComment() {
        return this.comment;
    }

    public String getAclPortletFeature() {
        return "blog_entry_reply";
    }
}

