/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.blog.BlogEntryResultData;
import com.aimluck.eip.blog.BlogThemaResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogCommonThemaSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogCommonThemaSelectData.class.getName());
    private DataContext dataContext;
    private int loginuser_id = 0;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.loginuser_id = ALEipUtils.getUserId((RunData)rundata);
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List aList = this.dataContext.performQuery((Query)query);
            List list = this.buildPaginatedList(aList);
            if (list != null && list.size() > 0) {
                EipTBlogThema[] themas = new EipTBlogThema[list.size()];
                themas = list.toArray(themas);
                Comparator comp = BlogCommonThemaSelectData.getCommonThemaComparator();
                if (comp != null) {
                    Arrays.sort(themas, comp);
                }
                list.clear();
                int size = themas.length;
                for (int i = 0; i < size; ++i) {
                    list.add(themas[i]);
                }
            }
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static Comparator getCommonThemaComparator() {
        Comparator com = null;
        com = new Comparator(){

            public int compare(Object obj0, Object obj1) {
                int ret = 0;
                try {
                    int themaSize0 = ((EipTBlogThema)obj0).getEipTBlogEntrys().size();
                    int themaSize1 = ((EipTBlogThema)obj1).getEipTBlogEntrys().size();
                    ret = themaSize1 - themaSize0;
                }
                catch (Exception e) {
                    ret = -1;
                }
                return ret;
            }
        };
        return com;
    }

    public static Comparator getCommonEntryComparator() {
        Comparator com = null;
        com = new Comparator(){

            public int compare(Object obj0, Object obj1) {
                int ret = 0;
                try {
                    Date createDate0 = ((EipTBlogEntry)obj0).getCreateDate();
                    Date createDate1 = ((EipTBlogEntry)obj1).getCreateDate();
                    ret = createDate1.after(createDate0) ? 1 : (createDate1.before(createDate0) ? -1 : 0);
                }
                catch (Exception e) {
                    ret = -1;
                }
                return ret;
            }
        };
        return com;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTBlogThema.class);
        query.addPrefetch("eipTBlogEntrys");
        return query;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return BlogUtils.getEipTBlogThema(rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            EipTBlogThema record = (EipTBlogThema)obj;
            BlogThemaResultData rd = new BlogThemaResultData();
            rd.initField();
            rd.setThemaId(record.getThemaId().longValue());
            rd.setThemaName(record.getThemaName());
            rd.setDescription(record.getDescription());
            rd.setEntryNum(record.getEipTBlogEntrys().size());
            return rd;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            EipTBlogThema record = (EipTBlogThema)obj;
            BlogThemaResultData rd = new BlogThemaResultData();
            rd.initField();
            rd.setThemaId(record.getThemaId().longValue());
            rd.setThemaName(record.getThemaName());
            rd.setDescription(record.getDescription());
            ArrayList<BlogEntryResultData> entryList = new ArrayList<BlogEntryResultData>();
            EipTBlogEntry entry2 = null;
            BlogEntryResultData entryrd = null;
            List list = record.getEipTBlogEntrys();
            EipTBlogEntry[] entrys = new EipTBlogEntry[list.size()];
            entrys = list.toArray(entrys);
            Comparator comp = BlogCommonThemaSelectData.getCommonEntryComparator();
            if (comp != null) {
                Arrays.sort(entrys, comp);
            }
            for (EipTBlogEntry entry2 : entrys) {
                entryrd = new BlogEntryResultData();
                entryrd.initField();
                entryrd.setEntryId(entry2.getEntryId().longValue());
                entryrd.setTitle(entry2.getTitle());
                entryrd.setNote(BlogUtils.compressString(entry2.getNote(), 100));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EE\uff09");
                entryrd.setTitleDate(sdf.format(entry2.getCreateDate()));
                entryrd.setOwnerId(entry2.getOwnerId().intValue());
                entryrd.setOwnerName(BlogUtils.getUserFullName(entry2.getOwnerId()));
                List comments = entry2.getEipTBlogComments();
                if (comments != null) {
                    entryrd.setCommentsNum(comments.size());
                }
                entryList.add(entryrd);
            }
            if (entryList.size() > 0) {
                rd.setEntryList(entryList);
            }
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("thema_name", "themaName");
        return map;
    }

    public int getLoginUserId() {
        return this.loginuser_id;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getAclPortletFeature() {
        return "blog_theme";
    }
}

