/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whatsnew.util;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTWhatsNew;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.WhatsNewContainer;
import com.aimluck.eip.whatsnew.WhatsNewResultData;
import com.aimluck.eip.whatsnew.beans.WhatsNewBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class WhatsNewUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhatsNewUtils.class.getName());
    public static final int WHATS_NEW_TYPE_BLOG_ENTRY = 1;
    public static final int WHATS_NEW_TYPE_BLOG_COMMENT = 2;
    public static final int WHATS_NEW_TYPE_WORKFLOW_REQUEST = 3;
    public static final int WHATS_NEW_TYPE_MSGBOARD_TOPIC = 4;
    public static final int WHATS_NEW_TYPE_NOTE = 5;
    public static final int WHATS_NEW_TYPE_SCHEDULE = 6;

    public static void insertWhatsNew(DataContext dataContext, int type, int entityid, int uid) {
        EipTWhatsNew entry = null;
        SelectQuery query = null;
        Object sb = null;
        try {
            query = new SelectQuery(EipTWhatsNew.class);
            Expression exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
            query.setQualifier(exp);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
            query.andQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"entityId", (Object)entityid);
            query.andQualifier(exp2);
            List entries = dataContext.performQuery((Query)query);
            if (entries == null || entries.size() < 1) {
                entry = (EipTWhatsNew)dataContext.createAndRegisterNewObject(EipTWhatsNew.class);
                entry.setCreateDate(Calendar.getInstance().getTime());
                entry.setEntityId(Integer.valueOf(entityid));
                entry.setPortletType(Integer.valueOf(type));
            } else {
                entry = (EipTWhatsNew)entries.get(0);
            }
            entry.setUpdateDate(Calendar.getInstance().getTime());
            entry.setUserId(Integer.valueOf(uid));
            dataContext.commitChanges();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void shiftWhatsNewReadFlag(int type, int entityid, int uid) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = null;
        Object sb = null;
        query = new SelectQuery(EipTWhatsNew.class);
        Expression exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
        query.setQualifier(exp);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
        query.andQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"entityId", (Object)entityid);
        query.andQualifier(exp2);
        List entries = dataContext.performQuery((Query)query);
        if (entries != null && entries.size() > 0) {
            dataContext.deleteObjects((Collection)entries);
        }
        dataContext.commitChanges();
    }

    public static WhatsNewResultData setupWhatsNewResultData(WhatsNewContainer record, int uid, int num, int span) {
        EipTBlogComment entry;
        DataRow dataRow;
        List entries;
        Expression exp;
        SelectQuery query;
        WhatsNewResultData rd = new WhatsNewResultData();
        rd.initField();
        int size = 0;
        int type = record.getType();
        Object[] eids = null;
        Object[] deids = null;
        Date[] dates = null;
        List entity_ids = record.getList();
        if (entity_ids != null && (size = entity_ids.size()) > 0) {
            if (size > num) {
                eids = new Integer[num];
                dates = new Date[num];
                deids = new Integer[size - num];
            } else {
                eids = new Integer[size];
                dates = new Date[size];
            }
            for (int i = 0; i < size; ++i) {
                try {
                    EipTWhatsNew wn = (EipTWhatsNew)entity_ids.get(i);
                    if (i < num) {
                        eids[i] = wn.getEntityId();
                        dates[i] = wn.getUpdateDate();
                        continue;
                    }
                    deids[i - num] = wn.getEntityId();
                    continue;
                }
                catch (Exception e) {
                    return null;
                }
            }
        } else {
            return null;
        }
        rd.setType(type);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        if (deids != null) {
            query = new SelectQuery(EipTWhatsNew.class);
            exp = ExpressionFactory.matchExp((String)"portletType", (Object)type);
            query.setQualifier(exp);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
            query.andQualifier(exp1);
            Expression exp2 = ExpressionFactory.inExp((String)"entityId", (Object[])deids);
            query.andQualifier(exp2);
            List entries2 = dataContext.performQuery((Query)query);
            if (entries2 != null && entries2.size() > 0) {
                dataContext.deleteObjects((Collection)entries2);
                dataContext.commitChanges();
            }
            query = null;
        }
        if (span > 0) {
            query = new SelectQuery(EipTWhatsNew.class);
            Calendar cal = Calendar.getInstance();
            if (span == 31) {
                cal.add(2, -1);
            } else {
                cal.add(5, -1 * span);
            }
            Expression exp3 = ExpressionFactory.lessExp((String)"updateDate", (Object)cal.getTime());
            query.setQualifier(exp3);
            List entries1 = dataContext.performQuery((Query)query);
            if (entries1 != null && entries1.size() > 0) {
                dataContext.deleteObjects((Collection)entries1);
                dataContext.commitChanges();
            }
            query = null;
        }
        if (1 == type) {
            exp = ExpressionFactory.inDbExp((String)"ENTRY_ID", (Object[])eids);
            query = new SelectQuery(EipTBlogEntry.class, exp);
            query.addOrdering("createDate", false);
            query.addCustomDbAttribute("ENTRY_ID");
            query.addCustomDbAttribute("TITLE");
            query.addCustomDbAttribute("OWNER_ID");
            entries = dataContext.performQuery((Query)query);
            if (entries == null || entries.size() <= 0) {
                return null;
            }
            size = entries.size();
            rd.setCreateDate(new Date());
            rd.setUpdateDate(new Date());
            rd.setPortletName("[ \u30d6\u30ed\u30b0 ]  \u65b0\u7740\u8a18\u4e8b");
            dataRow = null;
            for (int i = 0; i < size; ++i) {
                dataRow = (DataRow)entries.get(i);
                WhatsNewBean bean = new WhatsNewBean();
                bean.initField();
                bean.setEntityId((Integer)dataRow.get((Object)"ENTRY_ID"));
                bean.addParamMap("template", "BlogDetailScreen");
                bean.setJsFunctionName("aipo.blog.onLoadBlogDetailDialog");
                bean.setPortletName("[ \u30d6\u30ed\u30b0 ] ");
                try {
                    ALEipUser owner = ALEipUtils.getALEipUser((int)((Integer)dataRow.get((Object)"OWNER_ID")));
                    bean.setOwnerName(owner.getAliasName().getValue());
                }
                catch (Exception e) {
                    bean.setOwnerName("");
                }
                bean.setName((String)dataRow.get((Object)"TITLE"));
                bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                rd.setBean(bean);
            }
        } else if (2 == type) {
            exp = ExpressionFactory.inDbExp((String)"COMMENT_ID", (Object[])eids);
            query = new SelectQuery(EipTBlogComment.class, exp);
            query.addOrdering("createDate", false);
            entries = dataContext.performQuery((Query)query);
            if (entries == null || entries.size() <= 0) {
                return null;
            }
            size = entries.size();
            rd.setCreateDate(new Date());
            rd.setUpdateDate(new Date());
            rd.setPortletName("[ \u30d6\u30ed\u30b0 ]  \u65b0\u7740\u30b3\u30e1\u30f3\u30c8");
            for (int i = 0; i < size; ++i) {
                entry = (EipTBlogComment)entries.get(i);
                int entryId = entry.getEipTBlogEntry().getEntryId();
                int size2 = 0;
                ArrayList tmp = rd.getBeans();
                boolean is_contain = false;
                if (tmp != null && (size2 = tmp.size()) > 0) {
                    for (int j = 0; j < size2; ++j) {
                        WhatsNewBean tmpb = (WhatsNewBean)tmp.get(j);
                        if (tmpb.getEntityId().getValue() != (long)entryId) continue;
                        StringBuffer sb = new StringBuffer(tmpb.getOwnerName().getValue());
                        try {
                            List<String> array = Arrays.asList(sb.toString().split(","));
                            ALEipUser tmpowner = ALEipUtils.getALEipUser((int)entry.getOwnerId());
                            if (array.contains(tmpowner.getAliasName().getValue())) continue;
                            sb.append(",").append(tmpowner.getAliasName().getValue());
                            tmpb.setOwnerName(sb.toString());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        is_contain = true;
                        break;
                    }
                }
                if (is_contain) continue;
                WhatsNewBean bean = new WhatsNewBean();
                bean.initField();
                bean.setEntityId(entryId);
                bean.addParamMap("template", "BlogDetailScreen");
                bean.setJsFunctionName("aipo.blog.onLoadBlogDetailDialog");
                bean.setPortletName("[ \u30d6\u30ed\u30b0 ] ");
                try {
                    ALEipUser owner = ALEipUtils.getALEipUser((int)entry.getOwnerId());
                    bean.setOwnerName(owner.getAliasName().getValue());
                }
                catch (Exception e) {
                    bean.setOwnerName("");
                }
                bean.setName(entry.getEipTBlogEntry().getTitle());
                bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                rd.setBean(bean);
            }
        } else if (3 == type) {
            exp = ExpressionFactory.inDbExp((String)"REQUEST_ID", (Object[])eids);
            query = new SelectQuery(EipTWorkflowRequest.class, exp);
            query.addOrdering("updateDate", false);
            entries = dataContext.performQuery((Query)query);
            if (entries == null || entries.size() <= 0) {
                return null;
            }
            size = entries.size();
            rd.setCreateDate(new Date());
            rd.setUpdateDate(new Date());
            rd.setPortletName("[ \u30ef\u30fc\u30af\u30d5\u30ed\u30fc ]  \u65b0\u7740\u4f9d\u983c");
            for (int i = 0; i < size; ++i) {
                entry = (EipTWorkflowRequest)entries.get(i);
                WhatsNewBean bean = new WhatsNewBean();
                bean.initField();
                bean.setEntityId(entry.getRequestId());
                bean.addParamMap("template", "WorkflowDetailScreen");
                bean.setJsFunctionName("aipo.workflow.onLoadWorkflowDetail");
                bean.setPortletName("[ \u30ef\u30fc\u30af\u30d5\u30ed\u30fc ] ");
                try {
                    EipTWorkflowRequestMap map;
                    List maps = WhatsNewUtils.getEipTWorkflowRequestMap((EipTWorkflowRequest)entry);
                    int m_size = maps.size();
                    String lastUpdateUser = "";
                    int order = 0;
                    if ("A".equals(entry.getProgress())) {
                        map = (EipTWorkflowRequestMap)maps.get(m_size - 1);
                        ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                        lastUpdateUser = user.getAliasName().getValue();
                        order = map.getOrderIndex();
                    } else {
                        int unum = 0;
                        for (int j = 0; j < m_size; ++j) {
                            map = (EipTWorkflowRequestMap)maps.get(j);
                            if ("C".equals(map.getStatus())) {
                                unum = j - 1;
                                continue;
                            }
                            if (!"D".equals(map.getStatus())) continue;
                            unum = j;
                            break;
                        }
                        map = (EipTWorkflowRequestMap)maps.get(unum);
                        ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                        lastUpdateUser = user.getAliasName().getValue();
                        order = map.getOrderIndex() - 1;
                    }
                    bean.setOwnerName(lastUpdateUser);
                }
                catch (Exception e) {
                    bean.setOwnerName("");
                }
                String cname = entry.getEipTWorkflowCategory().getCategoryName();
                String rname = entry.getRequestName();
                String title = "\u3010" + cname + "\u3011 " + rname;
                bean.setName(title);
                bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                bean.addParamMap("mode", "detail");
                bean.addParamMap("prvid", bean.getEntityId().toString());
                rd.setBean(bean);
            }
        } else if (4 == type) {
            exp = ExpressionFactory.inDbExp((String)"TOPIC_ID", (Object[])eids);
            query = new SelectQuery(EipTMsgboardTopic.class, exp);
            query.addOrdering("createDate", false);
            query.addCustomDbAttribute("TOPIC_ID");
            query.addCustomDbAttribute("TOPIC_NAME");
            query.addCustomDbAttribute("OWNER_ID");
            query.addCustomDbAttribute("PARENT_ID");
            entries = dataContext.performQuery((Query)query);
            if (entries == null || entries.size() <= 0) {
                return null;
            }
            size = entries.size();
            rd.setCreateDate(new Date());
            rd.setUpdateDate(new Date());
            rd.setPortletName("[ \u63b2\u793a\u677f ]  \u65b0\u3057\u3044\u66f8\u304d\u8fbc\u307f");
            dataRow = null;
            for (int i = 0; i < size; ++i) {
                dataRow = (DataRow)entries.get(i);
                WhatsNewBean bean = new WhatsNewBean();
                bean.initField();
                int parentId = (Integer)dataRow.get((Object)"PARENT_ID");
                if (parentId > 0) {
                    bean.setEntityId(parentId);
                } else {
                    bean.setEntityId((Integer)dataRow.get((Object)"TOPIC_ID"));
                }
                bean.addParamMap("template", "MsgboardTopicDetailScreen");
                bean.setJsFunctionName("aipo.msgboard.onLoadMsgboardDetail");
                bean.setPortletName("[ \u63b2\u793a\u677f ] ");
                try {
                    ALEipUser owner = ALEipUtils.getALEipUser((int)((Integer)dataRow.get((Object)"OWNER_ID")));
                    bean.setOwnerName(owner.getAliasName().getValue());
                }
                catch (Exception e) {
                    bean.setOwnerName("");
                }
                bean.setName((String)dataRow.get((Object)"TOPIC_NAME"));
                bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                rd.setBean(bean);
            }
        } else if (5 == type) {
            exp = ExpressionFactory.inDbExp((String)"NOTE_ID", (Object[])eids);
            query = new SelectQuery(EipTNote.class, exp);
            query.addOrdering("createDate", false);
            query.addCustomDbAttribute("NOTE_ID");
            query.addCustomDbAttribute("CLIENT_NAME");
            query.addCustomDbAttribute("SUBJECT_TYPE");
            query.addCustomDbAttribute("CUSTOM_SUBJECT");
            query.addCustomDbAttribute("OWNER_ID");
            entries = dataContext.performQuery((Query)query);
            if (entries == null || entries.size() <= 0) {
                return null;
            }
            size = entries.size();
            rd.setCreateDate(new Date());
            rd.setUpdateDate(new Date());
            rd.setPortletName("[ \u4f1d\u8a00\u30e1\u30e2 ]  \u65b0\u7740\u30e1\u30e2");
            for (int i = 0; i < size; ++i) {
                dataRow = (DataRow)entries.get(i);
                WhatsNewBean bean = new WhatsNewBean();
                bean.initField();
                bean.setEntityId((Integer)dataRow.get((Object)"NOTE_ID"));
                bean.addParamMap("template", "NoteDetailScreen");
                bean.setJsFunctionName("aipo.note.onLoadDetail");
                bean.setPortletName("[ \u4f1d\u8a00\u30e1\u30e2 ] ");
                try {
                    ALEipUser owner = ALEipUtils.getALEipUser((int)Integer.parseInt((String)dataRow.get((Object)"OWNER_ID")));
                    bean.setOwnerName(owner.getAliasName().getValue());
                }
                catch (Exception e) {
                    bean.setOwnerName("");
                }
                String clname = (String)dataRow.get((Object)"CLIENT_NAME");
                String subject = "";
                String stype = (String)dataRow.get((Object)"SUBJECT_TYPE");
                if ("0".equals(stype)) {
                    subject = (String)dataRow.get((Object)"CUSTOM_SUBJECT");
                } else if ("1".equals(stype)) {
                    subject = "\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059\u3002";
                } else if ("2".equals(stype)) {
                    subject = "\u6298\u8fd4\u3057\u304a\u96fb\u8a71\u304f\u3060\u3055\u3044\u3002";
                } else if ("3".equals(stype)) {
                    subject = "\u9023\u7d61\u304c\u3042\u3063\u305f\u3053\u3068\u3092\u304a\u4f1d\u3048\u304f\u3060\u3055\u3044\u3002";
                } else if ("4".equals(stype)) {
                    subject = "\u4f1d\u8a00\u3092\u304a\u9858\u3044\u3057\u307e\u3059\u3002";
                }
                String title = "\u3010" + clname + "\u3011 " + subject;
                bean.setName(title);
                bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                rd.setBean(bean);
            }
        } else if (6 == type) {
            exp = ExpressionFactory.inDbExp((String)"SCHEDULE_ID", (Object[])eids);
            query = new SelectQuery(EipTSchedule.class, exp);
            query.addOrdering("updateDate", false);
            query.addCustomDbAttribute("SCHEDULE_ID");
            query.addCustomDbAttribute("START_DATE");
            query.addCustomDbAttribute("NAME");
            query.addCustomDbAttribute("UPDATE_USER_ID");
            entries = dataContext.performQuery((Query)query);
            if (entries == null || entries.size() <= 0) {
                return null;
            }
            size = entries.size();
            rd.setCreateDate(new Date());
            rd.setUpdateDate(new Date());
            rd.setPortletName("[ \u30b9\u30b1\u30b8\u30e5\u30fc\u30eb ]  \u65b0\u7740\u4e88\u5b9a");
            dataRow = null;
            for (int i = 0; i < size; ++i) {
                dataRow = (DataRow)entries.get(i);
                WhatsNewBean bean = new WhatsNewBean();
                bean.initField();
                bean.setEntityId((Integer)dataRow.get((Object)"SCHEDULE_ID"));
                bean.addParamMap("template", "ScheduleDetailScreen");
                bean.setJsFunctionName("aipo.schedule.onLoadScheduleDetail");
                bean.setPortletName("[ \u30b9\u30b1\u30b8\u30e5\u30fc\u30eb ] ");
                try {
                    ALEipUser owner = ALEipUtils.getALEipUser((int)((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"UPDATE_USER_ID")));
                    bean.setOwnerName(owner.getAliasName().getValue());
                }
                catch (Exception e) {
                    bean.setOwnerName("");
                }
                bean.setName((String)dataRow.get((Object)"NAME"));
                bean.setUpdateDate(ALDateUtil.format((Date)dates[i], (String)"yyyy/MM/dd/"));
                bean.addParamMap("userid", Integer.toString(uid).trim());
                rd.setBean(bean);
            }
        } else {
            rd = null;
        }
        return rd;
    }

    private static List getEipTWorkflowRequestMap(EipTWorkflowRequest request) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTWorkflowRequestMap.class);
            Expression exp = ExpressionFactory.matchExp((String)"requestId", (Object)request.getRequestId());
            query.setQualifier(exp);
            query.addOrdering("orderIndex", true);
            List maps = dataContext.performQuery((Query)query);
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return maps;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }
}

