/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.page.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PageUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PageUtils.class.getName());

    public static Portlets getPortlets(RunData rundata, String portletId) {
        Portlets portletSet = null;
        Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
        if (portlets == null) {
            return null;
        }
        Portlets[] portletList = portlets.getPortletsArray();
        if (portletList == null) {
            return null;
        }
        int length = portletList.length;
        for (int i = 0; i < length; ++i) {
            if (!portletList[i].getId().equals(portletId)) continue;
            portletSet = portletList[i];
            break;
        }
        return portletSet;
    }

    public static boolean deletePages(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            if (values == null || values.size() <= 0) {
                return false;
            }
            String portletId = rundata.getParameters().getString("js_peid");
            String pageId = PageUtils.getPortletSetId(rundata, portletId);
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets p = null;
            ArrayList<Integer> deletedList = new ArrayList<Integer>();
            ArrayList list = new ArrayList(values);
            int valuesLength = values.size();
            int portletsLength = portlets.getPortletsCount();
            block2: for (int i = 0; i < portletsLength; ++i) {
                for (int j = 0; j < valuesLength; ++j) {
                    p = portlets.getPortlets(i);
                    if (p.getId().equals(pageId) || !p.getId().equals(list.get(j))) continue;
                    deletedList.add(i);
                    continue block2;
                }
            }
            int length = deletedList.size();
            Collections.sort(deletedList);
            for (int i = length - 1; i >= 0; --i) {
                portlets.removePortlets(((Integer)deletedList.get(i)).intValue());
            }
            PageUtils.doSave(rundata, context);
            PageUtils.updateLayoutPositions(portlets);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static void updateLayoutPositions(Portlets set) {
        if (set == null) {
            return;
        }
        ArrayList<Portlets> list = new ArrayList<Portlets>();
        for (int i = 0; i < set.getPortletsCount(); ++i) {
            Portlets pane = set.getPortlets(i);
            list.add(pane);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object pane1, Object pane2) {
                Long pos1 = ((Portlets)pane1).getLayout().getPosition();
                Long pos2 = ((Portlets)pane2).getLayout().getPosition();
                return pos1.compareTo(pos2);
            }
        });
        int position = 0;
        for (Portlets pane : list) {
            Layout layout = pane.getLayout();
            layout.setPosition((long)position++);
        }
    }

    public static void doSave(RunData rundata, Context context) throws Exception {
        Profile profile = ((JetspeedRunData)rundata).getProfile();
        try {
            String mtype = rundata.getParameters().getString("mtype");
            if (mtype != null) {
                profile.setMediaType(mtype);
            }
            profile.store();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    public static String getPortletSetId(RunData rundata, String portletId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletId)) continue;
                    return portletList[i].getId();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static Portlet getPortlet(RunData rundata, String portletId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletId)) continue;
                    PortletWrapper wrapper = (PortletWrapper)PortletFactory.getPortlet((Entry)entries[j]);
                    if (wrapper != null) {
                        return wrapper.getPortlet();
                    }
                    return null;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }
}

