/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.page;

import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.page.PageResultData;
import com.aimluck.eip.page.util.PageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PageSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PageSelectData.class.getName());

    protected List selectList(RunData rundata, Context context) {
        Portlet portlet = (Portlet)context.get("portlet");
        String selectedPortletId = portlet.getID();
        if (selectedPortletId == null || selectedPortletId.equals("")) {
            return null;
        }
        String selectedPageId = PageUtils.getPortletSetId(rundata, selectedPortletId);
        Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
        if (portlets == null) {
            return null;
        }
        Portlets pane = null;
        ArrayList<Portlets> portletList = new ArrayList<Portlets>();
        int portletsLen = portlets.getPortletsCount();
        for (int i = 0; i < portletsLen; ++i) {
            pane = portlets.getPortlets(i);
            if (selectedPageId.equals(pane.getId())) continue;
            portletList.add(pane);
        }
        Collections.sort(portletList, new Comparator(){

            public int compare(Object pane1, Object pane2) {
                Long pos1 = ((Portlets)pane1).getLayout().getPosition();
                Long pos2 = ((Portlets)pane2).getLayout().getPosition();
                return pos1.compareTo(pos2);
            }
        });
        int length = portletList.size();
        this.setPageParam(length);
        int start = this.getStart();
        int rowsNum = this.getRowsNum();
        int count = -1;
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowsNum && (count = i + start) < length; ++i) {
            list.add(portletList.get(count));
        }
        portletList.clear();
        return list;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        String portletId = rundata.getParameters().getString("entityid");
        if (portletId == null || portletId.equals("")) {
            return null;
        }
        return PageUtils.getPortlets(rundata, portletId);
    }

    protected Object getResultData(Object obj) {
        return this.getResultDataDetail(obj);
    }

    protected Object getResultDataDetail(Object obj) {
        Portlets record = (Portlets)obj;
        PageResultData rd = new PageResultData();
        rd.initField();
        rd.setPageId(record.getId());
        rd.setPageTitle(record.getTitle());
        rd.setPageDescription(record.getDescription());
        rd.setPortletNum(record.getEntryCount());
        return rd;
    }

    protected Attributes getColumnMap() {
        return null;
    }
}

