/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.page;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.page.util.PageUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Controller;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.psml.PsmlController;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlMetaInfo;
import org.apache.jetspeed.om.profile.psml.PsmlPortlets;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.idgenerator.JetspeedIdGenerator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PageFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PageFormData.class.getName());
    private static final int MAX_PAGE_NUM = 6;
    private int currentPageNum = 1;
    private ALStringField page_id;
    private ALStringField page_title;
    private ALStringField page_description;
    private boolean enableAddPage = true;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        Portlets portlets;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"entityid")) {
            if (rundata.getParameters().getString("entityid").equals("new")) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)rundata.getParameters().getString("entityid"));
            }
        }
        if ((portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets()) != null) {
            Portlets[] portletList = portlets.getPortletsArray();
            this.currentPageNum = portletList.length;
        }
    }

    protected void setValidator() {
        this.page_title.setNotNull(true);
        this.page_title.limitMaxLength(10);
        this.page_description.setNotNull(false);
        this.page_description.limitMaxLength(20);
    }

    protected boolean validate(ArrayList msgList) {
        if (this.currentPageNum > 6) {
            msgList.add("\u3053\u308c\u4ee5\u4e0a\u30da\u30fc\u30b8\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        this.page_title.validate(msgList);
        this.page_description.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            String pageId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (pageId == null || pageId.equals("")) {
                return false;
            }
            this.page_id.setValue(pageId);
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            String pageidStr = this.page_id.getValue();
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                if (!portletList[i].getId().equals(pageidStr)) continue;
                MetaInfo info = portletList[i].getMetaInfo();
                if (info != null) {
                    this.page_title.setValue(info.getTitle());
                    this.page_description.setValue(info.getDescription());
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            String title = this.page_title.getValue();
            if (title == null || title.equals("")) {
                title = "\u30de\u30a4\u30da\u30fc\u30b8";
            }
            if (portlets != null) {
                Portlets[] portletList = portlets.getPortletsArray();
                if (portletList == null) {
                    return false;
                }
                int length = portletList.length;
                if (length >= 6) {
                    this.enableAddPage = false;
                    msgList.add("\u3053\u308c\u4ee5\u4e0a\u30da\u30fc\u30b8\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                long position = 0L;
                long tmpPosition = 0L;
                int index = 0;
                for (int i = 0; i < length; ++i) {
                    tmpPosition = portletList[i].getLayout().getPosition();
                    if (position >= tmpPosition) continue;
                    position = tmpPosition;
                    index = i;
                }
                portletList[index].getLayout().setPosition(position + 1L);
                PsmlLayout newLayout = new PsmlLayout();
                newLayout.setPosition(position);
                newLayout.setSize(-1L);
                PsmlController controller = new PsmlController();
                controller.setName("TwoColumnsRight");
                PsmlPortlets p = new PsmlPortlets();
                p.setLayout((Layout)newLayout);
                p.setController((Controller)controller);
                p.setMetaInfo((MetaInfo)new PsmlMetaInfo());
                p.getMetaInfo().setTitle(title);
                p.getMetaInfo().setDescription(this.page_description.getValue());
                p.setId(JetspeedIdGenerator.getNextPeid());
                SecurityReference defaultRef = PortalToolkit.getDefaultSecurityRef((Profile)((JetspeedRunData)rundata).getProfile());
                if (defaultRef != null) {
                    p.setSecurityRef(defaultRef);
                }
                portlets.addPortlets((Portlets)p);
            }
            PageUtils.doSave(rundata, context);
            PageUtils.updateLayoutPositions(portlets);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            String pageId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (pageId == null || pageId.equals("")) {
                return false;
            }
            this.page_id.setValue(pageId);
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            String pageidStr = this.page_id.getValue();
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                if (!portletList[i].getId().equals(pageidStr)) continue;
                MetaInfo info = portletList[i].getMetaInfo();
                if (info == null) {
                    info = new PsmlMetaInfo();
                    portletList[i].setMetaInfo(info);
                }
                info.setTitle(this.page_title.getValue());
                info.setDescription(this.page_description.getValue());
                break;
            }
            PageUtils.doSave(rundata, context);
            PageUtils.updateLayoutPositions(portlets);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean result = false;
        try {
            String portletId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (portletId == null || portletId.equals("")) {
                return false;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(portletId);
            result = PageUtils.deletePages(rundata, context, values, msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return result;
    }

    public void initField() {
        this.page_id = new ALStringField();
        this.page_id.setFieldName("\u30da\u30fc\u30b8 ID");
        this.page_id.setTrim(true);
        this.page_title = new ALStringField();
        this.page_title.setFieldName("\u30da\u30fc\u30b8\u540d");
        this.page_title.setTrim(true);
        this.page_description = new ALStringField();
        this.page_description.setFieldName("\u30da\u30fc\u30b8\u306e\u8aac\u660e");
        this.page_description.setTrim(true);
    }

    public ALStringField getPageId() {
        return this.page_id;
    }

    public ALStringField getPageDescription() {
        return this.page_description;
    }

    public ALStringField getPageTitle() {
        return this.page_title;
    }

    public boolean enableAddPage() {
        return this.enableAddPage;
    }
}

