/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportEventListener;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.Messages;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class Importer {
    private ImportDescriptor _importDesc;
    private ImportEventListener _listener;

    protected abstract Consumer createConsumer();

    public ImportDescriptor getImportDescriptor() {
        if (this._importDesc == null) {
            this._importDesc = new ImportDescriptor();
        }
        return this._importDesc;
    }

    public ImportEventListener getImportEventListener() {
        return this._listener;
    }

    public void importDocument(InputStream inputStream) throws ImportExportException {
        this.importDocument(Configuration.getParser(), new InputSource(inputStream));
    }

    public void importDocument(Reader reader) throws ImportExportException {
        this.importDocument(Configuration.getParser(), new InputSource(reader));
    }

    public void importDocument(Parser parser, InputSource inputSource) throws ImportExportException {
        Consumer consumer = this.createConsumer();
        parser.setDocumentHandler(consumer);
        try {
            parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new ImportExportException(sAXException);
        }
        catch (IOException iOException) {
            throw new ImportExportException(iOException);
        }
        if (consumer.getResults() != null) {
            this.importEntries(consumer.getResults());
        }
    }

    public abstract void importEntries(Enumeration var1) throws ImportExportException;

    protected void notify(String string, int n) {
        if (this._listener != null) {
            this._listener.processedEntry(string, n);
        }
    }

    public void readImportDescriptor(InputStream inputStream) throws IOException, SAXException {
        this.readImportDescriptor(Configuration.getParser(), new InputSource(inputStream));
    }

    public void readImportDescriptor(Reader reader) throws IOException, SAXException {
        this.readImportDescriptor(Configuration.getParser(), new InputSource(reader));
    }

    protected void readImportDescriptor(Parser parser, InputSource inputSource) throws IOException, SAXException {
        ImportDescriptor importDescriptor = new ImportDescriptor();
        parser.setDocumentHandler(importDescriptor);
        parser.parse(inputSource);
        this.setImportDescriptor(importDescriptor);
    }

    public void setImportDescriptor(ImportDescriptor importDescriptor) {
        this._importDesc = importDescriptor;
    }

    public void setImportEventListener(ImportEventListener importEventListener) throws TooManyListenersException {
        if (this._listener != null) {
            throw new TooManyListenersException(Messages.message("dsml.onlyOneListener"));
        }
        this._listener = importEventListener;
    }
}

