/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog.util;

import com.aimluck.eip.eventlog.action.ALActionEventlogConstants;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;

public class ALEventlogUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEventlogUtils.class.getName());

    public static int getEventTypeValue(String mode) {
        if ("detail".equals(mode)) {
            return 9;
        }
        if ("insert".equals(mode)) {
            return 4;
        }
        if ("list".equals(mode)) {
            return 8;
        }
        if ("form".equals(mode)) {
            return 5;
        }
        if ("new_form".equals(mode)) {
            return 6;
        }
        if ("edit_form".equals(mode)) {
            return 7;
        }
        if ("update".equals(mode)) {
            return 1;
        }
        if ("multi_delete".equals(mode)) {
            return 3;
        }
        if ("delete".equals(mode)) {
            return 2;
        }
        if ("Login".equals(mode)) {
            return 10;
        }
        if ("Logout".equals(mode)) {
            return 11;
        }
        if ("accept".equals(mode)) {
            return 12;
        }
        if ("denial".equals(mode)) {
            return 13;
        }
        if ("punchin".equals(mode)) {
            return 14;
        }
        if ("punchout".equals(mode)) {
            return 15;
        }
        if ("xls_screen".equals(mode)) {
            return 17;
        }
        return 0;
    }

    public static String getEventAliasName(int eventType) {
        int type = 0;
        if (eventType > 0 && eventType < ALActionEventlogConstants.EVENT_ALIAS_NAME.length) {
            type = eventType;
        }
        return ALActionEventlogConstants.EVENT_ALIAS_NAME[type];
    }

    public static String getPortletAliasName(int portletType) {
        if (portletType == 0) {
            return "\u305d\u306e\u4ed6\u306e\u6a5f\u80fd";
        }
        if (portletType == 1) {
            return "\u30ed\u30b0\u30a4\u30f3";
        }
        if (portletType == 2) {
            return "\u30ed\u30b0\u30a2\u30a6\u30c8";
        }
        if (portletType == 3) {
            return "\u30a2\u30ab\u30a6\u30f3\u30c8";
        }
        if (portletType == 100) {
            return "\u30ab\u30ec\u30f3\u30c0\u30fc";
        }
        if (portletType == 110) {
            return "\u30d6\u30ed\u30b0\u30a8\u30f3\u30c8\u30ea";
        }
        if (portletType == 111) {
            return "\u30d6\u30ed\u30b0\u30c6\u30fc\u30de";
        }
        if (portletType == 120 || portletType == 121) {
            return "\u30ef\u30fc\u30af\u30d5\u30ed\u30fc";
        }
        if (portletType == 130) {
            return "ToDo";
        }
        if (portletType == 131) {
            return "ToDo\u30ab\u30c6\u30b4\u30ea";
        }
        if (portletType == 140) {
            return "\u4f1d\u8a00\u30e1\u30e2";
        }
        if (portletType == 150) {
            return "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9";
        }
        if (portletType == 160) {
            return "\u30a2\u30c9\u30ec\u30b9\u5e33(\u30a2\u30c9\u30ec\u30b9)";
        }
        if (portletType == 161) {
            return "\u30a2\u30c9\u30ec\u30b9\u5e33(\u4f1a\u793e\u60c5\u5831)";
        }
        if (portletType == 162) {
            return "\u30a2\u30c9\u30ec\u30b9\u5e33(\u793e\u5916\u30b0\u30eb\u30fc\u30d7)";
        }
        if (portletType == 170) {
            return "\u30e1\u30e2\u5e33";
        }
        if (portletType == 180 || portletType == 181) {
            return "\u63b2\u793a\u677f";
        }
        if (portletType == 190) {
            return "\u691c\u7d22\u7a93";
        }
        if (portletType == 200) {
            return "My\u30ea\u30f3\u30af";
        }
        if (portletType == 210) {
            return "\u65b0\u7740\u60c5\u5831";
        }
        if (portletType == 220) {
            return "\u5171\u6709\u30d5\u30a9\u30eb\u30c0";
        }
        if (portletType == 221) {
            return "\u5171\u6709\u30d5\u30a9\u30eb\u30c0";
        }
        if (portletType == 230 || portletType == 231) {
            return "Web\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8";
        }
        if (portletType == 240) {
            return "\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u7ba1\u7406";
        }
        if (portletType == 250) {
            return "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u7ba1\u7406";
        }
        if (portletType == 260) {
            return "\u30e6\u30fc\u30b6\u30fc\u7de8\u96c6";
        }
        if (portletType == 270) {
            return "My\u30b0\u30eb\u30fc\u30d7";
        }
        if (portletType == 280) {
            return "\u30da\u30fc\u30b8\u8a2d\u5b9a";
        }
        if (portletType == 290) {
            return "\u643a\u5e2f\u96fb\u8a71\u8a2d\u5b9a";
        }
        if (portletType == 300) {
            return "\u5171\u6709\u30ab\u30c6\u30b4\u30ea";
        }
        return "\u305d\u306e\u4ed6\u306e\u6a5f\u80fd";
    }

    public static String getPortletName(RunData rundata, String portletEntryId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    return entries[j].getParent();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }
}

