/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog.action;

import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.eventlog.util.ALEventlogUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.eventlog.ALEventlogHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;

public class ALActionEventlogHandler
extends ALEventlogHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALActionEventlogHandler.class.getName());

    public static ALEventlogHandler getInstance() {
        return new ALActionEventlogHandler();
    }

    public void log(int entity_id, int portlet_type, String note) {
        this.logActionEvent(entity_id, portlet_type, note);
    }

    private void logActionEvent(int entity_id, int portlet_type, String note) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        String mode = rundata.getParameters().getString("mode");
        if (mode == null || "".equals(mode)) {
            String action = rundata.getAction();
            if (action == null || "".equals(action)) {
                return;
            }
        } else {
            int event_type = ALEventlogUtils.getEventTypeValue(mode);
            int uid = ALEipUtils.getUserId((RunData)rundata);
            String ip_addr = rundata.getRemoteAddr();
            this.saveEvent(event_type, uid, portlet_type, entity_id, ip_addr, note);
        }
    }

    public void logLogin(int userid) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        int event_type = ALEventlogUtils.getEventTypeValue("Login");
        int p_type = 1;
        String ip_addr = rundata.getRemoteAddr();
        this.saveEvent(event_type, userid, p_type, 0, ip_addr, null);
    }

    public void logLogout(int userid) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        int event_type = ALEventlogUtils.getEventTypeValue("Logout");
        int p_type = 2;
        String ip_addr = rundata.getRemoteAddr();
        this.saveEvent(event_type, userid, p_type, 0, ip_addr, null);
    }

    public void logXlsScreen(int userid, String Note, int _p_type) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        int event_type = ALEventlogUtils.getEventTypeValue("xls_screen");
        String ip_addr = rundata.getRemoteAddr();
        this.saveEvent(event_type, userid, _p_type, 0, ip_addr, null);
    }

    private boolean saveEvent(int event_type, int uid, int p_type, int entity_id, String ip_addr, String note) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTEventlog log = (EipTEventlog)dataContext.createAndRegisterNewObject(EipTEventlog.class);
            TurbineUser tuser = (TurbineUser)DataObjectUtils.objectForPK((ObjectContext)dataContext, TurbineUser.class, (Object)uid);
            log.setTurbineUser(tuser);
            log.setEventDate(Calendar.getInstance().getTime());
            log.setEventType(Integer.valueOf(event_type));
            log.setPortletType(Integer.valueOf(p_type));
            log.setEntityId(Integer.valueOf(entity_id));
            log.setIpAddr(ip_addr);
            log.setCreateDate(Calendar.getInstance().getTime());
            log.setUpdateDate(Calendar.getInstance().getTime());
            log.setNote(note);
            dataContext.commitChanges();
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
    }
}

