/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow.util;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import com.aimluck.eip.workflow.WorkflowCategoryResultData;
import com.aimluck.eip.workflow.WorkflowDecisionRecordData;
import com.aimluck.eip.workflow.WorkflowDetailResultData;
import com.aimluck.eip.workflow.WorkflowOldRequestResultData;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowUtils.class.getName());
    public static final String DB_STATUS_REQUEST = "R";
    public static final String DB_STATUS_CONFIRM = "C";
    public static final String DB_STATUS_WAIT = "W";
    public static final String DB_STATUS_ACCEPT = "A";
    public static final String DB_STATUS_DENIAL = "D";
    public static final String DB_PROGRESS_ACCEPT = "A";
    public static final String DB_PROGRESS_WAIT = "W";
    public static final String DB_PROGRESS_DENAIL = "D";
    public static final String DB_PROGRESS_REAPPLY = "R";

    public static EipTWorkflowRequest getEipTWorkflowRequest(RunData rundata, Context context, boolean mode_update) throws ALPageNotFoundException {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            List requests;
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query10 = new SelectQuery(EipTWorkflowRequestMap.class);
            Expression exp10 = ExpressionFactory.matchExp((String)"requestId", (Object)Integer.valueOf(requestid));
            Expression exp11 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
            query10.setQualifier(exp10.andExp(exp11));
            List maps = dataContext.performQuery((Query)query10);
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[WorkFlow] Invalid user access...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = new SelectQuery(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            if (mode_update) {
                Expression exp3 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.status", (Object)DB_STATUS_CONFIRM);
                query.andQualifier(exp3);
                Expression exp4 = ExpressionFactory.matchExp((String)"progress", (Object)"W");
                query.andQualifier(exp4);
            }
            if ((requests = dataContext.performQuery((Query)query)) == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            EipTWorkflowRequest request = (EipTWorkflowRequest)requests.get(0);
            return request;
        }
        catch (ALPageNotFoundException pageNotFound) {
            logger.error((Object)pageNotFound);
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRequest getEipTWorkflowRequestAll(RunData rundata, Context context) {
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            WhatsNewUtils.shiftWhatsNewReadFlag((int)3, (int)Integer.parseInt(requestid), (int)ALEipUtils.getUserId((RunData)rundata));
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        try {
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            List requests = dataContext.performQuery((Query)query);
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRequest getEipTWorkflowRequestForOwner(RunData rundata, Context context) {
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List requests = dataContext.performQuery((Query)query);
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getEipTWorkflowRequestMap(EipTWorkflowRequest request) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTWorkflowRequestMap.class);
            Expression exp = ExpressionFactory.matchExp((String)"requestId", (Object)request.getRequestId());
            query.setQualifier(exp);
            query.addOrdering("orderIndex", true);
            List maps = dataContext.performQuery((Query)query);
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return maps;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowCategory getEipTWorkflowCategory(RunData rundata, Context context) {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (categoryid == null || Integer.valueOf(categoryid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)categoryid);
            query.setQualifier(exp1);
            List categories = dataContext.performQuery((Query)query);
            if (categories == null || categories.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowCategory)categories.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowCategory getEipTWorkflowCategory(DataContext dataContext, Long category_id) {
        try {
            EipTWorkflowCategory category = (EipTWorkflowCategory)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipTWorkflowCategory.class, (Object)category_id);
            return category;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List loadCategoryList(RunData rundata, Context context) {
        try {
            ArrayList<WorkflowCategoryResultData> categoryList = new ArrayList<WorkflowCategoryResultData>();
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTWorkflowCategory.class);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTWorkflowCategory record = (EipTWorkflowCategory)aList.get(i);
                WorkflowCategoryResultData rd = new WorkflowCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                categoryList.add(rd);
            }
            return categoryList;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static Object getResultDataDetail(Object obj) {
        try {
            List oldReuqests;
            EipTWorkflowRequest record = (EipTWorkflowRequest)obj;
            WorkflowDetailResultData rd = new WorkflowDetailResultData();
            rd.initField();
            rd.setUserId(record.getUserId().longValue());
            rd.setRequestName(record.getRequestName());
            rd.setRequestId(record.getRequestId().longValue());
            rd.setCategoryId(record.getEipTWorkflowCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTWorkflowCategory().getCategoryName());
            rd.setPriorityString(WorkflowUtils.getPriorityString(record.getPriority().intValue()));
            rd.setNote(record.getNote());
            rd.setPrice(record.getPrice());
            rd.setProgress(record.getProgress());
            ArrayList<WorkflowDecisionRecordData> drList = new ArrayList<WorkflowDecisionRecordData>();
            ALEipUser user = null;
            EipTWorkflowRequestMap map = null;
            WorkflowDecisionRecordData drd = null;
            List maps = WorkflowUtils.getEipTWorkflowRequestMap(record);
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = (EipTWorkflowRequestMap)maps.get(i);
                drd = new WorkflowDecisionRecordData();
                drd.initField();
                user = ALEipUtils.getALEipUser((int)map.getUserId());
                drd.setUserId(map.getUserId().intValue());
                drd.setUserAliasName(user.getAliasName().getValue());
                drd.setStatus(map.getStatus());
                drd.setStatusString(WorkflowUtils.getStatusString(map.getStatus()));
                drd.setOrder(map.getOrderIndex());
                drd.setNote(map.getNote());
                drd.setUpdateDate(WorkflowUtils.translateDate(map.getUpdateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
                drList.add(drd);
            }
            rd.setDecisionRecords(drList);
            if (record.getParentId() != 0 && (oldReuqests = WorkflowUtils.getOldRequests(record)) != null && oldReuqests.size() > 0) {
                ArrayList<WorkflowOldRequestResultData> oldList = new ArrayList<WorkflowOldRequestResultData>();
                int osize = oldReuqests.size();
                for (int i = 0; i < osize; ++i) {
                    EipTWorkflowRequest request = (EipTWorkflowRequest)oldReuqests.get(i);
                    WorkflowOldRequestResultData orrd = new WorkflowOldRequestResultData();
                    orrd.initField();
                    orrd.setRequestId(request.getRequestId().intValue());
                    orrd.setRequestName(request.getRequestName());
                    orrd.setCategoryName(request.getEipTWorkflowCategory().getCategoryName());
                    orrd.setUpdateDate(WorkflowUtils.translateDate(request.getUpdateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
                    oldList.add(orrd);
                }
                rd.setOldRequestLinks(oldList);
            }
            rd.setCreateDate(WorkflowUtils.translateDate(record.getCreateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
            rd.setUpdateDate(WorkflowUtils.translateDate(record.getUpdateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static List getOldRequests(EipTWorkflowRequest request) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTWorkflowRequest.class);
            Expression exp11 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)request.getParentId());
            Expression exp12 = ExpressionFactory.matchExp((String)"parentId", (Object)request.getParentId());
            query.setQualifier(exp11.orExp(exp12));
            Expression exp2 = ExpressionFactory.noMatchDbExp((String)"REQUEST_ID", (Object)request.getRequestId());
            query.andQualifier(exp2);
            query.addOrdering("updateDate", true);
            List requests = dataContext.performQuery((Query)query);
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return requests;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getPriorityImage(int i) {
        String[] temp = new String[]{"priority_high.gif", "priority_middle_high.gif", "priority_middle.gif", "priority_middle_low.gif", "priority_low.gif"};
        String image = null;
        try {
            image = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getPriorityString(int i) {
        String[] temp = new String[]{"\u9ad8\u3044", "\u3084\u3084\u9ad8\u3044", "\u666e\u901a", "\u3084\u3084\u4f4e\u3044", "\u4f4e\u3044"};
        String string = null;
        try {
            string = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String getStateImage(int i) {
        String[] temp = new String[]{"state_000.gif", "state_010.gif", "state_020.gif", "state_030.gif", "state_040.gif", "state_050.gif", "state_060.gif", "state_070.gif", "state_080.gif", "state_090.gif", "state_100.gif"};
        String image = null;
        try {
            image = temp[i / 10];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getStateString(int i) {
        if (i == 0) {
            return "\u672a\u7740\u624b";
        }
        if (i == 100) {
            return "\u5b8c\u4e86";
        }
        return new StringBuffer().append(i).append("%").toString();
    }

    public static String getStatusString(String status) {
        String res = "";
        if ("R".equals(status)) {
            res = "\u7533\u8acb";
        } else if (DB_STATUS_CONFIRM.equals(status)) {
            res = "\u78ba\u8a8d\u4e2d";
        } else if ("W".equals(status)) {
            res = "\u78ba\u8a8d\u524d";
        } else if ("A".equals(status)) {
            res = "\u627f\u8a8d";
        } else if ("D".equals(status)) {
            res = "\u5426\u8a8d";
        }
        return res;
    }

    public static String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        return sdf.format(date);
    }

    public static String translateMoneyStr(String money) {
        if (money == null || money.length() == 0) {
            return money;
        }
        StringBuffer sb = new StringBuffer();
        int len = money.length();
        int count = len / 3;
        int del = len % 3;
        sb.append(money.substring(0, del));
        if (count > 0) {
            if (len > 3 && del != 0) {
                sb.append(",");
            }
            for (int i = 0; i < count; ++i) {
                sb.append(money.substring(del + 3 * i, del + 3 * i + 3));
                if (i == count - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static boolean sendMail(RunData rundata, EipTWorkflowRequest request, ALEipUser destUser, ArrayList msgList) throws Exception {
        String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        String subject = "[Aipo]\u30ef\u30fc\u30af\u30d5\u30ed\u30fc";
        ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
        memberList.add(destUser);
        List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
        return ALMailUtils.sendMailDelegate((String)org_id, (int)((int)destUser.getUserId().getValue()), (List)destMemberList, (String)subject, (String)subject, (String)WorkflowUtils.createMsgForPc(rundata, request), (String)WorkflowUtils.createMsgForCellPhone(rundata, request, destUser), (int)ALMailUtils.getSendDestType((int)23), (ArrayList)msgList);
    }

    public static String createMsgForPc(RunData rundata, EipTWorkflowRequest request) {
        String CR = System.getProperty("line.separator");
        ALBaseUser user = null;
        ALEipUser user2 = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(request.getUserId().toString()));
            user2 = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer body = new StringBuffer("");
        body.append(user2.getAliasName().toString());
        if (!user.getEmail().equals("")) {
            body.append("(").append(user.getEmail()).append(")");
        }
        if ("D".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u5dee\u3057\u623b\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u5dee\u623b\u8981\u78ba\u8a8d").append(CR);
        } else if ("A".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u627f\u8a8d\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u627f\u8a8d\u6e08\u307f").append(CR);
        } else {
            body.append("\u3055\u3093\u304b\u3089\u306e\u627f\u8a8d\u4f9d\u983c\u3067\u3059\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u6c7a\u88c1\u5f85\u3061").append(CR);
        }
        body.append("[\u8868\u984c]").append(CR);
        body.append(request.getEipTWorkflowCategory().getCategoryName()).append(CR);
        if (request.getRequestName() != null && !"".equals(request.getRequestName())) {
            body.append(request.getRequestName()).append(CR);
        }
        body.append("[\u7533\u8acb\u65e5]").append(CR).append(WorkflowUtils.translateDate(request.getCreateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206")).append(CR);
        body.append("[\u91cd\u8981\u5ea6]").append(CR).append(WorkflowUtils.getPriorityString(request.getPriority().intValue())).append(CR);
        body.append("[\u7533\u8acb\u5185\u5bb9]").append(CR).append(request.getNote()).append(CR);
        if (request.getPrice() != null && request.getPrice().intValue() > 0) {
            body.append("[\u91d1\u984d]").append(CR).append(request.getPrice()).append(" \u5186").append(CR);
        }
        body.append(CR);
        body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        body.append("\u30fb\u793e\u5916").append(CR);
        body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
        body.append("\u30fb\u793e\u5185").append(CR);
        body.append("\u3000").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
        body.append("---------------------").append(CR);
        body.append("Aipo").append(CR);
        return body.toString();
    }

    public static String createMsgForCellPhone(RunData rundata, EipTWorkflowRequest request, ALEipUser login_user) {
        String CR = System.getProperty("line.separator");
        ALBaseUser user = null;
        ALEipUser user2 = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(request.getUserId().toString()));
            user2 = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (JetspeedSecurityException e) {
            return "";
        }
        catch (ALDBErrorException e) {
            return "";
        }
        StringBuffer body = new StringBuffer("");
        body.append(user2.getAliasName().toString());
        if (!user.getEmail().equals("")) {
            body.append("(").append(user.getEmail()).append(")");
        }
        if ("D".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u5dee\u3057\u623b\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u5dee\u623b\u8981\u78ba\u8a8d").append(CR);
        } else if ("A".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u627f\u8a8d\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u627f\u8a8d\u6e08\u307f").append(CR);
        } else {
            body.append("\u3055\u3093\u304b\u3089\u306e\u627f\u8a8d\u4f9d\u983c\u3067\u3059\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u6c7a\u88c1\u5f85\u3061").append(CR);
        }
        body.append("[\u8868\u984c]").append(CR);
        body.append(request.getEipTWorkflowCategory().getCategoryName()).append(CR);
        if (request.getRequestName() != null && !"".equals(request.getRequestName())) {
            body.append(request.getRequestName()).append(CR);
        }
        body.append("[\u7533\u8acb\u65e5]").append(CR).append(WorkflowUtils.translateDate(request.getCreateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206")).append(CR);
        body.append("[\u91cd\u8981\u5ea6]").append(CR).append(WorkflowUtils.getPriorityString(request.getPriority().intValue())).append(CR);
        if (request.getPrice() != null && request.getPrice().intValue() > 0) {
            body.append("[\u91d1\u984d]").append(CR).append(request.getPrice()).append(" \u5186").append(CR);
        }
        body.append(CR);
        body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
        body.append("---------------------").append(CR);
        body.append("Aipo").append(CR);
        return body.toString();
    }

    public static boolean hasWorkFlowAuthority(List memberList) {
        int size = memberList.size();
        ArrayList<ALNumberField> userIds = new ArrayList<ALNumberField>();
        for (int i = 0; i < size; ++i) {
            userIds.add(((ALEipUser)memberList.get(i)).getUserId());
        }
        return false;
    }

    public static List getAuthorityUsers(RunData rundata, String groupname, boolean includeLoginuser) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List ulist = aclhandler.getAuthorityUsersFromGroup(rundata, "workflow_request_self", groupname, includeLoginuser);
            int recNum = ulist.size();
            ArrayList<UserLiteBean> list = new ArrayList<UserLiteBean>();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)ulist.get(j);
                UserLiteBean user = new UserLiteBean();
                user.initField();
                user.setUserId(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"USER_ID")).intValue());
                user.setName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LOGIN_NAME"));
                user.setAliasName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"), (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME"));
                list.add(user);
            }
            return list;
        }
        catch (InstantiationException e) {
            return null;
        }
    }
}

