/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowFormData.class.getName());
    private ALStringField request_name;
    private ALNumberField category_id;
    private ALNumberField priority;
    private ALStringField note;
    private ALNumberField price;
    private List categoryList;
    private ALStringField positions;
    private ArrayList memberList;
    private ALEipUser login_user;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
    }

    public void initField() {
        this.request_name = new ALStringField();
        this.request_name.setFieldName("\u8868\u984c");
        this.request_name.setTrim(true);
        this.category_id = new ALNumberField();
        this.category_id.setFieldName("\u30ab\u30c6\u30b4\u30ea");
        this.priority = new ALNumberField(3L);
        this.priority.setFieldName("\u91cd\u8981\u5ea6");
        this.note = new ALStringField();
        this.note.setFieldName("\u7533\u8acb\u5185\u5bb9");
        this.note.setTrim(false);
        this.price = new ALNumberField();
        this.price.setFieldName("\u91d1\u984d");
        this.positions = new ALStringField();
        this.positions.setFieldName("\u30e6\u30fc\u30b6\u540d\u30ea\u30b9\u30c8");
        this.positions.setTrim(true);
        this.memberList = new ArrayList();
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = WorkflowUtils.loadCategoryList(rundata, context);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                Object[] userNames = rundata.getParameters().getStrings("positions");
                if (userNames != null && userNames.length > 0) {
                    DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                    SelectQuery query = new SelectQuery(TurbineUser.class);
                    Expression exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])userNames);
                    Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
                    query.setQualifier(exp1);
                    query.andQualifier(exp2);
                    List list = dataContext.performQuery((Query)query);
                    TurbineUser record = null;
                    int length = userNames.length;
                    for (int i = 0; i < length; ++i) {
                        record = this.getEipUserRecord(list, (String)userNames[i]);
                        ALEipUser user = new ALEipUser();
                        user.initField();
                        user.setUserId(record.getUserId().intValue());
                        user.setName(record.getLoginName());
                        user.setAliasName(record.getFirstName(), record.getLastName());
                        this.memberList.add(user);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return res;
    }

    private TurbineUser getEipUserRecord(List userList, String userName) {
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            TurbineUser record = (TurbineUser)userList.get(i);
            if (!record.getLoginName().equals(userName)) continue;
            return record;
        }
        return null;
    }

    protected void setValidator() {
        this.request_name.limitMaxLength(50);
        this.price.limitMaxValue(1000000000L);
        this.note.setNotNull(true);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) {
        this.request_name.validate(msgList);
        this.note.validate(msgList);
        this.price.validate(msgList);
        if (this.memberList == null || this.memberList.size() <= 0) {
            msgList.add("\u300e <span class='em'>\u7533\u8acb\u5148</span> \u300f\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowRequest request = WorkflowUtils.getEipTWorkflowRequestForOwner(rundata, context);
            if (request == null) {
                return false;
            }
            this.request_name.setValue(request.getRequestName());
            this.category_id.setValue(request.getEipTWorkflowCategory().getCategoryId().longValue());
            this.priority.setValue(request.getPriority().longValue());
            this.note.setValue(request.getNote());
            this.price.setValue(request.getPrice().longValue());
            List maps = WorkflowUtils.getEipTWorkflowRequestMap(request);
            EipTWorkflowRequestMap map = null;
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = (EipTWorkflowRequestMap)maps.get(i);
                int user_id = map.getUserId();
                if ("R".equals(map.getStatus())) continue;
                this.memberList.add(ALEipUtils.getALEipUser((int)user_id));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowRequest request = WorkflowUtils.getEipTWorkflowRequestForOwner(rundata, context);
            if (request == null) {
                return false;
            }
            this.dataContext.deleteObject((Persistent)request);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, request.getEipTWorkflowCategory().getCategoryName() + " " + request.getRequestName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            Date nowDate = Calendar.getInstance().getTime();
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(this.dataContext, this.category_id.getValue());
            EipTWorkflowRequest request = (EipTWorkflowRequest)this.dataContext.createAndRegisterNewObject(EipTWorkflowRequest.class);
            request.setRequestName(this.request_name.getValue());
            request.setParentId(Integer.valueOf(0));
            request.setEipTWorkflowCategory(category);
            request.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            request.setPriority(Short.valueOf((short)this.priority.getValue()));
            request.setNote(this.note.getValue());
            request.setPrice(Long.valueOf(this.price.getValue()));
            request.setProgress("W");
            request.setCreateDate(Calendar.getInstance().getTime());
            request.setUpdateDate(Calendar.getInstance().getTime());
            this.insertEipTWorkflowRequestMap(request, this.login_user, "R", 0, nowDate);
            this.insertEipTWorkflowRequestMap(request, (ALEipUser)this.memberList.get(0), "C", 1, nowDate);
            int size = this.memberList.size();
            for (int i = 1; i < size; ++i) {
                this.insertEipTWorkflowRequestMap(request, (ALEipUser)this.memberList.get(i), "W", i + 1, nowDate);
            }
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, request.getEipTWorkflowCategory().getCategoryName() + " " + this.request_name.getValue());
            ALEipUser nextUser = (ALEipUser)this.memberList.get(0);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority((int)nextUser.getUserId().getValue(), "workflow_request_self", 2)) {
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)3, (int)request.getRequestId(), (int)((int)nextUser.getUserId().getValue()));
            }
            WorkflowUtils.sendMail(rundata, request, nextUser, new ArrayList());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowRequest oldrequest = WorkflowUtils.getEipTWorkflowRequestForOwner(rundata, context);
            if (oldrequest == null) {
                return false;
            }
            Date nowDate = Calendar.getInstance().getTime();
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(this.dataContext, this.category_id.getValue());
            EipTWorkflowRequest request = (EipTWorkflowRequest)this.dataContext.createAndRegisterNewObject(EipTWorkflowRequest.class);
            request.setRequestName(this.request_name.getValue());
            if (oldrequest.getParentId() == 0) {
                request.setParentId(oldrequest.getRequestId());
            } else {
                request.setParentId(oldrequest.getParentId());
            }
            request.setEipTWorkflowCategory(category);
            request.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            request.setPriority(Short.valueOf((short)this.priority.getValue()));
            request.setNote(this.note.getValue());
            request.setPrice(Long.valueOf(this.price.getValue()));
            request.setProgress("W");
            request.setCreateDate(Calendar.getInstance().getTime());
            request.setUpdateDate(Calendar.getInstance().getTime());
            this.insertEipTWorkflowRequestMap(request, this.login_user, "R", 0, nowDate);
            this.insertEipTWorkflowRequestMap(request, (ALEipUser)this.memberList.get(0), "C", 1, nowDate);
            int size = this.memberList.size();
            for (int i = 1; i < size; ++i) {
                this.insertEipTWorkflowRequestMap(request, (ALEipUser)this.memberList.get(i), "W", i + 1, nowDate);
            }
            this.dataContext.commitChanges();
            oldrequest.setProgress("R");
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, request.getEipTWorkflowCategory().getCategoryName() + " " + this.request_name.getValue());
            ALEipUser nextUser = (ALEipUser)this.memberList.get(0);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority((int)nextUser.getUserId().getValue(), "workflow_request_self", 2)) {
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)3, (int)request.getRequestId(), (int)((int)nextUser.getUserId().getValue()));
            }
            WorkflowUtils.sendMail(rundata, request, nextUser, new ArrayList());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void insertEipTWorkflowRequestMap(EipTWorkflowRequest request, ALEipUser user, String status, int order, Date now) {
        EipTWorkflowRequestMap map = (EipTWorkflowRequestMap)this.dataContext.createAndRegisterNewObject(EipTWorkflowRequestMap.class);
        int userid = (int)user.getUserId().getValue();
        map.setEipTWorkflowRequest(request);
        map.setUserId(Integer.valueOf(userid));
        map.setStatus(status);
        map.setOrderIndex(Integer.valueOf(order));
        map.setCreateDate(now);
        map.setUpdateDate(now);
    }

    public ALNumberField getCategoryId() {
        return this.category_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALNumberField getPrice() {
        return this.price;
    }

    public ALNumberField getPriority() {
        return this.priority;
    }

    public ALStringField getRequestName() {
        return this.request_name;
    }

    public List getCategoryList() {
        return this.categoryList;
    }

    public List getMemberList() {
        return this.memberList;
    }

    public List getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public String getAclPortletFeature() {
        return "workflow_request_self";
    }
}

