/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowConfirmFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowConfirmFormData.class.getName());
    private ALStringField comment;
    private boolean accept_flg;
    private ALNumberField passback_order;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.comment = new ALStringField();
        this.comment.setTrim(true);
        this.accept_flg = false;
        this.passback_order = new ALNumberField();
    }

    protected void setValidator() {
        this.comment.limitMaxLength(1000);
        if (!this.accept_flg) {
            this.passback_order.setNotNull(true);
            this.passback_order.limitMinValue(0L);
        }
    }

    protected boolean validate(ArrayList msgList) {
        this.comment.validate(msgList);
        if (!this.accept_flg) {
            this.passback_order.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowRequest request = WorkflowUtils.getEipTWorkflowRequest(rundata, context, true);
            if (request == null) {
                return false;
            }
            int login_user_id = ALEipUtils.getUserId((RunData)rundata);
            EipTWorkflowRequestMap map = null;
            int order = 0;
            List maps = WorkflowUtils.getEipTWorkflowRequestMap(request);
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = (EipTWorkflowRequestMap)maps.get(i);
                if (!"C".equals(map.getStatus())) continue;
                order = i + 1;
                break;
            }
            EipTWorkflowRequestMap sendMailMap = null;
            Date now = Calendar.getInstance().getTime();
            if (this.accept_flg) {
                map.setStatus("A");
                map.setNote(this.comment.getValue());
                map.setUpdateDate(now);
                if (order < size) {
                    map = (EipTWorkflowRequestMap)maps.get(order);
                    map.setStatus("C");
                } else {
                    request.setProgress("A");
                    map = this.getEipTWorkflowRequestMapWithRequester(maps);
                }
                sendMailMap = map;
            } else {
                int passback_user_order = (int)this.passback_order.getValue();
                if (passback_user_order == 0) {
                    map.setStatus("D");
                    map.setNote(this.comment.getValue());
                    map.setUpdateDate(now);
                    request.setProgress("D");
                    sendMailMap = map = this.getEipTWorkflowRequestMapWithRequester(maps);
                } else {
                    for (int i = passback_user_order; i < size; ++i) {
                        map = (EipTWorkflowRequestMap)maps.get(i);
                        int user_id = map.getUserId();
                        if (user_id == login_user_id) {
                            map.setStatus("D");
                            map.setNote(this.comment.getValue());
                            map.setUpdateDate(now);
                            break;
                        }
                        if (map.getOrderIndex() == passback_user_order) {
                            map.setStatus("C");
                            sendMailMap = map;
                            continue;
                        }
                        if ("R".equals(map.getStatus())) continue;
                        map.setStatus("W");
                    }
                }
            }
            request.setUpdateDate(now);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, request.getEipTWorkflowCategory().getCategoryName() + " " + request.getRequestName());
            if (sendMailMap != null) {
                ALEipUser nextUser = ALEipUtils.getALEipUser((int)sendMailMap.getUserId());
                ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
                ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
                if (aclhandler.hasAuthority((int)nextUser.getUserId().getValue(), "workflow_request_self", 2)) {
                    WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)3, (int)request.getRequestId(), (int)((int)nextUser.getUserId().getValue()));
                }
                WorkflowUtils.sendMail(rundata, request, ALEipUtils.getALEipUser((int)sendMailMap.getUserId()), new ArrayList());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private EipTWorkflowRequestMap getEipTWorkflowRequestMapWithRequester(List maps) {
        EipTWorkflowRequestMap map = null;
        int size = maps.size();
        for (int i = 0; i < size && !"R".equals((map = (EipTWorkflowRequestMap)maps.get(i)).getStatus()); ++i) {
        }
        return map;
    }

    public void setAcceptFlg(boolean bool) {
        this.accept_flg = bool;
    }

    public String getAclPortletFeature() {
        return "workflow_request_self";
    }
}

