/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowCategoryMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            ArrayList<Integer> intValues = new ArrayList<Integer>();
            int valuesize = values.size();
            for (int i = 0; i < valuesize; ++i) {
                String value = (String)values.get(i);
                if ("1".equals(value)) continue;
                intValues.add(Integer.valueOf(value));
            }
            SelectQuery query = new SelectQuery(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"CATEGORY_ID", intValues);
            query.setQualifier(exp1);
            List categorylist = dataContext.performQuery((Query)query);
            if (categorylist == null || categorylist.size() == 0) {
                return false;
            }
            dataContext.deleteObjects((Collection)categorylist);
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            EipTWorkflowCategory category = null;
            int catesize = categorylist.size();
            for (int i = 0; i < catesize; ++i) {
                category = (EipTWorkflowCategory)categorylist.get(i);
                categoryIds.add(category.getCategoryId());
            }
            SelectQuery reqquery = new SelectQuery(EipTWorkflowRequest.class);
            Expression reqexp1 = ExpressionFactory.inDbExp((String)"eipTWorkflowCategory.CATEGORY_ID", categoryIds);
            reqquery.setQualifier(reqexp1);
            List requests = dataContext.performQuery((Query)reqquery);
            if (requests != null && requests.size() > 0) {
                EipTWorkflowRequest request = null;
                EipTWorkflowCategory defaultCategory = WorkflowUtils.getEipTWorkflowCategory(dataContext, 1L);
                int size = requests.size();
                for (int i = 0; i < size; ++i) {
                    request = (EipTWorkflowRequest)requests.get(i);
                    request.setEipTWorkflowCategory(defaultCategory);
                    ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
                    dataContext.deleteObject((Persistent)category);
                }
            }
            dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }
}

