/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowCategoryFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowCategoryFormData.class.getName());
    private ALStringField category_name;
    private ALStringField note;
    private Integer category_id;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (categoryid != null && Integer.valueOf(categoryid) != null) {
            this.category_id = Integer.valueOf(categoryid);
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.category_name = new ALStringField();
        this.category_name.setFieldName("\u5206\u985e");
        this.category_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(true);
    }

    protected void setValidator() {
        this.category_name.setNotNull(true);
        this.category_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) {
        try {
            SelectQuery query = new SelectQuery(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"categoryName", (Object)this.category_name.getValue());
            query.setQualifier(exp1);
            if ("update".equals(this.getMode())) {
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"CATEGORY_ID", (Object)this.category_id);
                query.andQualifier(exp2);
            }
            if (this.dataContext.performQuery((Query)query).size() != 0) {
                msgList.add("\u5206\u985e\u540d\u300e <span class='em'>" + this.category_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        this.category_name.validate(msgList);
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(rundata, context);
            if (category == null) {
                return false;
            }
            this.category_name.setValue(category.getCategoryName());
            this.note.setValue(category.getNote());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowCategory category = (EipTWorkflowCategory)this.dataContext.createAndRegisterNewObject(EipTWorkflowCategory.class);
            category.setCategoryName(this.category_name.getValue());
            category.setNote(this.note.getValue());
            category.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setCreateDate(Calendar.getInstance().getTime());
            category.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(rundata, context);
            if (category == null) {
                return false;
            }
            category.setCategoryName(this.category_name.getValue());
            category.setNote(this.note.getValue());
            category.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(rundata, context);
            if (category == null) {
                return false;
            }
            if (category.getCategoryId() == 1) {
                msgList.add("\u5206\u985e\u540d\u300e <span class='em'>\u672a\u5206\u985e</span> \u300f\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            this.dataContext.deleteObject((Persistent)category);
            SelectQuery query = new SelectQuery(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTWorkflowCategory.CATEGORY_ID", (Object)category.getCategoryId());
            query.setQualifier(exp1);
            List requests = this.dataContext.performQuery((Query)query);
            if (requests != null && requests.size() > 0) {
                EipTWorkflowRequest request = null;
                EipTWorkflowCategory defaultCategory = WorkflowUtils.getEipTWorkflowCategory(this.dataContext, 1L);
                int size = requests.size();
                for (int i = 0; i < size; ++i) {
                    request = (EipTWorkflowRequest)requests.get(i);
                    request.setEipTWorkflowCategory(defaultCategory);
                }
            }
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public ALStringField getNote() {
        return this.note;
    }
}

