/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.workflow.WorkflowResultData;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowAllSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowAllSelectData.class.getName());
    public static final String TAB_UNFINISHED = "unfinished";
    public static final String TAB_FINISHED = "finished";
    private String currentTab;
    private List categoryList;
    private int requestSum;
    private ALEipUser login_user;
    private String aclPortletFeature;
    private ALNumberField previous_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        int uid;
        Integer entityId;
        int aimUserId;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        String tabParam = rundata.getParameters().getString("alltab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"alltab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"alltab", (String)TAB_UNFINISHED);
            this.currentTab = TAB_UNFINISHED;
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"alltab", (String)tabParam);
            this.currentTab = tabParam;
        }
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        super.init(action, rundata, context);
        String entityId_Str = rundata.getParameters().getString("entityid");
        this.aclPortletFeature = entityId_Str == null || "".equals(entityId_Str) ? "workflow_request_other" : ((aimUserId = this.getUserId(rundata, context, entityId = Integer.valueOf(Integer.parseInt(entityId_Str)))) != (uid = ALEipUtils.getUserId((RunData)rundata)) ? "workflow_request_other" : "workflow_request_self");
        try {
            this.previous_id = new ALNumberField();
            String previd = rundata.getParameters().getString("prvid");
            this.previous_id.setValue(previd);
        }
        catch (Exception e) {
            this.previous_id = null;
        }
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = WorkflowUtils.loadCategoryList(rundata, context);
    }

    public List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.requestSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTWorkflowRequest.class);
        if (TAB_UNFINISHED.equals(this.currentTab)) {
            Expression exp1 = ExpressionFactory.noMatchExp((String)"progress", (Object)"A");
            query.setQualifier(exp1);
        } else if (TAB_FINISHED.equals(this.currentTab)) {
            Expression exp1 = ExpressionFactory.matchExp((String)"progress", (Object)"A");
            query.setQualifier(exp1);
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            EipTWorkflowRequest record = (EipTWorkflowRequest)obj;
            WorkflowResultData rd = new WorkflowResultData();
            rd.initField();
            rd.setRequestId(record.getRequestId().intValue());
            rd.setCategoryId(record.getEipTWorkflowCategory().getCategoryId().longValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)record.getEipTWorkflowCategory().getCategoryName(), (int)this.getStrLength()));
            rd.setRequestName(ALCommonUtils.compressString((String)record.getRequestName(), (int)this.getStrLength()));
            rd.setPriority(record.getPriority().intValue());
            rd.setPriorityImage(WorkflowUtils.getPriorityImage(record.getPriority().intValue()));
            rd.setPriorityString(WorkflowUtils.getPriorityString(record.getPriority().intValue()));
            rd.setProgress(record.getProgress());
            rd.setPrice(record.getPrice());
            String lastUpdateUser = null;
            EipTWorkflowRequestMap map = null;
            int order = 0;
            List maps = WorkflowUtils.getEipTWorkflowRequestMap(record);
            int size = maps.size();
            if ("A".equals(record.getProgress())) {
                map = (EipTWorkflowRequestMap)maps.get(size - 1);
                ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                lastUpdateUser = user.getAliasName().getValue();
                order = map.getOrderIndex();
            } else {
                for (int i = 0; i < size; ++i) {
                    map = (EipTWorkflowRequestMap)maps.get(i);
                    if (!"C".equals(map.getStatus())) continue;
                    ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                    lastUpdateUser = user.getAliasName().getValue();
                    order = map.getOrderIndex() - 1;
                    break;
                }
            }
            rd.setStateString(order + "/" + (size - 1));
            rd.setLastUpdateUser(lastUpdateUser);
            rd.setCreateDate(WorkflowUtils.translateDate(record.getCreateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private int getUserId(RunData rundata, Context context, Integer entityId) {
        Expression exp;
        SelectQuery query;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List record = dataContext.performQuery((Query)(query = new SelectQuery(EipTWorkflowRequest.class, exp = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)entityId))));
        if (record.size() > 0) {
            return ((EipTWorkflowRequest)record.get(0)).getUserId();
        }
        return -1;
    }

    public Object selectDetail(RunData rundata, Context context) {
        return WorkflowUtils.getEipTWorkflowRequestAll(rundata, context);
    }

    protected Object getResultDataDetail(Object obj) {
        return WorkflowUtils.getResultDataDetail(obj);
    }

    public List getCategoryList() {
        return this.categoryList;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public int getRequestSum() {
        return this.requestSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("request_name", "requestName");
        map.putValue("priority", "priority");
        map.putValue("price", "price");
        map.putValue("create_date", "createDate");
        map.putValue("category", "CATEGORY_ID");
        return map;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public ALNumberField getPreviousID() {
        return this.previous_id;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean hasAuthorityOther() {
        return this.hasAuthority;
    }
}

