/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio.util;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAccountCsvUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAccountCsvUtils.class.getName());
    public static final String CSV_ACCOUNT_TEMP_FILENAME = "account.csv";
    public static final String CSV_ACCOUNT_TEMP_ERROR_FILENAME = "account_post_err.csv";
    public static final String CSV_ACCOUNT_POST_TEMP_FILENAME = "account_post.csv";
    public static final String CSV_ACCOUNT_POST_TEMP_ERROR_FILENAME = "account_post_err.csv";
    public static final int CSV_FILE_COL_COUNT = 13;
    public static final String CSV_ACCOUNT_TEMP_FOLDER = "user_info";
    public static final String CSV_ACCOUNT_POST_TEMP_FOLDER = "account_post";

    public static boolean isMsieBrowser(RunData rundata) {
        String os = "Win";
        String browserNames = "MSIE";
        String userAgent = rundata.getRequest().getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            return false;
        }
        if (userAgent.indexOf("Win") < 0) {
            return false;
        }
        return userAgent.indexOf(browserNames) > 0;
    }

    public static String[] getCsvSplitStrings(String line) {
        if (line == null || line.equals("")) {
            return null;
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            int count_comma = 0;
            StringBuffer token = new StringBuffer("");
            int len = line.length();
            for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                if (c != ',' && i == len - 1) {
                    token.append(c);
                    list.add(token.toString());
                } else {
                    if (c == ',') {
                        list.add(token.toString());
                        token = new StringBuffer("");
                        ++count_comma;
                        continue;
                    }
                    token.append(c);
                }
                if (count_comma > 13) break;
            }
            if (line.endsWith(",")) {
                list.add("");
            }
            String[] strings = new String[list.size()];
            strings = list.toArray(strings);
            return strings;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EipMCompany getEipMCompany(RunData rundata, Context context) {
        EipMCompany result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List list = dataContext.performQuery((Query)(query = new SelectQuery(EipMCompany.class, exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id)))));
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static EipMPost getEipMPost(RunData rundata, Context context) {
        EipMPost result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List list = dataContext.performQuery((Query)(query = new SelectQuery(EipMPost.class, exp = ExpressionFactory.matchDbExp((String)"POST_ID", (Object)Integer.valueOf(id)))));
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMPost)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static String getAccountPostCsvFolderName(String index) {
        String result = ALCsvTokenizer.CSV_TEMP_FOLDER + File.separator + CSV_ACCOUNT_POST_TEMP_FOLDER + File.separator + index;
        return result;
    }

    public static String getAccountCsvFolderName(String index) {
        String result = ALCsvTokenizer.CSV_TEMP_FOLDER + File.separator + CSV_ACCOUNT_TEMP_FOLDER + File.separator + index;
        return result;
    }
}

