/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALCsvAbstractSelectData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileio.FileIOScheduleCsvData;
import com.aimluck.eip.fileio.FileIOScheduleCsvFormData;
import com.aimluck.eip.fileio.util.FileIOScheduleCsvUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOScheduleCsvSelectData
extends ALCsvAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOScheduleCsvSelectData.class.getName());
    private String autotime_flg;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.autotime_flg = "";
        super.initField();
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            if (this.stats == 0) {
                return this.readScheduleInfoFromCsv(rundata);
            }
            if (this.stats == 1) {
                String filepath = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + File.separator + "schedule_info.csv";
                return this.readScheduleInfoFromCsvPage(rundata, filepath, rundata.getParameters().getInteger("csvpage") - 1, 1000);
            }
            if (this.stats == 2) {
                String filepath = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + File.separator + "schedule_info_error.csv";
                return this.readScheduleInfoFromCsvPage(rundata, filepath, 0, 100);
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    private List readScheduleInfoFromCsv(RunData rundata) throws Exception {
        String filepath = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + File.separator + "schedule_info.csv";
        String filepath_err = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + File.separator + "schedule_info_error.csv";
        ALCsvTokenizer reader = new ALCsvTokenizer();
        if (!reader.init(filepath)) {
            return null;
        }
        ArrayList<FileIOScheduleCsvData> list = new ArrayList<FileIOScheduleCsvData>();
        int ErrCount = 0;
        Date now = new Date();
        int line = 0;
        String ErrorCode = "";
        while (reader.eof != -1) {
            int j;
            ++line;
            boolean b_err = false;
            ArrayList errmsg = new ArrayList();
            FileIOScheduleCsvFormData formData = new FileIOScheduleCsvFormData();
            formData.initField();
            formData.setIsAutoTime(this.autotime_flg);
            String e_line = "";
            for (j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                if (j > 0) {
                    e_line = e_line + ",";
                }
                e_line = e_line + "\"";
                e_line = e_line + this.makeOutputItem(token);
                e_line = e_line + "\"";
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            ++j;
            while (j < this.sequency.size()) {
                e_line = e_line + ",\"\"";
                ++j;
            }
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                b_err = true;
            }
            if (reader.eof == -1) break;
            try {
                ALDateTimeField date = new ALDateTimeField("yyyy/MM/dd HH:mm");
                ALEipUser user = ALEipUtils.getALEipUser((String)formData.getUserName().getValue());
                if (user == null) {
                    user = new ALEipUser();
                    user.initField();
                    user.setAliasName(formData.getUserFirstName().toString(), formData.getUserLastName().toString());
                    b_err = true;
                }
                try {
                    formData.getUserName();
                }
                catch (Exception e) {
                    b_err = true;
                }
                FileIOScheduleCsvData data = new FileIOScheduleCsvData();
                data.setUser(user);
                data.initField();
                data.setLineCount(line);
                data.setName(formData.getScheduleName().getValue());
                if (data.getName().toString().equals("")) {
                    b_err = true;
                }
                data.setPlace(formData.getPlace().getValue());
                data.setNote(formData.getNote().getValue());
                try {
                    date.setValue(formData.getCreateDate().toString());
                    data.setUpdateDate(date.getValue());
                }
                catch (Exception e) {
                    data.setUpdateDate(now);
                }
                try {
                    date.setValue(formData.getStartDateTime().toString());
                    data.setStartDate(date.getValue());
                }
                catch (Exception e) {
                    data.setStartDate(null);
                    b_err = true;
                }
                try {
                    date.setValue(formData.getEndDateTime().toString());
                    data.setEndDate(date.getValue());
                }
                catch (Exception e) {
                    data.setEndDate(null);
                    b_err = true;
                }
                data.setIsError(b_err);
                if (b_err) {
                    ErrorCode = ErrorCode + e_line;
                    ErrorCode = ErrorCode + "," + Integer.toString(line);
                    ErrorCode = ErrorCode + "\n";
                }
                if (!formData.getUserFullName().toString().equals("\u540d\u524d")) {
                    if (ErrCount == 0) {
                        if (!b_err) {
                            if (list.size() < 1000) {
                                list.add(data);
                            }
                        } else {
                            list.add(data);
                            ++ErrCount;
                        }
                    } else {
                        if (b_err) {
                            ++ErrCount;
                        }
                        list.add(data);
                    }
                } else {
                    if (ErrCount > 0) {
                        --ErrCount;
                    }
                    int lc = this.getLineCount();
                    this.setLineCount(lc - 1);
                }
                if (ErrCount >= 100) {
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)"readError", (Throwable)e);
            }
            if (reader.eof != -1) continue;
            break;
        }
        this.setErrorCount(ErrCount);
        if (ErrCount > 0) {
            this.outputErrorData(rundata, ErrorCode, filepath_err);
        }
        return list;
    }

    private List readScheduleInfoFromCsvPage(RunData rundata, String filepath, int StartLine, int LineLimit) throws Exception {
        ALCsvTokenizer reader = new ALCsvTokenizer();
        int line_index = StartLine * 1000;
        if (!reader.setStartLine(filepath, line_index)) {
            return null;
        }
        ArrayList<FileIOScheduleCsvData> list = new ArrayList<FileIOScheduleCsvData>();
        Date now = new Date();
        int line = 0;
        while (reader.eof != -1) {
            boolean b_err = false;
            if (++line > LineLimit) break;
            ArrayList errmsg = new ArrayList();
            FileIOScheduleCsvFormData formData = new FileIOScheduleCsvFormData();
            formData.initField();
            formData.setIsAutoTime(this.autotime_flg);
            for (int j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
                if (j != this.sequency.size() - 1 || this.stats != 2) continue;
                token = reader.nextToken();
                line = Integer.parseInt(token);
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            formData.setValidator();
            formData.validate(errmsg);
            if (reader.eof == -1) break;
            try {
                ALDateTimeField date = new ALDateTimeField("yyyy/MM/dd HH:mm");
                ALEipUser user = ALEipUtils.getALEipUser((String)formData.getUserName().getValue());
                if (user == null) {
                    user = new ALEipUser();
                    user.initField();
                    user.setAliasName(formData.getUserFirstName().toString(), formData.getUserLastName().toString());
                    b_err = true;
                }
                FileIOScheduleCsvData data = new FileIOScheduleCsvData();
                data.setUser(user);
                data.initField();
                data.setLineCount(line + line_index);
                data.setName(formData.getScheduleName().getValue());
                if (data.getName().toString().equals("")) {
                    b_err = true;
                }
                data.setPlace(formData.getPlace().getValue());
                data.setNote(formData.getNote().getValue());
                try {
                    date.setValue(formData.getCreateDate().toString());
                    data.setUpdateDate(date.getValue());
                }
                catch (Exception e) {
                    b_err = true;
                    data.setUpdateDate(now);
                }
                try {
                    date.setValue(formData.getStartDateTime().toString());
                    data.setStartDate(date.getValue());
                }
                catch (Exception e) {
                    b_err = true;
                    data.setStartDate(null);
                }
                try {
                    date.setValue(formData.getEndDateTime().toString());
                    data.setEndDate(date.getValue());
                }
                catch (Exception e) {
                    b_err = true;
                    data.setEndDate(null);
                }
                data.setIsError(b_err);
                if (!formData.getUserFullName().toString().equals("\u540d\u524d")) {
                    list.add(data);
                }
            }
            catch (Exception e) {
                logger.error((Object)"readError");
            }
            if (reader.eof != -1) continue;
            break;
        }
        return list;
    }

    public void setIsAutoTime(String flag) {
        this.autotime_flg = flag;
    }
}

