/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOScheduleCsvFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOScheduleCsvFormData.class.getName());
    private DataContext dataContext;
    public static final String DEFAULT_VIEW_PASSWORD = "*";
    private ALStringField username;
    private ALStringField userfirstname;
    private ALStringField userlastname;
    private ALStringField userfullname;
    private ALStringField schedulename;
    private ALStringField place;
    private ALStringField note;
    private ALDateTimeField create_date;
    private ALDateTimeField start_date;
    private ALDateTimeField end_date;
    private ALDateTimeField start_time;
    private ALDateTimeField end_time;
    private ALDateTimeField start_date_time;
    private ALDateTimeField end_date_time;
    private boolean is_auto_time;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        super.init(action, rundata, context);
    }

    public void initField() {
        this.username = new ALStringField();
        this.username.setFieldName("\u30ed\u30b0\u30a4\u30f3\u540d");
        this.username.setTrim(true);
        this.userfullname = new ALStringField();
        this.userfullname.setFieldName("\u30ed\u30b0\u30a4\u30f3ID");
        this.userfullname.setTrim(true);
        this.userfirstname = new ALStringField();
        this.userfirstname.setFieldName("\u540d\u524d");
        this.userfirstname.setTrim(true);
        this.userlastname = new ALStringField();
        this.userlastname.setFieldName("\u540d\u5b57");
        this.userlastname.setTrim(true);
        this.schedulename = new ALStringField();
        this.schedulename.setFieldName("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        this.schedulename.setTrim(true);
        this.schedulename.setValue("");
        this.place = new ALStringField();
        this.place.setFieldName("\u5834\u6240");
        this.place.setTrim(true);
        this.place.setValue("");
        this.note = new ALStringField();
        this.note.setFieldName("\u5185\u5bb9");
        this.note.setTrim(true);
        this.note.setValue("");
        this.create_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.create_date.setFieldName("\u5165\u529b\u65e5\u6642");
        this.create_date.setValue("");
        this.start_date = new ALDateTimeField("yyyy/MM/dd");
        this.start_date.setFieldName("\u958b\u59cb\u65e5\u4ed8");
        this.end_date = new ALDateTimeField("yyyy/MM/dd");
        this.end_date.setFieldName("\u7d42\u4e86\u65e5\u4ed8");
        this.start_time = new ALDateTimeField("HH:mm");
        this.start_time.setFieldName("\u958b\u59cb\u6642\u523b");
        this.end_time = new ALDateTimeField("HH:mm");
        this.end_time.setFieldName("\u7d42\u4e86\u6642\u523b");
        this.start_date_time = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.start_date_time.setFieldName("\u958b\u59cb\u65e5\u6642");
        this.end_date_time = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.end_date_time.setFieldName("\u7d42\u4e86\u65e5\u6642");
        this.start_date_time.setValue("");
        this.end_date_time.setValue("");
        this.start_date.setValue("");
        this.end_date.setValue("");
        this.start_time.setValue("");
        this.end_time.setValue("");
        this.is_auto_time = false;
    }

    protected void setValidator() {
        this.username.limitMaxLength(16);
        this.userfullname.limitMaxLength(40);
        this.userfirstname.limitMaxLength(20);
        this.userlastname.limitMaxLength(20);
        this.schedulename.setNotNull(true);
        this.schedulename.limitMaxLength(50);
        this.place.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) {
        String usernamestr = this.username.getValue();
        if ("admin".equals(usernamestr) || "template".equals(usernamestr) || "anon".equals(usernamestr) || !this.username.validate(msgList)) {
            this.username.setValue(null);
        }
        if (!this.userfullname.validate(msgList)) {
            this.userfullname.setValue(null);
        }
        if (!this.userfirstname.validate(msgList)) {
            this.userfirstname.setValue(null);
        }
        if (!this.userlastname.validate(msgList)) {
            this.userlastname.setValue(null);
        }
        if (!this.schedulename.validate(msgList)) {
            this.schedulename.setValue(null);
        }
        if (!this.place.validate(msgList)) {
            this.place.setValue(null);
        }
        if (!this.note.validate(msgList)) {
            this.note.setValue(null);
        }
        if (!this.create_date.validate(msgList)) {
            Date now = new Date();
            this.create_date.setValue(now);
        }
        if (!this.start_date.validate(msgList)) {
            this.start_date.setValue("");
            msgList.add("\u300e <span class='em'>\u958b\u59cb\u65e5\u4ed8</span> \u300f\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!this.end_date.validate(msgList)) {
            this.end_date.setValue("");
            msgList.add("\u300e <span class='em'>\u7d42\u4e86\u65e5\u4ed8</span> \u300f\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!this.start_date.toString().equals("") && !this.end_date.toString().equals("")) {
            if (this.is_auto_time) {
                if (this.start_time.toString().equals("") && this.end_time.toString().equals("")) {
                    this.setStartTime("00:00");
                    this.setEndTime("00:00");
                }
            } else if (this.start_time.toString().equals("") && this.end_time.toString().equals("")) {
                msgList.add("\u300e <span class='em'>\u958b\u59cb,\u7d42\u4e86\u6642\u523b</span> \u300f\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            if (this.compareToDate(this.start_date.getValue(), this.end_date.getValue()) != 0) {
                msgList.add("\u65e5\u4ed8\u3092\u8de8\u3044\u3067\u306e\u5165\u529b\u306f\u51fa\u6765\u307e\u305b\u3093\u3002");
            }
        }
        if (!this.start_time.validate(msgList)) {
            this.start_time.setValue("");
            msgList.add("\u300e <span class='em'>\u958b\u59cb\u6642\u523b</span> \u300f\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!this.end_time.validate(msgList)) {
            this.end_time.setValue("");
            msgList.add("\u300e <span class='em'>\u7d42\u4e86\u6642\u523b</span> \u300f\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        try {
            this.getStartDateTime();
            this.getEndDateTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.start_date_time.validate(msgList)) {
            this.start_date_time.setValue("");
            msgList.add("\u300e <span class='em'>\u958b\u59cb\u65e5\u6642</span> \u300f\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!this.end_date_time.validate(msgList)) {
            this.end_date_time.setValue("");
            msgList.add("\u300e <span class='em'>\u7d42\u4e86\u65e5\u6642</span> \u300f\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (!this.end_date_time.toString().equals("") && !this.start_date_time.toString().equals("") && this.end_date_time.getValue().before(this.start_date_time.getValue())) {
            msgList.add("\u300e <span class='em'>\u7d42\u4e86\u65e5\u6642</span> \u300f\u306f\u300e <span class='em'>\u958b\u59cb\u65e5\u6642</span> \u300f\u4ee5\u964d\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            this.start_date.setValue("");
            this.end_date.setValue("");
            this.start_time.setValue("");
            this.end_time.setValue("");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
            memberList.add(ALEipUtils.getALEipUser((String)this.username.getValue()));
            GregorianCalendar startcal = new GregorianCalendar();
            startcal.setTime(this.start_date_time.getValue());
            Calendar endcal = Calendar.getInstance();
            endcal.setTime(this.end_date_time.getValue());
            endcal.set(1, startcal.get(1));
            endcal.set(2, startcal.get(2));
            endcal.set(5, startcal.get(5));
            this.end_date_time.setValue(endcal.getTime());
            EipTSchedule schedule = (EipTSchedule)this.dataContext.createAndRegisterNewObject(EipTSchedule.class);
            schedule.setParentId(Integer.valueOf(1));
            schedule.setName(this.schedulename.getValue());
            schedule.setPlace(this.place.getValue());
            schedule.setNote(this.note.getValue());
            schedule.setPublicFlag("O");
            schedule.setEditFlag("O");
            Date now = new Date();
            schedule.setCreateDate(now);
            schedule.setUpdateDate(now);
            schedule.setStartDate(this.start_date_time.getValue());
            schedule.setEndDate(this.end_date_time.getValue());
            schedule.setRepeatPattern("N");
            schedule.setStartDate(this.start_date_time.getValue());
            EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)1L);
            int size = memberList.size();
            for (int i = 0; i < size; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                ALEipUser user = (ALEipUser)memberList.get(i);
                int userid = (int)user.getUserId().getValue();
                schedule.setOwnerId(Integer.valueOf(userid));
                schedule.setCreateUserId(Integer.valueOf(userid));
                schedule.setUpdateUserId(Integer.valueOf(userid));
                map.setEipTSchedule(schedule);
                map.setUserId(Integer.valueOf(userid));
                map.setCommonCategoryId(Integer.valueOf(1));
                map.setEipTCommonCategory(category);
                map.setStatus("O");
                map.setType("U");
            }
            this.dataContext.commitChanges();
        }
        catch (Exception e) {
            logger.error((Object)"[FileIOScheduleCsvFormData]", (Throwable)e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    private TurbineUser getTurbineUser() {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(TurbineUser.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"firstName", (Object)this.userfirstname);
        Expression exp2 = ExpressionFactory.matchExp((String)"lastName", (Object)this.userlastname);
        query.setQualifier(exp1.andExp(exp2));
        List users = dataContext.performQuery((Query)query);
        if (users == null || users.size() == 0) {
            logger.debug((Object)"[FileIOScheduleCsvFormData] Not found ID...");
            return null;
        }
        TurbineUser tuser = (TurbineUser)users.get(0);
        return tuser;
    }

    public ALStringField getUserName() {
        if ("".equals(this.username.toString())) {
            try {
                TurbineUser tuser = this.getTurbineUser();
                this.setUserName(tuser.getLoginName());
            }
            catch (Exception e) {
                this.setUserName("");
            }
        } else {
            try {
                ALEipUtils.getALEipUser((String)this.username.getValue());
            }
            catch (Exception e) {
                this.setUserName("");
            }
        }
        return this.username;
    }

    public ALStringField getUserFullName() {
        return this.userfullname;
    }

    public ALStringField getUserFirstName() {
        return this.userfirstname;
    }

    public ALStringField getUserLastName() {
        return this.userlastname;
    }

    public ALStringField getScheduleName() {
        return this.schedulename;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getPlace() {
        return this.place;
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public ALDateTimeField getStartDate() {
        return this.start_date;
    }

    public ALDateTimeField getEndDate() {
        return this.end_date;
    }

    public ALDateTimeField getStartTime() {
        return this.start_time;
    }

    public ALDateTimeField getEndTime() {
        return this.end_time;
    }

    public ALDateTimeField getStartDateTime() {
        Calendar cal = Calendar.getInstance();
        if ("".equals(this.start_date_time.toString())) {
            cal.set(1, Integer.parseInt(this.start_date.getYear()));
            cal.set(2, Integer.parseInt(this.start_date.getMonth()) - 1);
            cal.set(5, Integer.parseInt(this.start_date.getDay()));
            cal.set(11, Integer.parseInt(this.start_time.getHour()));
            cal.set(12, Integer.parseInt(this.start_time.getMinute()));
            Date date = cal.getTime();
            this.start_date_time.setValue(date);
        }
        return this.start_date_time;
    }

    public ALDateTimeField getEndDateTime() {
        Calendar cal = Calendar.getInstance();
        if ("".equals(this.end_date_time.toString())) {
            cal.set(1, Integer.parseInt(this.end_date.getYear()));
            cal.set(2, Integer.parseInt(this.end_date.getMonth()) - 1);
            cal.set(5, Integer.parseInt(this.end_date.getDay()));
            cal.set(11, Integer.parseInt(this.end_time.getHour()));
            cal.set(12, Integer.parseInt(this.end_time.getMinute()));
            Date date = cal.getTime();
            this.end_date_time.setValue(date);
        }
        return this.end_date_time;
    }

    public void setUserName(String str) {
        this.username.setValue(str);
    }

    public void setUserFullName(String str) {
        this.userfullname.setValue(str);
    }

    public void setUserFirstName(String str) {
        this.userfirstname.setValue(str);
    }

    public void setUserLastName(String str) {
        this.userlastname.setValue(str);
    }

    public void setScheduleName(String str) {
        this.schedulename.setValue(str);
    }

    public void setNote(String str) {
        this.note.setValue(str);
    }

    public void setPlace(String str) {
        this.place.setValue(str);
    }

    public void setCreateDate(String str) {
        this.create_date.setValue(str);
    }

    public void setStartDate(String str) {
        this.start_date.setValue(str);
    }

    public void setEndDate(String str) {
        this.end_date.setValue(str);
    }

    public void setStartTime(String str) {
        this.start_time.setValue(str);
    }

    public void setEndTime(String str) {
        this.end_time.setValue(str);
    }

    public void setStartDateTime(String str) {
        this.start_date_time.setValue(str);
    }

    public void setEndDateTime(String str) {
        this.end_date_time.setValue(str);
    }

    public void setCreateDate(Date date) {
        this.create_date.setValue(date);
    }

    public void setStartDate(Date date) {
        this.start_date.setValue(date);
    }

    public void setEndDate(Date date) {
        this.end_date.setValue(date);
    }

    public void setStartTime(Date date) {
        this.start_time.setValue(date);
    }

    public void setEndTime(Date date) {
        this.end_time.setValue(date);
    }

    public void setStartDate_Time(Date date) {
        this.start_date_time.setValue(date);
    }

    public void setEndDateTime(Date date) {
        this.end_date_time.setValue(date);
    }

    public void setIsAutoTime(String flag) {
        this.is_auto_time = Integer.parseInt(flag) == 1;
    }

    private int compareToDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day) {
            return 0;
        }
        if (cal1.after(cal2)) {
            return 2;
        }
        return 1;
    }

    public void addItemToken(String token, int i) {
        switch (i) {
            case -1: {
                break;
            }
            case 0: {
                StringTokenizer st = new StringTokenizer(token);
                String Fullname = "";
                if (st.hasMoreTokens()) {
                    this.setUserLastName(st.nextToken());
                    Fullname = Fullname + this.getUserLastName().toString();
                }
                if (st.hasMoreTokens()) {
                    this.setUserFirstName(st.nextToken());
                    Fullname = Fullname + this.getUserFirstName().toString();
                }
                this.setUserFullName(Fullname);
                break;
            }
            case 1: {
                this.setScheduleName(token);
                break;
            }
            case 2: {
                this.setPlace(token);
                break;
            }
            case 3: {
                this.setNote(token);
                break;
            }
            case 4: {
                this.setStartDate(token);
                break;
            }
            case 5: {
                this.setEndDate(token);
                break;
            }
            case 6: {
                this.setStartTime(token);
                break;
            }
            case 7: {
                this.setEndTime(token);
                break;
            }
            case 8: {
                this.setUserName(token);
                break;
            }
            case 9: {
                this.setStartDateTime(token);
                break;
            }
            case 10: {
                this.setEndDateTime(token);
                break;
            }
        }
    }
}

