/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.schedule.ScheduleDetailResultData;
import java.util.Calendar;
import java.util.Date;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class FileIOScheduleCsvData
extends ScheduleDetailResultData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOScheduleCsvData.class.getName());
    private int line_count;
    private ALStringField note;
    private boolean is_error;

    public int getLineCount() {
        return this.line_count;
    }

    public void initField() {
        super.initField();
        this.note = new ALStringField();
        this.note.setTrim(false);
        this.is_error = false;
    }

    public void setLineCount(int i) {
        this.line_count = i;
    }

    public boolean isTimeError() {
        ALDateTimeField start_date = this.getStartDate();
        ALDateTimeField end_date = this.getEndDate();
        return !start_date.toString().equals("") && !end_date.toString().equals("") && end_date.getValue().before(start_date.getValue());
    }

    public boolean isDateError() {
        ALDateTimeField start_date = this.getStartDate();
        ALDateTimeField end_date = this.getEndDate();
        return !start_date.toString().equals("") && !end_date.toString().equals("") && this.compareToDate(start_date.getValue(), end_date.getValue()) != 0;
    }

    public ALStringField getNoteField() {
        return this.note;
    }

    public void setNote(String string) {
        super.setNote(string);
        this.note.setValue(string);
    }

    private int compareToDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day) {
            return 0;
        }
        if (cal1.after(cal2)) {
            return 2;
        }
        return 1;
    }

    public boolean getIsError() {
        return this.is_error;
    }

    public void setIsError(boolean flg) {
        this.is_error = flg;
    }
}

